/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.processdefinitions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;

public class ProcessDefinitionsTest
extends PluggableProcessEngineTestCase {
    private static final String NAMESPACE = "xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL'";
    private static final String TARGET_NAMESPACE = "targetNamespace='http://activiti.org/BPMN20'";

    public void testGetProcessDefinitions() {
        ArrayList<String> deploymentIds = new ArrayList<String>();
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' targetNamespace='http://activiti.org/BPMN20'>  <process id='IDR' name='Insurance Damage Report 1' /></definitions>"));
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' targetNamespace='http://activiti.org/BPMN20'>  <process id='IDR' name='Insurance Damage Report 2' /></definitions>"));
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' targetNamespace='http://activiti.org/BPMN20'>  <process id='IDR' name='Insurance Damage Report 3' /></definitions>"));
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' targetNamespace='http://activiti.org/BPMN20'>  <process id='EN' name='Expense Note 1' /></definitions>"));
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' targetNamespace='http://activiti.org/BPMN20'>  <process id='EN' name='Expense Note 2' /></definitions>"));
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionKey().asc()).orderByProcessDefinitionVersion().desc()).list();
        ProcessDefinitionsTest.assertNotNull((Object)processDefinitions);
        ProcessDefinitionsTest.assertEquals((int)5, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        ProcessDefinitionsTest.assertEquals((String)"EN", (String)processDefinition.getKey());
        ProcessDefinitionsTest.assertEquals((String)"Expense Note 2", (String)processDefinition.getName());
        ProcessDefinitionsTest.assertTrue((boolean)processDefinition.getId().startsWith("EN:2"));
        ProcessDefinitionsTest.assertEquals((int)2, (int)processDefinition.getVersion());
        processDefinition = (ProcessDefinition)processDefinitions.get(1);
        ProcessDefinitionsTest.assertEquals((String)"EN", (String)processDefinition.getKey());
        ProcessDefinitionsTest.assertEquals((String)"Expense Note 1", (String)processDefinition.getName());
        ProcessDefinitionsTest.assertTrue((boolean)processDefinition.getId().startsWith("EN:1"));
        ProcessDefinitionsTest.assertEquals((int)1, (int)processDefinition.getVersion());
        processDefinition = (ProcessDefinition)processDefinitions.get(2);
        ProcessDefinitionsTest.assertEquals((String)"IDR", (String)processDefinition.getKey());
        ProcessDefinitionsTest.assertEquals((String)"Insurance Damage Report 3", (String)processDefinition.getName());
        ProcessDefinitionsTest.assertTrue((boolean)processDefinition.getId().startsWith("IDR:3"));
        ProcessDefinitionsTest.assertEquals((int)3, (int)processDefinition.getVersion());
        processDefinition = (ProcessDefinition)processDefinitions.get(3);
        ProcessDefinitionsTest.assertEquals((String)"IDR", (String)processDefinition.getKey());
        ProcessDefinitionsTest.assertEquals((String)"Insurance Damage Report 2", (String)processDefinition.getName());
        ProcessDefinitionsTest.assertTrue((boolean)processDefinition.getId().startsWith("IDR:2"));
        ProcessDefinitionsTest.assertEquals((int)2, (int)processDefinition.getVersion());
        processDefinition = (ProcessDefinition)processDefinitions.get(4);
        ProcessDefinitionsTest.assertEquals((String)"IDR", (String)processDefinition.getKey());
        ProcessDefinitionsTest.assertEquals((String)"Insurance Damage Report 1", (String)processDefinition.getName());
        ProcessDefinitionsTest.assertTrue((boolean)processDefinition.getId().startsWith("IDR:1"));
        ProcessDefinitionsTest.assertEquals((int)1, (int)processDefinition.getVersion());
        this.deleteDeployments(deploymentIds);
    }

    public void testDeployIdenticalProcessDefinitions() {
        ArrayList<String> deploymentIds = new ArrayList<String>();
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' targetNamespace='http://activiti.org/BPMN20'>  <process id='IDR' name='Insurance Damage Report' /></definitions>"));
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' targetNamespace='http://activiti.org/BPMN20'>  <process id='IDR' name='Insurance Damage Report' /></definitions>"));
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionKey().asc()).orderByProcessDefinitionVersion().desc()).list();
        ProcessDefinitionsTest.assertNotNull((Object)processDefinitions);
        ProcessDefinitionsTest.assertEquals((int)2, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        ProcessDefinitionsTest.assertEquals((String)"IDR", (String)processDefinition.getKey());
        ProcessDefinitionsTest.assertEquals((String)"Insurance Damage Report", (String)processDefinition.getName());
        ProcessDefinitionsTest.assertTrue((boolean)processDefinition.getId().startsWith("IDR:2"));
        ProcessDefinitionsTest.assertEquals((int)2, (int)processDefinition.getVersion());
        processDefinition = (ProcessDefinition)processDefinitions.get(1);
        ProcessDefinitionsTest.assertEquals((String)"IDR", (String)processDefinition.getKey());
        ProcessDefinitionsTest.assertEquals((String)"Insurance Damage Report", (String)processDefinition.getName());
        ProcessDefinitionsTest.assertTrue((boolean)processDefinition.getId().startsWith("IDR:1"));
        ProcessDefinitionsTest.assertEquals((int)1, (int)processDefinition.getVersion());
        this.deleteDeployments(deploymentIds);
    }

    private String deployProcessString(String processString) {
        String resourceName = "xmlString." + BpmnDeployer.BPMN_RESOURCE_SUFFIXES[0];
        return this.repositoryService.createDeployment().addString(resourceName, processString).deploy().getId();
    }

    private void deleteDeployments(Collection<String> deploymentIds) {
        for (String deploymentId : deploymentIds) {
            this.repositoryService.deleteDeployment(deploymentId);
        }
    }
}

