/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.variables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class VariablesTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testBasicVariableOperations() {
        Date now = new Date();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        byte[] bytes = "somebytes".getBytes();
        Map variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "coca-cola");
        variables.put("dateVar", now);
        variables.put("nullVar", null);
        variables.put("serializableVar", serializable);
        variables.put("bytesVar", bytes);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskAssigneeProcess", variables);
        variables = this.runtimeService.getVariables(processInstance.getId());
        VariablesTest.assertEquals((Object)928374L, variables.get("longVar"));
        VariablesTest.assertEquals((Object)123, variables.get("shortVar"));
        VariablesTest.assertEquals((Object)1234, variables.get("integerVar"));
        VariablesTest.assertEquals((Object)"coca-cola", variables.get("stringVar"));
        VariablesTest.assertEquals((Object)now, variables.get("dateVar"));
        VariablesTest.assertEquals(null, variables.get("nullVar"));
        VariablesTest.assertEquals(serializable, variables.get("serializableVar"));
        VariablesTest.assertTrue((boolean)Arrays.equals(bytes, (byte[])variables.get("bytesVar")));
        VariablesTest.assertEquals((int)8, (int)variables.size());
        this.runtimeService.setVariable(processInstance.getId(), "longVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "shortVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "integerVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "stringVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "dateVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "nullVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "serializableVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "bytesVar", null);
        variables = this.runtimeService.getVariables(processInstance.getId());
        VariablesTest.assertEquals(null, variables.get("longVar"));
        VariablesTest.assertEquals(null, variables.get("shortVar"));
        VariablesTest.assertEquals(null, variables.get("integerVar"));
        VariablesTest.assertEquals(null, variables.get("stringVar"));
        VariablesTest.assertEquals(null, variables.get("dateVar"));
        VariablesTest.assertEquals(null, variables.get("nullVar"));
        VariablesTest.assertEquals(null, variables.get("serializableVar"));
        VariablesTest.assertEquals(null, variables.get("bytesVar"));
        VariablesTest.assertEquals((int)8, (int)variables.size());
        this.runtimeService.setVariable(processInstance.getId(), "new var", (Object)"hi");
        this.runtimeService.setVariable(processInstance.getId(), "longVar", (Object)9987L);
        this.runtimeService.setVariable(processInstance.getId(), "shortVar", (Object)456);
        this.runtimeService.setVariable(processInstance.getId(), "integerVar", (Object)4567);
        this.runtimeService.setVariable(processInstance.getId(), "stringVar", (Object)"colgate");
        this.runtimeService.setVariable(processInstance.getId(), "dateVar", (Object)now);
        this.runtimeService.setVariable(processInstance.getId(), "serializableVar", serializable);
        this.runtimeService.setVariable(processInstance.getId(), "bytesVar", (Object)bytes);
        variables = this.runtimeService.getVariables(processInstance.getId());
        VariablesTest.assertEquals((Object)"hi", variables.get("new var"));
        VariablesTest.assertEquals((Object)9987L, variables.get("longVar"));
        VariablesTest.assertEquals((Object)456, variables.get("shortVar"));
        VariablesTest.assertEquals((Object)4567, variables.get("integerVar"));
        VariablesTest.assertEquals((Object)"colgate", variables.get("stringVar"));
        VariablesTest.assertEquals((Object)now, variables.get("dateVar"));
        VariablesTest.assertEquals(null, variables.get("nullVar"));
        VariablesTest.assertEquals(serializable, variables.get("serializableVar"));
        VariablesTest.assertTrue((boolean)Arrays.equals(bytes, (byte[])variables.get("bytesVar")));
        VariablesTest.assertEquals((int)9, (int)variables.size());
        ArrayList<String> varFilter = new ArrayList<String>(2);
        varFilter.add("stringVar");
        varFilter.add("integerVar");
        Map filteredVariables = this.runtimeService.getVariables(processInstance.getId(), varFilter);
        VariablesTest.assertEquals((int)2, (int)filteredVariables.size());
        VariablesTest.assertTrue((boolean)filteredVariables.containsKey("stringVar"));
        VariablesTest.assertTrue((boolean)filteredVariables.containsKey("integerVar"));
        this.runtimeService.setVariable(processInstance.getId(), "nullVar", (Object)"a value");
        Object newValue = this.runtimeService.getVariable(processInstance.getId(), "nullVar");
        VariablesTest.assertNotNull((Object)newValue);
        VariablesTest.assertEquals((Object)"a value", (Object)newValue);
    }
}

