/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class HistoricActivityInstanceStateTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testSingleEndEvent() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "start", 1);
        this.assertNonCanceledActivityInstance(allInstances, "start");
        this.assertIsCompletingActivityInstances(allInstances, "end", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end");
    }

    @Deployment
    public void testSingleEndActivity() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "start", 1);
        this.assertNonCanceledActivityInstance(allInstances, "start");
        this.assertIsCompletingActivityInstances(allInstances, "end", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end");
    }

    @Deployment
    public void testSingleEndEventAfterParallelJoin() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "parallelJoin", 2);
        this.assertNonCanceledActivityInstance(allInstances, "parallelJoin");
        this.assertIsCompletingActivityInstances(allInstances, "end", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end");
    }

    @Deployment
    public void testEndParallelJoin() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "task1", 1);
        this.assertNonCanceledActivityInstance(allInstances, "task1");
        this.assertNonCompletingActivityInstance(allInstances, "task2", 1);
        this.assertNonCanceledActivityInstance(allInstances, "task2");
        this.assertIsCompletingActivityInstances(allInstances, "parallelJoinEnd", 2);
        this.assertNonCanceledActivityInstance(allInstances, "parallelJoinEnd");
    }

    @Deployment
    public void testTwoEndEvents() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "parallelSplit", 1);
        this.assertNonCanceledActivityInstance(allInstances, "parallelSplit", 1);
        this.assertIsCompletingActivityInstances(allInstances, "end1", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end1");
        this.assertIsCompletingActivityInstances(allInstances, "end2", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end2");
    }

    @Deployment
    public void testTwoEndActivities() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "parallelSplit", 1);
        this.assertNonCanceledActivityInstance(allInstances, "parallelSplit");
        this.assertIsCompletingActivityInstances(allInstances, "end1", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end1");
        this.assertIsCompletingActivityInstances(allInstances, "end2", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end2");
    }

    @Deployment
    public void testSingleEndEventAndSingleEndActivity() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "parallelSplit", 1);
        this.assertNonCanceledActivityInstance(allInstances, "parallelSplit");
        this.assertIsCompletingActivityInstances(allInstances, "end1");
        this.assertNonCanceledActivityInstance(allInstances, "end1");
        this.assertIsCompletingActivityInstances(allInstances, "end2");
        this.assertNonCanceledActivityInstance(allInstances, "end2");
    }

    @Deployment
    public void testSimpleSubProcess() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "intermediateSubprocess", 1);
        this.assertNonCanceledActivityInstance(allInstances, "intermediateSubprocess");
        this.assertIsCompletingActivityInstances(allInstances, "subprocessEnd", 1);
        this.assertNonCanceledActivityInstance(allInstances, "subprocessEnd");
        this.assertIsCompletingActivityInstances(allInstances, "end", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end");
    }

    @Deployment
    public void testParallelMultiInstanceSubProcess() {
        this.startProcess();
        List<HistoricActivityInstance> activityInstances = this.getEndActivityInstances();
        HistoricActivityInstanceStateTest.assertEquals((int)4, (int)activityInstances.size());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "intermediateSubprocess");
        this.assertNonCanceledActivityInstance(allInstances, "intermediateSubprocess");
        this.assertIsCompletingActivityInstances(allInstances, "subprocessEnd", 3);
        this.assertNonCanceledActivityInstance(allInstances, "subprocessEnd");
        this.assertIsCompletingActivityInstances(allInstances, "end", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end");
    }

    @Deployment
    public void testSequentialMultiInstanceSubProcess() {
        this.startProcess();
        List<HistoricActivityInstance> activityInstances = this.getEndActivityInstances();
        HistoricActivityInstanceStateTest.assertEquals((int)4, (int)activityInstances.size());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "intermediateSubprocess");
        this.assertNonCanceledActivityInstance(allInstances, "intermediateSubprocess");
        this.assertIsCompletingActivityInstances(allInstances, "subprocessEnd", 3);
        this.assertNonCanceledActivityInstance(allInstances, "subprocessEnd");
        this.assertIsCompletingActivityInstances(allInstances, "end", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end");
    }

    @Deployment
    public void testIntermediateTask() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "intermediateTask", 1);
        this.assertNonCanceledActivityInstance(allInstances, "intermediateTask");
        this.assertIsCompletingActivityInstances(allInstances, "end", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end");
    }

    @Deployment
    public void testBoundaryErrorCancel() {
        ProcessInstance processInstance = this.startProcess();
        HistoricActivityInstanceStateTest.assertTrue((boolean)processInstance.isEnded());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCanceledActivityInstance(allInstances, "start");
        this.assertNonCompletingActivityInstance(allInstances, "start");
        this.assertNonCanceledActivityInstance(allInstances, "subprocessStart");
        this.assertNonCompletingActivityInstance(allInstances, "subprocessStart");
        this.assertNonCanceledActivityInstance(allInstances, "gtw");
        this.assertNonCompletingActivityInstance(allInstances, "gtw");
        this.assertIsCanceledActivityInstances(allInstances, "subprocess", 1);
        this.assertNonCompletingActivityInstance(allInstances, "subprocess");
        this.assertIsCanceledActivityInstances(allInstances, "errorSubprocessEnd", 1);
        this.assertNonCompletingActivityInstance(allInstances, "errorSubprocessEnd");
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertNonCanceledActivityInstance(allInstances, "subprocessBoundary");
        this.assertNonCompletingActivityInstance(allInstances, "subprocessBoundary");
        this.assertNonCanceledActivityInstance(allInstances, "endAfterBoundary");
        this.assertIsCompletingActivityInstances(allInstances, "endAfterBoundary", 1);
    }

    @Deployment
    public void testBoundarySignalCancel() {
        ProcessInstance processInstance = this.startProcess();
        HistoricActivityInstanceStateTest.assertFalse((boolean)processInstance.isEnded());
        this.runtimeService.signalEventReceived("interrupt");
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "subprocess");
        this.assertIsCanceledActivityInstances(allInstances, "subprocess", 1);
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertNonCanceledActivityInstance(allInstances, "subprocessBoundary");
        this.assertNonCompletingActivityInstance(allInstances, "subprocessBoundary");
        this.assertNonCanceledActivityInstance(allInstances, "endAfterBoundary");
        this.assertIsCompletingActivityInstances(allInstances, "endAfterBoundary", 1);
    }

    @Deployment
    public void testEventSubprocessErrorCancel() {
        ProcessInstance processInstance = this.startProcess();
        HistoricActivityInstanceStateTest.assertTrue((boolean)processInstance.isEnded());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertIsCanceledActivityInstances(allInstances, "errorEnd", 1);
        this.assertNonCompletingActivityInstance(allInstances, "errorEnd");
        this.assertNonCanceledActivityInstance(allInstances, "eventSubprocessStart");
        this.assertNonCompletingActivityInstance(allInstances, "eventSubprocessStart");
        this.assertNonCanceledActivityInstance(allInstances, "eventSubprocessEnd");
        this.assertIsCompletingActivityInstances(allInstances, "eventSubprocessEnd", 1);
    }

    @Deployment
    public void testEventSubprocessSignalCancel() {
        ProcessInstance processInstance = this.startProcess();
        HistoricActivityInstanceStateTest.assertTrue((boolean)processInstance.isEnded());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertIsCanceledActivityInstances(allInstances, "signalEnd", 1);
        this.assertNonCompletingActivityInstance(allInstances, "signalEnd");
        this.assertNonCanceledActivityInstance(allInstances, "eventSubprocessStart");
        this.assertNonCompletingActivityInstance(allInstances, "eventSubprocessStart");
        this.assertNonCanceledActivityInstance(allInstances, "eventSubprocessEnd");
        this.assertIsCompletingActivityInstances(allInstances, "eventSubprocessEnd", 1);
    }

    @Deployment
    public void testEndTerminateEventCancel() {
        ProcessInstance processInstance = this.startProcess();
        HistoricActivityInstanceStateTest.assertTrue((boolean)processInstance.isEnded());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertNonCanceledActivityInstance(allInstances, "terminateEnd");
        this.assertIsCompletingActivityInstances(allInstances, "terminateEnd", 1);
    }

    @Deployment
    public void testEndTerminateEventCancelInSubprocess() {
        ProcessInstance processInstance = this.startProcess();
        HistoricActivityInstanceStateTest.assertTrue((boolean)processInstance.isEnded());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "subprocess");
        this.assertNonCanceledActivityInstance(allInstances, "subprocess");
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertNonCanceledActivityInstance(allInstances, "terminateEnd");
        this.assertIsCompletingActivityInstances(allInstances, "terminateEnd", 1);
        this.assertIsCompletingActivityInstances(allInstances, "end", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end");
    }

    @Deployment
    public void testEndTerminateEventCancelWithSubprocess() {
        ProcessInstance processInstance = this.startProcess();
        HistoricActivityInstanceStateTest.assertTrue((boolean)processInstance.isEnded());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCanceledActivityInstances(allInstances, "subprocess", 1);
        this.assertNonCompletingActivityInstance(allInstances, "subprocess");
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertNonCanceledActivityInstance(allInstances, "terminateEnd");
        this.assertIsCompletingActivityInstances(allInstances, "terminateEnd", 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityInstanceStateTest.testCancelProcessInstanceInUserTask.bpmn", "org/camunda/bpm/engine/test/history/HistoricActivityInstanceStateTest.testEndTerminateEventWithCallActivity.bpmn"})
    public void testEndTerminateEventCancelWithCallActivity() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process1");
        HistoricActivityInstanceStateTest.assertTrue((boolean)processInstance.isEnded());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCanceledActivityInstances(allInstances, "callActivity", 1);
        this.assertNonCompletingActivityInstance(allInstances, "callActivity");
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertNonCanceledActivityInstance(allInstances, "terminateEnd");
        this.assertIsCompletingActivityInstances(allInstances, "terminateEnd", 1);
    }

    @Deployment
    public void testCancelProcessInstanceInUserTask() {
        ProcessInstance processInstance = this.startProcess();
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
    }

    @Deployment
    public void testCancelProcessInstanceInSubprocess() {
        ProcessInstance processInstance = this.startProcess();
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertIsCanceledActivityInstances(allInstances, "subprocess", 1);
        this.assertNonCompletingActivityInstance(allInstances, "subprocess");
    }

    @Deployment
    public void testCancelProcessWithParallelGateway() {
        ProcessInstance processInstance = this.startProcess();
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCanceledActivityInstances(allInstances, "userTask1", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask1");
        this.assertIsCanceledActivityInstances(allInstances, "userTask2", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask2");
        this.assertIsCanceledActivityInstances(allInstances, "subprocess", 1);
        this.assertNonCompletingActivityInstance(allInstances, "subprocess");
    }

    private void assertIsCanceledActivityInstances(List<HistoricActivityInstance> allInstances, String activityId) {
        this.assertIsCanceledActivityInstances(allInstances, activityId, -1);
    }

    private void assertIsCanceledActivityInstances(List<HistoricActivityInstance> allInstances, String activityId, int count) {
        this.assertCorrectCanceledState(allInstances, activityId, count, true);
    }

    private void assertNonCanceledActivityInstance(List<HistoricActivityInstance> instances, String activityId) {
        this.assertNonCanceledActivityInstance(instances, activityId, -1);
    }

    private void assertNonCanceledActivityInstance(List<HistoricActivityInstance> instances, String activityId, int count) {
        this.assertCorrectCanceledState(instances, activityId, count, false);
    }

    private void assertCorrectCanceledState(List<HistoricActivityInstance> allInstances, String activityId, int expectedCount, boolean canceled) {
        int found = 0;
        for (HistoricActivityInstance instance : allInstances) {
            if (!instance.getActivityId().equals(activityId)) continue;
            ++found;
            HistoricActivityInstanceStateTest.assertEquals((String)String.format("expect <%s> to be %scanceled", activityId, canceled ? "" : "non-"), (boolean)canceled, (boolean)instance.isCanceled());
        }
        HistoricActivityInstanceStateTest.assertTrue((String)("contains entry for activity <" + activityId + ">"), (found > 0 ? 1 : 0) != 0);
        if (expectedCount != -1) {
            HistoricActivityInstanceStateTest.assertTrue((String)("contains <" + expectedCount + "> entries for activity <" + activityId + ">"), (found == expectedCount ? 1 : 0) != 0);
        }
    }

    private void assertIsCompletingActivityInstances(List<HistoricActivityInstance> allInstances, String activityId) {
        this.assertIsCompletingActivityInstances(allInstances, activityId, -1);
    }

    private void assertIsCompletingActivityInstances(List<HistoricActivityInstance> allInstances, String activityId, int count) {
        this.assertCorrectCompletingState(allInstances, activityId, count, true);
    }

    private void assertNonCompletingActivityInstance(List<HistoricActivityInstance> instances, String activityId) {
        this.assertNonCompletingActivityInstance(instances, activityId, -1);
    }

    private void assertNonCompletingActivityInstance(List<HistoricActivityInstance> instances, String activityId, int count) {
        this.assertCorrectCompletingState(instances, activityId, count, false);
    }

    private void assertCorrectCompletingState(List<HistoricActivityInstance> allInstances, String activityId, int expectedCount, boolean completing) {
        int found = 0;
        for (HistoricActivityInstance instance : allInstances) {
            if (!instance.getActivityId().equals(activityId)) continue;
            ++found;
            HistoricActivityInstanceStateTest.assertEquals((String)String.format("expect <%s> to be %scompleting", activityId, completing ? "" : "non-"), (boolean)completing, (boolean)instance.isCompleteScope());
        }
        HistoricActivityInstanceStateTest.assertTrue((String)("contains entry for activity <" + activityId + ">"), (found > 0 ? 1 : 0) != 0);
        if (expectedCount != -1) {
            HistoricActivityInstanceStateTest.assertTrue((String)("contains <" + expectedCount + "> entries for activity <" + activityId + ">"), (found == expectedCount ? 1 : 0) != 0);
        }
    }

    private List<HistoricActivityInstance> getEndActivityInstances() {
        return ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceEndTime().asc()).completeScope().list();
    }

    private List<HistoricActivityInstance> getAllActivityInstances() {
        return ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceStartTime().asc()).list();
    }

    private ProcessInstance startProcess() {
        return this.runtimeService.startProcessInstanceByKey("process");
    }
}

