/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class HistoricProcessInstanceTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricDataCreatedForProcessExecution() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, 2010);
        calendar.set(2, 8);
        calendar.set(5, 30);
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date noon = calendar.getTime();
        ClockUtil.setCurrentTime((Date)noon);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "myBusinessKey");
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        HistoricProcessInstanceTest.assertEquals((String)processInstance.getId(), (String)historicProcessInstance.getId());
        HistoricProcessInstanceTest.assertEquals((String)processInstance.getBusinessKey(), (String)historicProcessInstance.getBusinessKey());
        HistoricProcessInstanceTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)historicProcessInstance.getProcessDefinitionId());
        HistoricProcessInstanceTest.assertEquals((Object)noon, (Object)historicProcessInstance.getStartTime());
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getDurationInMillis());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        HistoricProcessInstanceTest.assertEquals((int)1, (int)tasks.size());
        Date twentyFiveSecsAfterNoon = new Date(noon.getTime() + 25000L);
        ClockUtil.setCurrentTime((Date)twentyFiveSecsAfterNoon);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        HistoricProcessInstanceTest.assertEquals((String)processInstance.getId(), (String)historicProcessInstance.getId());
        HistoricProcessInstanceTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)historicProcessInstance.getProcessDefinitionId());
        HistoricProcessInstanceTest.assertEquals((Object)noon, (Object)historicProcessInstance.getStartTime());
        HistoricProcessInstanceTest.assertEquals((Object)twentyFiveSecsAfterNoon, (Object)historicProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertEquals((Object)new Long(25000L), (Object)historicProcessInstance.getDurationInMillis());
        HistoricProcessInstanceTest.assertTrue((((HistoricProcessInstanceEventEntity)historicProcessInstance).getDurationRaw() >= 25000L ? 1 : 0) != 0);
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testLongRunningHistoricDataCreatedForProcessExecution() {
        long ONE_YEAR = 1471228928L;
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(14, 0);
        Date now = cal.getTime();
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "myBusinessKey");
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertEquals((Object)now, (Object)historicProcessInstance.getStartTime());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        HistoricProcessInstanceTest.assertEquals((int)1, (int)tasks.size());
        cal.add(1, 1);
        Date oneYearLater = cal.getTime();
        ClockUtil.setCurrentTime((Date)oneYearLater);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertEquals((Object)now, (Object)historicProcessInstance.getStartTime());
        HistoricProcessInstanceTest.assertEquals((Object)oneYearLater, (Object)historicProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertTrue((historicProcessInstance.getDurationInMillis() >= 1471228928L ? 1 : 0) != 0);
        HistoricProcessInstanceTest.assertTrue((((HistoricProcessInstanceEventEntity)historicProcessInstance).getDurationRaw() >= 1471228928L ? 1 : 0) != 0);
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstanceHistoryCreated() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        HistoricProcessInstanceTest.assertNotNull((Object)processInstance);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "cancel");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getEndTime());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceStartDate() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Date date = new Date();
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateOn(date).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateBy(date).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateBy(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateBy(DateUtils.addDays((Date)date, (int)1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateOn(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateOn(DateUtils.addDays((Date)date, (int)1)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceFinishDateUnfinished() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Date date = new Date();
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(date).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(date).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(DateUtils.addDays((Date)date, (int)1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(DateUtils.addDays((Date)date, (int)1)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceFinishDateFinished() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Date date = new Date();
        this.runtimeService.deleteProcessInstance(pi.getId(), "cancel");
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(date).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(date).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(DateUtils.addDays((Date)date, (int)1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(DateUtils.addDays((Date)date, (int)1)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceDelete() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.deleteProcessInstance(pi.getId(), "cancel");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getDeleteReason());
        HistoricProcessInstanceTest.assertEquals((String)"cancel", (String)historicProcessInstance.getDeleteReason());
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getEndTime());
    }

    @Deployment
    public void testHistoricProcessInstanceDeleteAsync() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failing");
        this.runtimeService.deleteProcessInstance(pi.getId(), "cancel");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getDeleteReason());
        HistoricProcessInstanceTest.assertEquals((String)"cancel", (String)historicProcessInstance.getDeleteReason());
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getEndTime());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceQuery() {
        Calendar startTime = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)startTime.getTime());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "businessKey123");
        Calendar hourAgo = Calendar.getInstance();
        hourAgo.add(11, -1);
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.add(11, 1);
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedBefore(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedBefore(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startedBefore(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startedBefore(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startedAfter(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startedAfter(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionId(processInstance.getProcessDefinitionId()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey("businessKey123").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKeyLike("business%").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKeyLike("%sinessKey123").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKeyLike("%siness%").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionName("The One Task Process").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionNameLike("The One Task%").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionNameLike("%One Task Process").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionNameLike("%One Task%").count());
        ArrayList<String> exludeIds = new ArrayList<String>();
        exludeIds.add("unexistingProcessDefinition");
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKeyNotIn(exludeIds).count());
        exludeIds.add("oneTaskProcess");
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKeyNotIn(exludeIds).count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult()).getId());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedBefore(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedBefore(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourFromNow.getTime()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceSorting() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().asc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().asc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceEndTime().asc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceDuration().asc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionId().asc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceBusinessKey().asc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceEndTime().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceDuration().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionId().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceBusinessKey().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceEndTime().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceDuration().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionId().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceBusinessKey().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().desc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().desc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceEndTime().desc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceDuration().desc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionId().desc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceBusinessKey().desc()).count());
    }

    public void testInvalidSorting() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().asc();
            HistoricProcessInstanceTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricProcessInstanceQuery().desc();
            HistoricProcessInstanceTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().list();
            HistoricProcessInstanceTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testDeleteReason() {
        if (!"none".equals(this.processEngineConfiguration.getHistory())) {
            String deleteReason = "some delete reason";
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            this.runtimeService.deleteProcessInstance(pi.getId(), "some delete reason");
            HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(pi.getId()).singleResult();
            HistoricProcessInstanceTest.assertEquals((String)"some delete reason", (String)hpi.getDeleteReason());
        }
    }
}

