/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.cmd.DeleteJobsCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.jobexecutor.TweetExceptionHandler;

public class JobExecutorCmdExceptionTest
extends PluggableProcessEngineTestCase {
    protected TweetExceptionHandler tweetExceptionHandler = new TweetExceptionHandler();
    private CommandExecutor commandExecutor;

    public void setUp() throws Exception {
        this.processEngineConfiguration.getJobHandlers().put(this.tweetExceptionHandler.getType(), this.tweetExceptionHandler);
        this.commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
    }

    public void tearDown() throws Exception {
        this.processEngineConfiguration.getJobHandlers().remove(this.tweetExceptionHandler.getType());
    }

    public void testJobCommandsWith2Exceptions() {
        this.commandExecutor.execute((Command)new Command<String>(){

            public String execute(CommandContext commandContext) {
                MessageEntity message = JobExecutorCmdExceptionTest.this.createTweetExceptionMessage();
                commandContext.getJobManager().send(message);
                return message.getId();
            }
        });
        this.waitForJobExecutorToProcessAllJobs(15000L);
    }

    public void testJobCommandsWith3Exceptions() {
        this.tweetExceptionHandler.setExceptionsRemaining(3);
        String jobId = (String)this.commandExecutor.execute((Command)new Command<String>(){

            public String execute(CommandContext commandContext) {
                MessageEntity message = JobExecutorCmdExceptionTest.this.createTweetExceptionMessage();
                commandContext.getJobManager().send(message);
                return message.getId();
            }
        });
        this.waitForJobExecutorToProcessAllJobs(15000L);
        this.commandExecutor.execute((Command)new DeleteJobsCmd(jobId));
    }

    public void testMultipleFailingJobs() {
        this.tweetExceptionHandler.setExceptionsRemaining(600);
        ArrayList<Object> createdJobs = new ArrayList<Object>();
        for (int i = 0; i < 40; ++i) {
            createdJobs.add(this.commandExecutor.execute((Command)new Command<String>(){

                public String execute(CommandContext commandContext) {
                    MessageEntity message = JobExecutorCmdExceptionTest.this.createTweetExceptionMessage();
                    commandContext.getJobManager().send(message);
                    return message.getId();
                }
            }));
        }
        this.waitForJobExecutorToProcessAllJobs(15000L);
        List jobList = this.managementService.createJobQuery().list();
        JobExecutorCmdExceptionTest.assertEquals((int)40, (int)jobList.size());
        for (Job job : jobList) {
            JobExecutorCmdExceptionTest.assertEquals((int)0, (int)job.getRetries());
        }
        for (String string : createdJobs) {
            this.commandExecutor.execute((Command)new DeleteJobsCmd(string));
        }
    }

    protected MessageEntity createTweetExceptionMessage() {
        MessageEntity message = new MessageEntity();
        message.setJobHandlerType("tweet-exception");
        return message;
    }
}

