/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.initialization;

import java.util.HashMap;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.WrongDbException;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.db.DbSqlSession;
import org.camunda.bpm.engine.impl.db.DbSqlSessionFactory;
import org.camunda.bpm.engine.impl.test.PvmTestCase;

public class ProcessEngineInitializationTest
extends PvmTestCase {
    public void testNoTables() {
        try {
            ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/standalone/initialization/notables.camunda.cfg.xml").buildProcessEngine();
            ProcessEngineInitializationTest.fail((String)"expected exception");
        }
        catch (Exception e) {
            this.assertTextPresent("no activiti tables in db", e.getMessage());
        }
    }

    public void testVersionMismatch() {
        ProcessEngineImpl processEngine = (ProcessEngineImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/standalone/initialization/notables.camunda.cfg.xml").setDatabaseSchemaUpdate("create-drop").buildProcessEngine();
        DbSqlSessionFactory dbSqlSessionFactory = (DbSqlSessionFactory)processEngine.getProcessEngineConfiguration().getSessionFactories().get(DbSqlSession.class);
        SqlSessionFactory sqlSessionFactory = dbSqlSessionFactory.getSqlSessionFactory();
        SqlSession sqlSession = sqlSessionFactory.openSession();
        boolean success = false;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("name", "schema.version");
            parameters.put("value", "25.7");
            parameters.put("revision", new Integer(1));
            parameters.put("newRevision", new Integer(2));
            sqlSession.update("updateProperty", parameters);
            success = true;
        }
        catch (Exception e) {
            throw new ProcessEngineException("couldn't update db schema version", (Throwable)e);
        }
        finally {
            if (success) {
                sqlSession.commit();
            } else {
                sqlSession.rollback();
            }
            sqlSession.close();
        }
        try {
            ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/standalone/initialization/notables.camunda.cfg.xml").setDatabaseSchemaUpdate("false").buildProcessEngine();
            ProcessEngineInitializationTest.fail((String)"expected exception");
        }
        catch (WrongDbException e) {
            this.assertTextPresent("version mismatch", e.getMessage());
            ProcessEngineInitializationTest.assertEquals((String)"25.7", (String)e.getDbVersion());
            ProcessEngineInitializationTest.assertEquals((String)"fox", (String)e.getLibraryVersion());
        }
        processEngine.close();
    }
}

