/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.io.Serializable;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.EventSubscriptionQuery;

public class EventSubscriptionQueryImpl
extends AbstractQuery<EventSubscriptionQuery, EventSubscription>
implements Serializable,
EventSubscriptionQuery {
    private static final long serialVersionUID = 1L;
    protected String eventSubscriptionId;
    protected String eventName;
    protected String eventType;
    protected String executionId;
    protected String processInstanceId;
    protected String activityId;

    public EventSubscriptionQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public EventSubscriptionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public EventSubscriptionQuery eventSubscriptionId(String id) {
        if (this.eventSubscriptionId == null) {
            throw new ProcessEngineException("Provided svent subscription id is null");
        }
        this.eventSubscriptionId = id;
        return this;
    }

    @Override
    public EventSubscriptionQuery eventName(String eventName) {
        if (eventName == null) {
            throw new ProcessEngineException("Provided event name is null");
        }
        this.eventName = eventName;
        return this;
    }

    @Override
    public EventSubscriptionQueryImpl executionId(String executionId) {
        if (executionId == null) {
            throw new ProcessEngineException("Provided execution id is null");
        }
        this.executionId = executionId;
        return this;
    }

    @Override
    public EventSubscriptionQuery processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new ProcessEngineException("Provided process instance id is null");
        }
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public EventSubscriptionQueryImpl activityId(String activityId) {
        if (activityId == null) {
            throw new ProcessEngineException("Provided activity id is null");
        }
        this.activityId = activityId;
        return this;
    }

    @Override
    public EventSubscriptionQueryImpl eventType(String eventType) {
        if (eventType == null) {
            throw new ProcessEngineException("Provided event type is null");
        }
        this.eventType = eventType;
        return this;
    }

    @Override
    public EventSubscriptionQuery orderByCreated() {
        return (EventSubscriptionQuery)this.orderBy(EventSubscriptionQueryProperty.CREATED);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getEventSubscriptionManager().findEventSubscriptionCountByQueryCriteria(this);
    }

    @Override
    public List<EventSubscription> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getEventSubscriptionManager().findEventSubscriptionsByQueryCriteria(this, page);
    }

    public String getEventSubscriptionId() {
        return this.eventSubscriptionId;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getActivityId() {
        return this.activityId;
    }
}

