/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.AbstractVariableQueryImpl;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryValue;
import org.camunda.bpm.engine.impl.ExecutionQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.QueryOperator;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ExecutionQuery;

public class ExecutionQueryImpl
extends AbstractVariableQueryImpl<ExecutionQuery, Execution>
implements ExecutionQuery {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String activityId;
    protected String executionId;
    protected String processInstanceId;
    protected List<EventSubscriptionQueryValue> eventSubscriptions;
    protected SuspensionState suspensionState;
    protected String superProcessInstanceId;
    protected String subProcessInstanceId;
    private String businessKey;

    public ExecutionQueryImpl() {
    }

    public ExecutionQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public ExecutionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public boolean isProcessInstancesOnly() {
        return false;
    }

    @Override
    public ExecutionQueryImpl processDefinitionId(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new ProcessEngineException("Process definition id is null");
        }
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public ExecutionQueryImpl processDefinitionKey(String processDefinitionKey) {
        if (processDefinitionKey == null) {
            throw new ProcessEngineException("Process definition key is null");
        }
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public ExecutionQueryImpl processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new ProcessEngineException("Process instance id is null");
        }
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public ExecutionQuery processInstanceBusinessKey(String businessKey) {
        if (businessKey == null) {
            throw new ProcessEngineException("Business key is null");
        }
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public ExecutionQueryImpl executionId(String executionId) {
        if (executionId == null) {
            throw new ProcessEngineException("Execution id is null");
        }
        this.executionId = executionId;
        return this;
    }

    @Override
    public ExecutionQueryImpl activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Override
    public ExecutionQuery signalEventSubscription(String signalName) {
        return this.eventSubscription("signal", signalName);
    }

    @Override
    public ExecutionQuery signalEventSubscriptionName(String signalName) {
        return this.eventSubscription("signal", signalName);
    }

    @Override
    public ExecutionQuery messageEventSubscriptionName(String messageName) {
        return this.eventSubscription("message", messageName);
    }

    public ExecutionQuery eventSubscription(String eventType, String eventName) {
        if (eventName == null) {
            throw new ProcessEngineException("event name is null");
        }
        if (eventType == null) {
            throw new ProcessEngineException("event type is null");
        }
        if (this.eventSubscriptions == null) {
            this.eventSubscriptions = new ArrayList<EventSubscriptionQueryValue>();
        }
        this.eventSubscriptions.add(new EventSubscriptionQueryValue(eventName, eventType));
        return this;
    }

    @Override
    public ExecutionQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    @Override
    public ExecutionQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public ExecutionQuery processVariableValueEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.EQUALS, false);
        return this;
    }

    @Override
    public ExecutionQuery processVariableValueNotEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.NOT_EQUALS, false);
        return this;
    }

    @Override
    public ExecutionQueryImpl orderByProcessInstanceId() {
        this.orderProperty = ExecutionQueryProperty.PROCESS_INSTANCE_ID;
        return this;
    }

    @Override
    public ExecutionQueryImpl orderByProcessDefinitionId() {
        this.orderProperty = ExecutionQueryProperty.PROCESS_DEFINITION_ID;
        return this;
    }

    @Override
    public ExecutionQueryImpl orderByProcessDefinitionKey() {
        this.orderProperty = ExecutionQueryProperty.PROCESS_DEFINITION_KEY;
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getExecutionManager().findExecutionCountByQueryCriteria(this);
    }

    @Override
    public List<Execution> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getExecutionManager().findExecutionsByQueryCriteria(this, page);
    }

    public boolean getOnlyProcessInstances() {
        return false;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessInstanceIds() {
        return null;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getSuperProcessInstanceId() {
        return this.superProcessInstanceId;
    }

    public String getSubProcessInstanceId() {
        return this.subProcessInstanceId;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(SuspensionState suspensionState) {
        this.suspensionState = suspensionState;
    }

    public List<EventSubscriptionQueryValue> getEventSubscriptions() {
        return this.eventSubscriptions;
    }

    public void setEventSubscriptions(List<EventSubscriptionQueryValue> eventSubscriptions) {
        this.eventSubscriptions = eventSubscriptions;
    }
}

