/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.HistoricVariableInstanceQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.QueryOperator;
import org.camunda.bpm.engine.impl.QueryVariableValue;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.impl.variable.VariableTypes;

public class HistoricVariableInstanceQueryImpl
extends AbstractQuery<HistoricVariableInstanceQuery, HistoricVariableInstance>
implements HistoricVariableInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String activityInstanceId;
    protected String variableName;
    protected String variableNameLike;
    protected boolean excludeTaskRelated = false;
    protected QueryVariableValue queryVariableValue;
    protected String[] taskIds;
    protected String[] executionIds;

    public HistoricVariableInstanceQueryImpl() {
    }

    public HistoricVariableInstanceQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public HistoricVariableInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricVariableInstanceQueryImpl processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new ProcessEngineException("processInstanceId is null");
        }
        this.processInstanceId = processInstanceId;
        return this;
    }

    public HistoricVariableInstanceQuery activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery taskIdIn(String ... taskIds) {
        this.assertParamNotNull("Task Ids", taskIds);
        this.taskIds = taskIds;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery executionIdIn(String ... executionIds) {
        this.assertParamNotNull("Execution Ids", executionIds);
        this.executionIds = executionIds;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery variableName(String variableName) {
        if (variableName == null) {
            throw new ProcessEngineException("variableName is null");
        }
        this.variableName = variableName;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery variableValueEquals(String variableName, Object variableValue) {
        if (variableName == null) {
            throw new ProcessEngineException("variableName is null");
        }
        if (variableValue == null) {
            throw new ProcessEngineException("variableValue is null");
        }
        this.variableName = variableName;
        this.queryVariableValue = new QueryVariableValue(variableName, variableValue, QueryOperator.EQUALS, true);
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery variableNameLike(String variableNameLike) {
        if (variableNameLike == null) {
            throw new ProcessEngineException("variableNameLike is null");
        }
        this.variableNameLike = variableNameLike;
        return this;
    }

    public HistoricVariableInstanceQuery excludeTaskDetails() {
        this.excludeTaskRelated = true;
        return this;
    }

    protected void ensureVariablesInitialized() {
        if (this.queryVariableValue != null) {
            VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
            this.queryVariableValue.initialize(variableTypes);
        }
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getHistoricVariableInstanceManager().findHistoricVariableInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricVariableInstance> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        List<HistoricVariableInstance> historicVariableInstances = commandContext.getHistoricVariableInstanceManager().findHistoricVariableInstancesByQueryCriteria(this, page);
        if (historicVariableInstances != null) {
            for (HistoricVariableInstance historicVariableInstance : historicVariableInstances) {
                if (!(historicVariableInstance instanceof HistoricVariableInstanceEntity)) continue;
                ((HistoricVariableInstanceEntity)historicVariableInstance).getByteArrayValue();
            }
        }
        return historicVariableInstances;
    }

    @Override
    public HistoricVariableInstanceQuery orderByProcessInstanceId() {
        this.orderBy(HistoricVariableInstanceQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery orderByVariableName() {
        this.orderBy(HistoricVariableInstanceQueryProperty.VARIABLE_NAME);
        return this;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public String[] getTaskIds() {
        return this.taskIds;
    }

    public String[] getExecutionIds() {
        return this.executionIds;
    }

    public boolean getExcludeTaskRelated() {
        return this.excludeTaskRelated;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableNameLike() {
        return this.variableNameLike;
    }

    public QueryVariableValue getQueryVariableValue() {
        return this.queryVariableValue;
    }
}

