/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Date;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.AbstractSetJobStateCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.TimerChangeJobDefinitionSuspensionStateJobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;

public abstract class AbstractSetJobDefinitionStateCmd
implements Command<Void> {
    protected String jobDefinitionId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected boolean includeJobs = false;
    protected Date executionDate;

    public AbstractSetJobDefinitionStateCmd(String jobDefinitionId, String processDefinitionId, String processDefinitionKey, boolean includeJobs, Date executionDate) {
        this.jobDefinitionId = jobDefinitionId;
        this.processDefinitionId = processDefinitionId;
        this.processDefinitionKey = processDefinitionKey;
        this.includeJobs = includeJobs;
        this.executionDate = executionDate;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.jobDefinitionId == null && this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new ProcessEngineException("Job definition id, process definition id nor process definition key cannot be null");
        }
        if (this.executionDate == null) {
            this.updateSuspensionState(commandContext);
        } else {
            this.scheduleSuspensionStateUpdate(commandContext);
        }
        return null;
    }

    private void updateSuspensionState(CommandContext commandContext) {
        JobDefinitionManager jobDefinitionManager = commandContext.getJobDefinitionManager();
        SuspensionState suspensionState = this.getSuspensionState();
        if (this.jobDefinitionId != null) {
            jobDefinitionManager.updateJobDefinitionSuspensionStateById(this.jobDefinitionId, suspensionState);
        } else if (this.processDefinitionId != null) {
            jobDefinitionManager.updateJobDefinitionSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
        } else if (this.processDefinitionKey != null) {
            jobDefinitionManager.updateJobDefinitionSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
        }
        if (this.includeJobs) {
            this.getSetJobStateCmd().execute(commandContext);
        }
    }

    private void scheduleSuspensionStateUpdate(CommandContext commandContext) {
        TimerEntity timer = new TimerEntity();
        timer.setDuedate(this.executionDate);
        timer.setJobHandlerType(this.getDelayedExecutionJobHandlerType());
        String jobConfiguration = null;
        if (this.jobDefinitionId != null) {
            jobConfiguration = TimerChangeJobDefinitionSuspensionStateJobHandler.createJobHandlerConfigurationByJobDefinitionId(this.jobDefinitionId, this.includeJobs);
        } else if (this.processDefinitionId != null) {
            jobConfiguration = TimerChangeJobDefinitionSuspensionStateJobHandler.createJobHandlerConfigurationByProcessDefinitionId(this.processDefinitionId, this.includeJobs);
        } else if (this.processDefinitionKey != null) {
            jobConfiguration = TimerChangeJobDefinitionSuspensionStateJobHandler.createJobHandlerConfigurationByProcessDefinitionKey(this.processDefinitionKey, this.includeJobs);
        }
        timer.setJobHandlerConfiguration(jobConfiguration);
        commandContext.getJobManager().schedule(timer);
    }

    protected abstract SuspensionState getSuspensionState();

    protected abstract String getDelayedExecutionJobHandlerType();

    protected abstract AbstractSetJobStateCmd getSetJobStateCmd();
}

