/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Map;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.MessageEventReceivedCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandler;
import org.camunda.bpm.engine.impl.runtime.CorrelationSet;
import org.camunda.bpm.engine.impl.runtime.MessageCorrelationResult;

public class CorrelateMessageCmd
implements Command<Void> {
    protected final String messageName;
    protected final String businessKey;
    protected final Map<String, Object> correlationKeys;
    protected final Map<String, Object> processVariables;

    public CorrelateMessageCmd(String messageName, String businessKey, Map<String, Object> correlationKeys, Map<String, Object> processVariables) {
        this.messageName = messageName;
        this.businessKey = businessKey;
        this.correlationKeys = correlationKeys;
        this.processVariables = processVariables;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        CorrelationSet correlationSet;
        if (this.messageName == null) {
            throw new ProcessEngineException("messageName cannot be null");
        }
        CorrelationHandler correlationHandler = Context.getProcessEngineConfiguration().getCorrelationHandler();
        MessageCorrelationResult correlationResult = correlationHandler.correlateMessage(commandContext, this.messageName, correlationSet = new CorrelationSet(this.businessKey, this.correlationKeys));
        if (correlationResult == null) {
            throw new MismatchingMessageCorrelationException(this.messageName, "No process definition or execution matches the parameters");
        }
        if ("execution".equals(correlationResult.getResultType())) {
            this.triggerExecution(commandContext, correlationResult);
        } else {
            this.instantiateProcess(commandContext, correlationResult);
        }
        return null;
    }

    protected void triggerExecution(CommandContext commandContext, MessageCorrelationResult correlationResult) {
        new MessageEventReceivedCmd(this.messageName, correlationResult.getExecutionEntity().getId(), this.processVariables).execute(commandContext);
    }

    protected void instantiateProcess(CommandContext commandContext, MessageCorrelationResult correlationResult) {
        ProcessDefinitionEntity processDefinitionEntity = correlationResult.getProcessDefinitionEntity();
        ActivityImpl messageStartEvent = processDefinitionEntity.findActivity(correlationResult.getStartEventActivityId());
        ExecutionEntity processInstance = processDefinitionEntity.createProcessInstance(this.businessKey, messageStartEvent);
        processInstance.start(this.businessKey, this.processVariables);
    }
}

