/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.CommentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.CommentManager;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class DeleteAttachmentCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String attachmentId;

    public DeleteAttachmentCmd(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        CommentManager commentManager;
        AttachmentEntity attachment = commandContext.getDbSqlSession().selectById(AttachmentEntity.class, this.attachmentId);
        commandContext.getDbSqlSession().delete(attachment);
        if (attachment.getContentId() != null) {
            commandContext.getByteArrayManager().deleteByteArrayById(attachment.getContentId());
        }
        if (attachment.getTaskId() != null && (commentManager = commandContext.getCommentManager()).isHistoryEnabled()) {
            String authenticatedUserId = commandContext.getAuthenticatedUserId();
            CommentEntity comment = new CommentEntity();
            comment.setUserId(authenticatedUserId);
            comment.setType("event");
            comment.setTime(ClockUtil.getCurrentTime());
            comment.setAction("DeleteAttachment");
            comment.setMessage(attachment.getName());
            comment.setTaskId(attachment.getTaskId());
            commentManager.insert(comment);
        }
        return null;
    }
}

