/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.CommentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.CommentManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class DeleteIdentityLinkCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String userId;
    protected String groupId;
    protected String type;
    protected String taskId;

    public DeleteIdentityLinkCmd(String taskId, String userId, String groupId, String type) {
        this.validateParams(userId, groupId, type, taskId);
        this.taskId = taskId;
        this.userId = userId;
        this.groupId = groupId;
        this.type = type;
    }

    protected void validateParams(String userId, String groupId, String type, String taskId) {
        if (taskId == null) {
            throw new ProcessEngineException("taskId is null");
        }
        if (type == null) {
            throw new ProcessEngineException("type is required when adding a new task identity link");
        }
        if ("assignee".equals(type) || "owner".equals(type)) {
            if (groupId != null) {
                throw new ProcessEngineException("Incompatible usage: cannot use type '" + type + "' together with a groupId");
            }
        } else if (userId == null && groupId == null) {
            throw new ProcessEngineException("userId and groupId cannot both be null");
        }
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ProcessEngineException("taskId is null");
        }
        TaskEntity task = commandContext.getTaskManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ProcessEngineException("Cannot find task with id " + this.taskId);
        }
        if ("assignee".equals(this.type)) {
            task.setAssignee(null);
        } else if ("owner".equals(this.type)) {
            task.setOwner(null);
        } else {
            task.deleteIdentityLink(this.userId, this.groupId, this.type);
        }
        CommentManager commentManager = commandContext.getCommentManager();
        if (commentManager.isHistoryEnabled()) {
            String authenticatedUserId = commandContext.getAuthenticatedUserId();
            CommentEntity comment = new CommentEntity();
            comment.setUserId(authenticatedUserId);
            comment.setType("event");
            comment.setTime(ClockUtil.getCurrentTime());
            comment.setTaskId(this.taskId);
            if (this.userId != null) {
                comment.setAction("DeleteUserLink");
                comment.setMessage(new String[]{this.userId, this.type});
            } else {
                comment.setAction("DeleteGroupLink");
                comment.setMessage(new String[]{this.groupId, this.type});
            }
            commentManager.insert(comment);
        }
        return null;
    }
}

