/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;

public class SetTaskPriorityCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int priority;
    protected String taskId;

    public SetTaskPriorityCmd(String taskId, int priority) {
        this.taskId = taskId;
        this.priority = priority;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ProcessEngineException("taskId is null");
        }
        TaskEntity task = commandContext.getTaskManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ProcessEngineException("Cannot find task with id " + this.taskId);
        }
        task.setPriority(this.priority);
        return null;
    }
}

