/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.identity.Picture;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityInfoEntity;

public class SetUserPictureCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String userId;
    protected Picture picture;

    public SetUserPictureCmd(String userId, Picture picture) {
        this.userId = userId;
        this.picture = picture;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.userId == null) {
            throw new ProcessEngineException("userId is null");
        }
        IdentityInfoEntity pictureInfo = commandContext.getIdentityInfoManager().findUserInfoByUserIdAndKey(this.userId, "picture");
        if (pictureInfo != null) {
            String byteArrayId = pictureInfo.getValue();
            if (byteArrayId != null) {
                commandContext.getByteArrayManager().deleteByteArrayById(byteArrayId);
            }
        } else {
            pictureInfo = new IdentityInfoEntity();
            pictureInfo.setUserId(this.userId);
            pictureInfo.setKey("picture");
            commandContext.getDbSqlSession().insert(pictureInfo);
        }
        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(this.picture.getMimeType(), this.picture.getBytes());
        commandContext.getDbSqlSession().insert(byteArrayEntity);
        pictureInfo.setValue(byteArrayEntity.getId());
        return null;
    }
}

