/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.SqlSessionFactory;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.db.DbSqlSession;
import org.camunda.bpm.engine.impl.db.PersistentObject;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.engine.impl.util.ClassNameUtil;

public class DbSqlSessionFactory
implements SessionFactory {
    protected static final Map<String, Map<String, String>> databaseSpecificStatements = new HashMap<String, Map<String, String>>();
    public static final Map<String, String> databaseSpecificLimitBeforeStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitAfterStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitBetweenStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificOrderByStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitBeforeNativeQueryStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificBitAnd1 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificBitAnd2 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificBitAnd3 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificDateDiff1 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificDateDiff2 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificDateDiff3 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificDummyTable = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificTrueConstant = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificFalseConstant = new HashMap<String, String>();
    protected String databaseType;
    protected String databaseTablePrefix = "";
    protected String databaseSchema;
    protected SqlSessionFactory sqlSessionFactory;
    protected IdGenerator idGenerator;
    protected Map<String, String> statementMappings;
    protected Map<Class<?>, String> insertStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> updateStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> deleteStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> selectStatements = new ConcurrentHashMap();
    protected boolean isDbIdentityUsed = true;
    protected boolean isDbHistoryUsed = true;

    @Override
    public Class<?> getSessionType() {
        return DbSqlSession.class;
    }

    @Override
    public Session openSession() {
        return new DbSqlSession(this);
    }

    public String getInsertStatement(PersistentObject object) {
        return this.getStatement(object.getClass(), this.insertStatements, "insert");
    }

    public String getUpdateStatement(PersistentObject object) {
        return this.getStatement(object.getClass(), this.updateStatements, "update");
    }

    public String getDeleteStatement(Class<?> persistentObjectClass) {
        return this.getStatement(persistentObjectClass, this.deleteStatements, "delete");
    }

    public String getSelectStatement(Class<?> persistentObjectClass) {
        return this.getStatement(persistentObjectClass, this.selectStatements, "select");
    }

    private String getStatement(Class<?> persistentObjectClass, Map<Class<?>, String> cachedStatements, String prefix) {
        String statement = cachedStatements.get(persistentObjectClass);
        if (statement != null) {
            return statement;
        }
        statement = prefix + ClassNameUtil.getClassNameWithoutPackage(persistentObjectClass);
        statement = statement.substring(0, statement.length() - 6);
        cachedStatements.put(persistentObjectClass, statement);
        return statement;
    }

    protected static void addDatabaseSpecificStatement(String databaseType, String activitiStatement, String ibatisStatement) {
        Map<String, String> specificStatements = databaseSpecificStatements.get(databaseType);
        if (specificStatements == null) {
            specificStatements = new HashMap<String, String>();
            databaseSpecificStatements.put(databaseType, specificStatements);
        }
        specificStatements.put(activitiStatement, ibatisStatement);
    }

    public String mapStatement(String statement) {
        if (this.statementMappings == null) {
            return statement;
        }
        String mappedStatement = this.statementMappings.get(statement);
        return mappedStatement != null ? mappedStatement : statement;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
        this.statementMappings = databaseSpecificStatements.get(databaseType);
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public Map<String, String> getStatementMappings() {
        return this.statementMappings;
    }

    public void setStatementMappings(Map<String, String> statementMappings) {
        this.statementMappings = statementMappings;
    }

    public Map<Class<?>, String> getInsertStatements() {
        return this.insertStatements;
    }

    public void setInsertStatements(Map<Class<?>, String> insertStatements) {
        this.insertStatements = insertStatements;
    }

    public Map<Class<?>, String> getUpdateStatements() {
        return this.updateStatements;
    }

    public void setUpdateStatements(Map<Class<?>, String> updateStatements) {
        this.updateStatements = updateStatements;
    }

    public Map<Class<?>, String> getDeleteStatements() {
        return this.deleteStatements;
    }

    public void setDeleteStatements(Map<Class<?>, String> deleteStatements) {
        this.deleteStatements = deleteStatements;
    }

    public Map<Class<?>, String> getSelectStatements() {
        return this.selectStatements;
    }

    public void setSelectStatements(Map<Class<?>, String> selectStatements) {
        this.selectStatements = selectStatements;
    }

    public boolean isDbIdentityUsed() {
        return this.isDbIdentityUsed;
    }

    public void setDbIdentityUsed(boolean isDbIdentityUsed) {
        this.isDbIdentityUsed = isDbIdentityUsed;
    }

    public boolean isDbHistoryUsed() {
        return this.isDbHistoryUsed;
    }

    public void setDbHistoryUsed(boolean isDbHistoryUsed) {
        this.isDbHistoryUsed = isDbHistoryUsed;
    }

    public void setDatabaseTablePrefix(String databaseTablePrefix) {
        this.databaseTablePrefix = databaseTablePrefix;
    }

    public String getDatabaseTablePrefix() {
        return this.databaseTablePrefix;
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    static {
        String defaultOrderBy = " order by ${orderBy} ";
        databaseSpecificLimitBeforeStatements.put("h2", "");
        databaseSpecificLimitAfterStatements.put("h2", "LIMIT #{maxResults} OFFSET #{firstResult}");
        databaseSpecificLimitBetweenStatements.put("h2", "");
        databaseSpecificOrderByStatements.put("h2", defaultOrderBy);
        databaseSpecificLimitBeforeNativeQueryStatements.put("h2", "");
        databaseSpecificBitAnd1.put("h2", "BITAND(");
        databaseSpecificBitAnd2.put("h2", ",");
        databaseSpecificBitAnd3.put("h2", ")");
        databaseSpecificDateDiff1.put("h2", "DATEDIFF(ms, ");
        databaseSpecificDateDiff2.put("h2", ",");
        databaseSpecificDateDiff3.put("h2", ")");
        databaseSpecificDummyTable.put("h2", "");
        databaseSpecificTrueConstant.put("h2", "1");
        databaseSpecificFalseConstant.put("h2", "0");
        databaseSpecificLimitBeforeStatements.put("mysql", "");
        databaseSpecificLimitAfterStatements.put("mysql", "LIMIT #{maxResults} OFFSET #{firstResult}");
        databaseSpecificLimitBetweenStatements.put("mysql", "");
        databaseSpecificOrderByStatements.put("mysql", defaultOrderBy);
        databaseSpecificLimitBeforeNativeQueryStatements.put("mysql", "");
        databaseSpecificBitAnd1.put("mysql", "");
        databaseSpecificBitAnd2.put("mysql", " & ");
        databaseSpecificBitAnd3.put("mysql", "");
        databaseSpecificDummyTable.put("mysql", "");
        databaseSpecificDateDiff1.put("mysql", "TIMESTAMPDIFF(SECOND,");
        databaseSpecificDateDiff2.put("mysql", ",");
        databaseSpecificDateDiff3.put("mysql", ")*1000");
        databaseSpecificTrueConstant.put("mysql", "1");
        databaseSpecificFalseConstant.put("mysql", "0");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mysql", "selectNextJobsToExecute", "selectNextJobsToExecute_mysql");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mysql", "selectExclusiveJobsToExecute", "selectExclusiveJobsToExecute_mysql");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mysql", "selectProcessDefinitionsByQueryCriteria", "selectProcessDefinitionsByQueryCriteria_mysql");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mysql", "selectProcessDefinitionCountByQueryCriteria", "selectProcessDefinitionCountByQueryCriteria_mysql");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mysql", "selectDeploymentsByQueryCriteria", "selectDeploymentsByQueryCriteria_mysql");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mysql", "selectDeploymentCountByQueryCriteria", "selectDeploymentCountByQueryCriteria_mysql");
        databaseSpecificLimitBeforeStatements.put("postgres", "");
        databaseSpecificLimitAfterStatements.put("postgres", "LIMIT #{maxResults} OFFSET #{firstResult}");
        databaseSpecificLimitBetweenStatements.put("postgres", "");
        databaseSpecificOrderByStatements.put("postgres", defaultOrderBy);
        databaseSpecificLimitBeforeNativeQueryStatements.put("postgres", "");
        databaseSpecificBitAnd1.put("postgres", "");
        databaseSpecificBitAnd2.put("postgres", " & ");
        databaseSpecificBitAnd3.put("postgres", "");
        databaseSpecificDateDiff1.put("postgres", "(EXTRACT(EPOCH FROM ");
        databaseSpecificDateDiff2.put("postgres", " AT TIME ZONE 'UTC') * 1000) - (EXTRACT(EPOCH FROM ");
        databaseSpecificDateDiff3.put("postgres", " AT TIME ZONE 'UTC') * 1000)");
        databaseSpecificDummyTable.put("postgres", "");
        databaseSpecificTrueConstant.put("postgres", "true");
        databaseSpecificFalseConstant.put("postgres", "false");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertByteArray", "insertByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateByteArray", "updateByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectByteArray", "selectByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectResourceByDeploymentIdAndResourceName", "selectResourceByDeploymentIdAndResourceName_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectResourcesByDeploymentId", "selectResourcesByDeploymentId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricDetailsByQueryCriteria", "selectHistoricDetailsByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertIdentityInfo", "insertIdentityInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateIdentityInfo", "updateIdentityInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectIdentityInfoById", "selectIdentityInfoById_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectIdentityInfoByUserIdAndKey", "selectIdentityInfoByUserIdAndKey_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectIdentityInfoByUserId", "selectIdentityInfoByUserId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectIdentityInfoDetails", "selectIdentityInfoDetails_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertComment", "insertComment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectCommentsByTaskId", "selectCommentsByTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectCommentsByProcessInstanceId", "selectCommentsByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectEventsByTaskId", "selectEventsByTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectActivityStatistics", "selectActivityStatistics_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectActivityStatisticsCount", "selectActivityStatisticsCount_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricVariableInstanceByQueryCriteria", "selectHistoricVariableInstanceByQueryCriteria_postgres");
        databaseSpecificLimitBeforeStatements.put("oracle", "select * from ( select a.*, ROWNUM rnum from (");
        databaseSpecificLimitAfterStatements.put("oracle", "  ) a where ROWNUM < #{lastRow}) where rnum  >= #{firstRow}");
        databaseSpecificLimitBetweenStatements.put("oracle", "");
        databaseSpecificOrderByStatements.put("oracle", defaultOrderBy);
        databaseSpecificLimitBeforeNativeQueryStatements.put("oracle", "");
        databaseSpecificDummyTable.put("oracle", "FROM DUAL");
        databaseSpecificBitAnd1.put("oracle", "BITAND(");
        databaseSpecificBitAnd2.put("oracle", ",");
        databaseSpecificBitAnd3.put("oracle", ")");
        databaseSpecificDateDiff1.put("oracle", "((cast(");
        databaseSpecificDateDiff2.put("oracle", " as date) - date '1970-01-01')*24*60*60*1000) - ((cast(");
        databaseSpecificDateDiff3.put("oracle", " as date) - date '1970-01-01')*24*60*60*1000)");
        databaseSpecificTrueConstant.put("oracle", "1");
        databaseSpecificFalseConstant.put("oracle", "0");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "selectExclusiveJobsToExecute", "selectExclusiveJobsToExecute_integerBoolean");
        databaseSpecificLimitBeforeStatements.put("db2", "SELECT SUB.* FROM (");
        databaseSpecificLimitAfterStatements.put("db2", ")RES ) SUB WHERE SUB.rnk >= #{firstRow} AND SUB.rnk < #{lastRow}");
        databaseSpecificLimitBetweenStatements.put("db2", ", row_number() over (ORDER BY ${orderBy}) rnk FROM ( select distinct RES.* ");
        databaseSpecificOrderByStatements.put("db2", "");
        databaseSpecificLimitBeforeNativeQueryStatements.put("db2", "SELECT SUB.* FROM ( select RES.* , row_number() over (ORDER BY ${orderBy}) rnk FROM (");
        databaseSpecificBitAnd1.put("db2", "BITAND(");
        databaseSpecificBitAnd2.put("db2", ",");
        databaseSpecificBitAnd3.put("db2", ")");
        databaseSpecificDateDiff1.put("db2", "");
        databaseSpecificDateDiff2.put("db2", "");
        databaseSpecificDateDiff3.put("db2", "");
        databaseSpecificDummyTable.put("db2", "FROM SYSIBM.SYSDUMMY1");
        databaseSpecificTrueConstant.put("db2", "1");
        databaseSpecificFalseConstant.put("db2", "0");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectExclusiveJobsToExecute", "selectExclusiveJobsToExecute_integerBoolean");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectExecutionByNativeQuery", "selectExecutionByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectHistoricActivityInstanceByNativeQuery", "selectHistoricActivityInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectHistoricProcessInstanceByNativeQuery", "selectHistoricProcessInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectHistoricTaskInstanceByNativeQuery", "selectHistoricTaskInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectTaskByNativeQuery", "selectTaskByNativeQuery_mssql_or_db2");
        databaseSpecificLimitBeforeStatements.put("mssql", "SELECT SUB.* FROM (");
        databaseSpecificLimitAfterStatements.put("mssql", ")RES ) SUB WHERE SUB.rnk >= #{firstRow} AND SUB.rnk < #{lastRow}");
        databaseSpecificLimitBetweenStatements.put("mssql", ", row_number() over (ORDER BY ${orderBy}) rnk FROM ( select distinct RES.* ");
        databaseSpecificOrderByStatements.put("mssql", "");
        databaseSpecificLimitBeforeNativeQueryStatements.put("mssql", "SELECT SUB.* FROM ( select RES.* , row_number() over (ORDER BY ${orderBy}) rnk FROM (");
        databaseSpecificBitAnd1.put("mssql", "");
        databaseSpecificBitAnd2.put("mssql", " &");
        databaseSpecificBitAnd3.put("mssql", "");
        databaseSpecificDateDiff1.put("mssql", "");
        databaseSpecificDateDiff2.put("mssql", "");
        databaseSpecificDateDiff3.put("mssql", "");
        databaseSpecificDummyTable.put("mssql", "");
        databaseSpecificTrueConstant.put("mssql", "1");
        databaseSpecificFalseConstant.put("mssql", "0");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectExclusiveJobsToExecute", "selectExclusiveJobsToExecute_integerBoolean");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectExecutionByNativeQuery", "selectExecutionByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectHistoricActivityInstanceByNativeQuery", "selectHistoricActivityInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectHistoricProcessInstanceByNativeQuery", "selectHistoricProcessInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectHistoricTaskInstanceByNativeQuery", "selectHistoricTaskInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectTaskByNativeQuery", "selectTaskByNativeQuery_mssql_or_db2");
    }
}

