/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.incident;

import java.util.List;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.incident.IncidentHandler;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.runtime.Incident;

public class FailedJobIncidentHandler
implements IncidentHandler {
    public static final String INCIDENT_HANDLER_TYPE = "failedJob";

    @Override
    public String getIncidentHandlerType() {
        return INCIDENT_HANDLER_TYPE;
    }

    @Override
    public void handleIncident(String processDefinitionId, String activityId, String executionId, String jobId, String message) {
        if (executionId != null) {
            IncidentEntity newIncident = IncidentEntity.createAndInsertIncident(INCIDENT_HANDLER_TYPE, executionId, jobId, message);
            newIncident.createRecursiveIncidents();
        } else {
            IncidentEntity.createAndInsertIncident(INCIDENT_HANDLER_TYPE, processDefinitionId, activityId, jobId, message);
        }
    }

    @Override
    public void resolveIncident(String processDefinitionId, String activityId, String executionId, String jobId) {
        List<Incident> incidents = Context.getCommandContext().getIncidentManager().findIncidentByConfiguration(jobId);
        for (Incident currentIncident : incidents) {
            IncidentEntity incident = (IncidentEntity)currentIncident;
            incident.delete();
        }
    }
}

