/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.deploy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.deploy.Deployer;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class DeploymentCache {
    private Logger LOGGER = Logger.getLogger(DeploymentCache.class.getName());
    protected Map<String, ProcessDefinitionEntity> processDefinitionCache = new HashMap<String, ProcessDefinitionEntity>();
    protected Map<String, Object> knowledgeBaseCache = new HashMap<String, Object>();
    protected List<Deployer> deployers;

    public void deploy(DeploymentEntity deployment) {
        for (Deployer deployer : this.deployers) {
            deployer.deploy(deployment);
        }
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionById(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new ProcessEngineException("Invalid process definition id : null");
        }
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
        if (processDefinition == null) {
            throw new ProcessEngineException("no deployed process definition found with id '" + processDefinitionId + "'");
        }
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedLatestProcessDefinitionByKey(String processDefinitionKey) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionManager().findLatestProcessDefinitionByKey(processDefinitionKey);
        if (processDefinition == null) {
            throw new ProcessEngineException("no processes deployed with key '" + processDefinitionKey + "'");
        }
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionByKeyAndVersion(String processDefinitionKey, Integer processDefinitionVersion) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)Context.getCommandContext().getProcessDefinitionManager().findProcessDefinitionByKeyAndVersion(processDefinitionKey, processDefinitionVersion);
        if (processDefinition == null) {
            throw new ProcessEngineException("no processes deployed with key = '" + processDefinitionKey + "' and version = '" + processDefinitionVersion + "'");
        }
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionByDeploymentAndKey(String deploymentId, String processDefinitionKey) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionManager().findProcessDefinitionByDeploymentAndKey(deploymentId, processDefinitionKey);
        if (processDefinition == null) {
            throw new ProcessEngineException("no processes deployed with key = '" + processDefinitionKey + "' in deployment = '" + deploymentId + "'");
        }
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity resolveProcessDefinition(ProcessDefinitionEntity processDefinition) {
        String processDefinitionId = processDefinition.getId();
        String deploymentId = processDefinition.getDeploymentId();
        ProcessDefinitionEntity cachedProcessDefinition = this.processDefinitionCache.get(processDefinitionId);
        if (cachedProcessDefinition == null) {
            DeploymentEntity deployment = Context.getCommandContext().getDeploymentManager().findDeploymentById(deploymentId);
            deployment.setNew(false);
            this.deploy(deployment);
            cachedProcessDefinition = this.processDefinitionCache.get(processDefinitionId);
            if (cachedProcessDefinition == null) {
                throw new ProcessEngineException("deployment '" + deploymentId + "' didn't put process definition '" + processDefinitionId + "' in the cache");
            }
        } else {
            cachedProcessDefinition.updateModifiedFieldsFromEntity(processDefinition);
        }
        return cachedProcessDefinition;
    }

    public void addProcessDefinition(ProcessDefinitionEntity processDefinition) {
        this.processDefinitionCache.put(processDefinition.getId(), processDefinition);
    }

    public void removeProcessDefinition(String processDefinitionId) {
        this.processDefinitionCache.remove(processDefinitionId);
    }

    public void addKnowledgeBase(String knowledgeBaseId, Object knowledgeBase) {
        this.knowledgeBaseCache.put(knowledgeBaseId, knowledgeBase);
    }

    public void removeKnowledgeBase(String knowledgeBaseId) {
        this.knowledgeBaseCache.remove(knowledgeBaseId);
    }

    public void discardProcessDefinitionCache() {
        this.processDefinitionCache.clear();
    }

    public void discardKnowledgeBaseCache() {
        this.knowledgeBaseCache.clear();
    }

    public Map<String, ProcessDefinitionEntity> getProcessDefinitionCache() {
        return this.processDefinitionCache;
    }

    public void setProcessDefinitionCache(Map<String, ProcessDefinitionEntity> processDefinitionCache) {
        this.processDefinitionCache = processDefinitionCache;
    }

    public Map<String, Object> getKnowledgeBaseCache() {
        return this.knowledgeBaseCache;
    }

    public void setKnowledgeBaseCache(Map<String, Object> knowledgeBaseCache) {
        this.knowledgeBaseCache = knowledgeBaseCache;
    }

    public List<Deployer> getDeployers() {
        return this.deployers;
    }

    public void setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
    }

    public void removeDeployment(String deploymentId) {
        List allDefinitionsForDeployment = new ProcessDefinitionQueryImpl(Context.getCommandContext()).deploymentId(deploymentId).list();
        for (ProcessDefinition processDefinition : allDefinitionsForDeployment) {
            try {
                this.removeProcessDefinition(processDefinition.getId());
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, "Could not remove process definition with id '" + processDefinition.getId() + "' from the cache.", e);
            }
        }
    }
}

