/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.impl.HistoricTaskInstanceQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;

public class HistoricTaskInstanceManager
extends AbstractHistoricManager {
    public void deleteHistoricTaskInstancesByProcessInstanceId(String processInstanceId) {
        if (this.historyLevel >= 2) {
            List taskInstanceIds = this.getDbSqlSession().selectList("selectHistoricTaskInstanceIdsByProcessInstanceId", processInstanceId);
            for (String taskInstanceId : taskInstanceIds) {
                this.deleteHistoricTaskInstanceById(taskInstanceId);
            }
        }
    }

    public long findHistoricTaskInstanceCountByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        if (this.historyLevel > 0) {
            return (Long)this.getDbSqlSession().selectOne("selectHistoricTaskInstanceCountByQueryCriteria", historicTaskInstanceQuery);
        }
        return 0L;
    }

    public List<HistoricTaskInstance> findHistoricTaskInstancesByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery, Page page) {
        if (this.historyLevel > 0) {
            return this.getDbSqlSession().selectList("selectHistoricTaskInstancesByQueryCriteria", historicTaskInstanceQuery, page);
        }
        return Collections.EMPTY_LIST;
    }

    public HistoricTaskInstanceEntity findHistoricTaskInstanceById(String taskId) {
        if (taskId == null) {
            throw new ProcessEngineException("Invalid historic task id : null");
        }
        if (this.historyLevel > 0) {
            return (HistoricTaskInstanceEntity)this.getDbSqlSession().selectOne("selectHistoricTaskInstance", taskId);
        }
        return null;
    }

    public void deleteHistoricTaskInstanceById(String taskId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.historyLevel > 0 && (historicTaskInstance = this.findHistoricTaskInstanceById(taskId)) != null) {
            CommandContext commandContext = Context.getCommandContext();
            commandContext.getHistoricDetailManager().deleteHistoricDetailsByTaskId(taskId);
            commandContext.getHistoricVariableInstanceManager().deleteHistoricVariableInstancesByTaskId(taskId);
            commandContext.getCommentManager().deleteCommentsByTaskId(taskId);
            commandContext.getAttachmentManager().deleteAttachmentsByTaskId(taskId);
            this.getDbSqlSession().delete(historicTaskInstance);
        }
    }

    public List<HistoricTaskInstance> findHistoricTaskInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectHistoricTaskInstanceByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findHistoricTaskInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectHistoricTaskInstanceCountByNativeQuery", parameterMap);
    }

    public void updateHistoricTaskInstance(TaskEntity taskEntity) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        int historyLevel = configuration.getHistoryLevel();
        if (historyLevel >= 2) {
            HistoryEventProducer eventProducer = configuration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
            HistoryEvent evt = eventProducer.createTaskInstanceUpdateEvt(taskEntity);
            eventHandler.handleEvent(evt);
        }
    }

    public void markTaskInstanceEnded(String taskId, String deleteReason) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        int historyLevel = configuration.getHistoryLevel();
        if (historyLevel >= 2) {
            HistoryEventProducer eventProducer = configuration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
            TaskEntity taskEntity = Context.getCommandContext().getDbSqlSession().selectById(TaskEntity.class, taskId);
            HistoryEvent evt = null;
            if (deleteReason != null) {
                evt = eventProducer.createTaskInstanceCompleteEvt(taskEntity, deleteReason);
            }
            eventHandler.handleEvent(evt);
        }
    }

    public void createHistoricTask(TaskEntity task) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        int historyLevel = configuration.getHistoryLevel();
        if (historyLevel >= 2) {
            HistoryEventProducer eventProducer = configuration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
            HistoryEvent evt = eventProducer.createTaskInstanceCreateEvt(task);
            eventHandler.handleEvent(evt);
        }
    }
}

