/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.HasRevision;
import org.camunda.bpm.engine.impl.db.PersistentObject;
import org.camunda.bpm.engine.impl.history.event.HistoricVariableUpdateEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.variable.ValueFields;
import org.camunda.bpm.engine.impl.variable.VariableType;

public class HistoricVariableInstanceEntity
implements ValueFields,
HistoricVariableInstance,
PersistentObject,
HasRevision,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String processInstanceId;
    protected String taskId;
    protected String executionId;
    protected String name;
    protected int revision;
    protected String variableTypeName;
    protected VariableType variableType;
    protected Long longValue;
    protected Double doubleValue;
    protected String textValue;
    protected String textValue2;
    protected ByteArrayEntity byteArrayValue;
    protected String byteArrayId;
    protected Object cachedValue;

    public HistoricVariableInstanceEntity() {
    }

    public HistoricVariableInstanceEntity(HistoricVariableUpdateEventEntity historyEvent) {
        this.updateFromEvent(historyEvent);
    }

    public void updateFromEvent(HistoricVariableUpdateEventEntity historyEvent) {
        this.id = historyEvent.getVariableInstanceId();
        this.processInstanceId = historyEvent.getProcessInstanceId();
        this.taskId = historyEvent.getTaskId();
        this.executionId = historyEvent.getExecutionId();
        this.name = historyEvent.getVariableName();
        this.variableTypeName = historyEvent.getVariableTypeName();
        this.longValue = historyEvent.getLongValue();
        this.doubleValue = historyEvent.getDoubleValue();
        this.textValue = historyEvent.getTextValue();
        this.textValue2 = historyEvent.getTextValue2();
        this.deleteByteArrayValue();
        if (historyEvent.getByteValue() != null) {
            this.setByteArrayValue(historyEvent.getByteValue());
        }
    }

    public void delete() {
        this.deleteByteArrayValue();
        Context.getCommandContext().getDbSqlSession().delete(this);
    }

    @Override
    public Object getPersistentState() {
        ArrayList<Object> state = new ArrayList<Object>(5);
        state.add(this.textValue);
        state.add(this.textValue2);
        state.add(this.doubleValue);
        state.add(this.longValue);
        state.add(this.byteArrayId);
        return state;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public Object getValue() {
        if (!this.variableType.isCachable() || this.cachedValue == null) {
            this.cachedValue = this.variableType.getValue(this);
        }
        return this.cachedValue;
    }

    @Override
    public String getByteArrayValueId() {
        return this.byteArrayId;
    }

    public String getByteArrayId() {
        return this.byteArrayId;
    }

    public void setByteArrayId(String byteArrayId) {
        this.byteArrayId = byteArrayId;
        this.byteArrayValue = null;
    }

    @Override
    public ByteArrayEntity getByteArrayValue() {
        if (this.byteArrayValue == null && this.byteArrayId != null) {
            this.byteArrayValue = Context.getCommandContext().getDbSqlSession().selectById(ByteArrayEntity.class, this.byteArrayId);
        }
        return this.byteArrayValue;
    }

    @Override
    public void setByteArrayValue(byte[] bytes) {
        ByteArrayEntity byteArrayValue = null;
        this.deleteByteArrayValue();
        if (bytes != null) {
            byteArrayValue = new ByteArrayEntity(this.name, bytes);
            Context.getCommandContext().getDbSqlSession().insert(byteArrayValue);
        }
        this.byteArrayValue = byteArrayValue;
        this.byteArrayId = byteArrayValue != null ? byteArrayValue.getId() : null;
    }

    protected void deleteByteArrayValue() {
        if (this.byteArrayId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(this.byteArrayId);
            this.byteArrayId = null;
        }
    }

    @Override
    public String getVariableTypeName() {
        return this.variableTypeName;
    }

    @Override
    public String getVariableName() {
        return this.name;
    }

    public VariableType getVariableType() {
        return this.variableType;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Long getLongValue() {
        return this.longValue;
    }

    @Override
    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    @Override
    public Double getDoubleValue() {
        return this.doubleValue;
    }

    @Override
    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    @Override
    public String getTextValue() {
        return this.textValue;
    }

    @Override
    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    @Override
    public String getTextValue2() {
        return this.textValue2;
    }

    @Override
    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    public void setByteArrayValue(ByteArrayEntity byteArrayValue) {
        this.byteArrayValue = byteArrayValue;
    }

    @Override
    public Object getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public void setCachedValue(Object cachedValue) {
        this.cachedValue = cachedValue;
    }

    public void setVariableType(VariableType variableType) {
        this.variableType = variableType;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", processInstanceId=" + this.processInstanceId + ", taskId=" + this.taskId + ", executionId=" + this.executionId + ", name=" + this.name + ", revision=" + this.revision + ", variableTypeName=" + this.variableTypeName + ", longValue=" + this.longValue + ", doubleValue=" + this.doubleValue + ", textValue=" + this.textValue + ", textValue2=" + this.textValue2 + ", byteArrayId=" + this.byteArrayId + "]";
    }
}

