/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.task.Task;

public class TaskManager
extends AbstractManager {
    public void deleteTasksByProcessInstanceId(String processInstanceId, String deleteReason, boolean cascade) {
        List tasks = this.getDbSqlSession().createTaskQuery().processInstanceId(processInstanceId).list();
        String reason = deleteReason == null || deleteReason.length() == 0 ? "deleted" : deleteReason;
        for (TaskEntity task : tasks) {
            this.deleteTask(task, reason, cascade);
        }
    }

    public void deleteTask(TaskEntity task, String deleteReason, boolean cascade) {
        if (!task.isDeleted()) {
            task.setDeleted(true);
            CommandContext commandContext = Context.getCommandContext();
            String taskId = task.getId();
            List<Task> subTasks = this.findTasksByParentTaskId(taskId);
            for (Task subTask : subTasks) {
                this.deleteTask((TaskEntity)subTask, deleteReason, cascade);
            }
            commandContext.getIdentityLinkManager().deleteIdentityLinksByTaskId(taskId);
            commandContext.getVariableInstanceManager().deleteVariableInstanceByTask(task);
            if (cascade) {
                commandContext.getHistoricTaskInstanceManager().deleteHistoricTaskInstanceById(taskId);
            } else {
                commandContext.getHistoricTaskInstanceManager().markTaskInstanceEnded(taskId, deleteReason);
            }
            this.getDbSqlSession().delete(task);
        }
    }

    public TaskEntity findTaskById(String id) {
        if (id == null) {
            throw new ProcessEngineException("Invalid task id : null");
        }
        return this.getDbSqlSession().selectById(TaskEntity.class, id);
    }

    public List<TaskEntity> findTasksByExecutionId(String executionId) {
        return this.getDbSqlSession().selectList("selectTasksByExecutionId", executionId);
    }

    public List<TaskEntity> findTasksByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectTasksByProcessInstanceId", processInstanceId);
    }

    @Deprecated
    public List<Task> findTasksByQueryCriteria(TaskQueryImpl taskQuery, Page page) {
        taskQuery.setFirstResult(page.getFirstResult());
        taskQuery.setMaxResults(page.getMaxResults());
        return this.findTasksByQueryCriteria(taskQuery);
    }

    public List<Task> findTasksByQueryCriteria(TaskQueryImpl taskQuery) {
        String query = "selectTaskByQueryCriteria";
        return this.getDbSqlSession().selectList("selectTaskByQueryCriteria", taskQuery);
    }

    public long findTaskCountByQueryCriteria(TaskQueryImpl taskQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectTaskCountByQueryCriteria", taskQuery);
    }

    public List<Task> findTasksByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectTaskByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findTaskCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectTaskCountByNativeQuery", parameterMap);
    }

    public List<Task> findTasksByParentTaskId(String parentTaskId) {
        return this.getDbSqlSession().selectList("selectTasksByParentTaskId", parentTaskId);
    }

    public void deleteTask(String taskId, String deleteReason, boolean cascade) {
        TaskEntity task = Context.getCommandContext().getTaskManager().findTaskById(taskId);
        if (task != null) {
            if (task.getExecutionId() != null) {
                throw new ProcessEngineException("The task cannot be deleted because is part of a running process");
            }
            String reason = deleteReason == null || deleteReason.length() == 0 ? "deleted" : deleteReason;
            this.deleteTask(task, reason, cascade);
        } else if (cascade) {
            Context.getCommandContext().getHistoricTaskInstanceManager().deleteHistoricTaskInstanceById(taskId);
        }
    }

    public void updateTaskSuspensionStateByProcessDefinitionId(String processDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbSqlSession().update("updateTaskSuspensionStateByParameters", parameters);
    }

    public void updateTaskSuspensionStateByProcessInstanceId(String processInstanceId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbSqlSession().update("updateTaskSuspensionStateByParameters", parameters);
    }

    public void updateTaskSuspensionStateByProcessDefinitionKey(String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbSqlSession().update("updateTaskSuspensionStateByParameters", parameters);
    }
}

