/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import java.util.List;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperation;
import org.camunda.bpm.engine.impl.pvm.runtime.InterpretableExecution;

public abstract class AtomicOperationCreateConcurrentExecution
implements AtomicOperation {
    @Override
    public void execute(InterpretableExecution execution) {
        InterpretableExecution propagatingExecution = execution;
        PvmActivity concurrentActivity = execution.getNextActivity();
        PvmScope concurrencyScope = concurrentActivity.getScope();
        if (this.isLeaf(execution)) {
            if (execution.getActivity() != null && !((ActivityImpl)execution.getActivity()).isScope() && concurrencyScope != concurrentActivity.getParent() && concurrencyScope == execution.getActivity().getParent() && !((ActivityImpl)concurrentActivity.getParent()).isScope()) {
                InterpretableExecution replacingExecution = (InterpretableExecution)execution.createExecution();
                replacingExecution.replace(execution);
                replacingExecution.setActivity((ActivityImpl)execution.getActivity());
                replacingExecution.setActive(execution.isActive());
                replacingExecution.setScope(false);
                replacingExecution.setConcurrent(true);
                execution.setActive(false);
                execution.setActivity(null);
                propagatingExecution = this.createConcurrentExecution(execution, concurrentActivity);
            } else {
                InterpretableExecution parent = execution.getParent();
                if (!parent.isConcurrent()) {
                    execution.setConcurrent(true);
                } else {
                    parent = parent.getParent();
                }
                propagatingExecution = this.createConcurrentExecution(parent, concurrentActivity);
            }
        } else {
            List<? extends ActivityExecution> childExecutions = execution.getExecutions();
            if (childExecutions.size() == 1 && execution.getActivity() == null && !execution.isActive()) {
                InterpretableExecution existingChild = (InterpretableExecution)childExecutions.get(0);
                existingChild.setConcurrent(true);
                propagatingExecution = this.createConcurrentExecution(execution, concurrentActivity);
            } else {
                ActivityImpl parentActivity;
                InterpretableExecution concurrentRoot = execution;
                PvmScope parentScope = concurrentActivity.getParent();
                if (parentScope instanceof ActivityImpl && (parentActivity = (ActivityImpl)parentScope).isScope()) {
                    concurrentRoot = execution.getParent();
                    if (!concurrentRoot.isConcurrent()) {
                        execution.setConcurrent(true);
                    } else {
                        concurrentRoot = concurrentRoot.getParent();
                    }
                }
                propagatingExecution = this.createConcurrentExecution(concurrentRoot, concurrentActivity);
            }
        }
        this.concurrentExecutionCreated(propagatingExecution);
    }

    protected abstract void concurrentExecutionCreated(InterpretableExecution var1);

    protected InterpretableExecution createConcurrentExecution(InterpretableExecution execution, PvmActivity concurrentActivity) {
        InterpretableExecution newConcurrentExecution = (InterpretableExecution)execution.createExecution();
        newConcurrentExecution.setActivity((ActivityImpl)concurrentActivity);
        newConcurrentExecution.setScope(false);
        newConcurrentExecution.setActive(true);
        newConcurrentExecution.setConcurrent(true);
        return newConcurrentExecution;
    }

    protected boolean isConcurrentRoot(InterpretableExecution execution) {
        List<? extends ActivityExecution> executions = execution.getExecutions();
        if (executions == null || executions.size() == 0) {
            return false;
        }
        return executions.get(0).isConcurrent();
    }

    protected boolean isLeaf(InterpretableExecution execution) {
        return execution.getExecutions().isEmpty();
    }

    protected PvmScope getCurrentScope(InterpretableExecution execution) {
        ActivityImpl activity = (ActivityImpl)execution.getActivity();
        if (activity == null) {
            return null;
        }
        return activity.isScope() ? activity : activity.getParent();
    }

    @Override
    public boolean isAsync(InterpretableExecution execution) {
        return false;
    }
}

