/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.pvm.delegate.SubProcessActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperationActivityInstanceEnd;
import org.camunda.bpm.engine.impl.pvm.runtime.InterpretableExecution;

public class AtomicOperationProcessEnd
extends AtomicOperationActivityInstanceEnd {
    private static Logger log = Logger.getLogger(AtomicOperationProcessEnd.class.getName());

    @Override
    protected ScopeImpl getScope(InterpretableExecution execution) {
        return execution.getProcessDefinition();
    }

    @Override
    protected String getEventName() {
        return "end";
    }

    @Override
    protected void eventNotificationsCompleted(InterpretableExecution execution) {
        super.eventNotificationsCompleted(execution);
        InterpretableExecution superExecution = execution.getSuperExecution();
        SubProcessActivityBehavior subProcessActivityBehavior = null;
        if (superExecution != null) {
            ActivityImpl activity = (ActivityImpl)superExecution.getActivity();
            subProcessActivityBehavior = (SubProcessActivityBehavior)activity.getActivityBehavior();
            try {
                subProcessActivityBehavior.completing(superExecution, execution);
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, "Error while completing sub process of execution " + execution, e);
                throw e;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error while completing sub process of execution " + execution, e);
                throw new ProcessEngineException("Error while completing sub process of execution " + execution, e);
            }
        }
        execution.destroy();
        execution.remove();
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
            try {
                subProcessActivityBehavior.completed(superExecution);
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, "Error while completing sub process of execution " + execution, e);
                throw e;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error while completing sub process of execution " + execution, e);
                throw new ProcessEngineException("Error while completing sub process of execution " + execution, e);
            }
        }
    }

    @Override
    public String getCanonicalName() {
        return "process-end";
    }
}

