/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import java.util.List;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.AbstractEventAtomicOperation;
import org.camunda.bpm.engine.impl.pvm.runtime.InterpretableExecution;
import org.camunda.bpm.engine.impl.pvm.runtime.ProcessInstanceStartContext;

public class AtomicOperationProcessStart
extends AbstractEventAtomicOperation {
    @Override
    public boolean isAsync(InterpretableExecution execution) {
        ProcessInstanceStartContext startContext = execution.getProcessInstanceStartContext();
        return startContext != null && startContext.isAsync();
    }

    @Override
    protected ScopeImpl getScope(InterpretableExecution execution) {
        return execution.getProcessDefinition();
    }

    @Override
    protected String getEventName() {
        return "start";
    }

    @Override
    protected void eventNotificationsCompleted(InterpretableExecution execution) {
        ProcessDefinitionImpl processDefinition = execution.getProcessDefinition();
        ProcessInstanceStartContext processInstanceStartContext = execution.getProcessInstanceStartContext();
        List<ActivityImpl> initialActivityStack = processDefinition.getInitialActivityStack(processInstanceStartContext.getInitial());
        execution.setActivity(initialActivityStack.get(0));
        execution.performOperation(PROCESS_START_INITIAL);
    }

    @Override
    public String getCanonicalName() {
        return "process-start";
    }
}

