/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperation;
import org.camunda.bpm.engine.impl.pvm.runtime.InterpretableExecution;

public class AtomicOperationTransitionCreateScope
implements AtomicOperation {
    private static Logger log = Logger.getLogger(AtomicOperationTransitionCreateScope.class.getName());

    @Override
    public boolean isAsync(InterpretableExecution execution) {
        ActivityImpl activity = (ActivityImpl)execution.getActivity();
        return activity.isAsync();
    }

    @Override
    public void execute(InterpretableExecution execution) {
        execution.setActivityInstanceId(execution.getParentActivityInstanceId());
        InterpretableExecution propagatingExecution = null;
        ActivityImpl activity = (ActivityImpl)execution.getActivity();
        if (activity.isScope()) {
            propagatingExecution = (InterpretableExecution)execution.createExecution();
            propagatingExecution.setActivity(activity);
            propagatingExecution.setTransition(execution.getTransition());
            execution.setTransition(null);
            execution.setActive(false);
            execution.setActivity(null);
            log.fine("create scope: parent " + execution + " continues as execution " + propagatingExecution);
            propagatingExecution.initialize();
        } else {
            propagatingExecution = execution;
        }
        propagatingExecution.performOperation(AtomicOperation.TRANSITION_NOTIFY_LISTENER_START);
    }

    @Override
    public String getCanonicalName() {
        return "transition-create-scope";
    }
}

