/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.persistence.entity.ActivityInstanceState;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmException;
import org.camunda.bpm.engine.impl.pvm.PvmExecution;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmProcessElement;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.ExecutionListenerExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperation;
import org.camunda.bpm.engine.impl.pvm.runtime.FoxAtomicOperationDeleteCascadeFireActivityEnd;
import org.camunda.bpm.engine.impl.pvm.runtime.InterpretableExecution;
import org.camunda.bpm.engine.impl.pvm.runtime.OutgoingExecution;
import org.camunda.bpm.engine.impl.pvm.runtime.ProcessInstanceStartContext;

public class ExecutionImpl
implements Serializable,
ActivityExecution,
ExecutionListenerExecution,
PvmExecution,
InterpretableExecution {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ExecutionImpl.class.getName());
    private static AtomicInteger idGenerator = new AtomicInteger();
    protected ProcessDefinitionImpl processDefinition;
    protected ActivityImpl activity;
    protected PvmActivity nextActivity;
    protected String activityInstanceId;
    protected TransitionImpl transition = null;
    protected TransitionImpl transitionBeingTaken = null;
    protected ExecutionImpl processInstance;
    protected ExecutionImpl parent;
    protected List<ExecutionImpl> executions;
    protected ExecutionImpl superExecution;
    protected ExecutionImpl subProcessInstance;
    protected ProcessInstanceStartContext processInstanceStartContext;
    protected String businessKey;
    protected boolean isActive = true;
    protected boolean isScope = true;
    protected boolean isConcurrent = false;
    protected boolean isEnded = false;
    protected boolean isEventScope = false;
    protected int activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
    protected Map<String, Object> variables = null;
    protected String eventName;
    protected PvmProcessElement eventSource;
    protected int executionListenerIndex = 0;
    protected boolean deleteRoot;
    protected String deleteReason;
    protected ExecutionImpl replacedBy;
    protected AtomicOperation nextOperation;
    protected boolean isOperating = false;

    public ExecutionImpl() {
    }

    public ExecutionImpl(ActivityImpl initial) {
        this.processInstanceStartContext = new ProcessInstanceStartContext(initial);
    }

    @Override
    public ExecutionImpl createExecution() {
        ExecutionImpl createdExecution = this.newExecution();
        this.ensureExecutionsInitialized();
        this.executions.add(createdExecution);
        createdExecution.setParent(this);
        createdExecution.setProcessDefinition(this.getProcessDefinition());
        createdExecution.setProcessInstance(this.getProcessInstance());
        createdExecution.setActivity(this.getActivity());
        createdExecution.activityInstanceId = this.activityInstanceId;
        return createdExecution;
    }

    protected ExecutionImpl newExecution() {
        return new ExecutionImpl();
    }

    @Override
    public PvmProcessInstance createSubProcessInstance(PvmProcessDefinition processDefinition) {
        return this.createSubProcessInstance(processDefinition, null);
    }

    @Override
    public PvmProcessInstance createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey) {
        ExecutionImpl subProcessInstance = this.newExecution();
        subProcessInstance.setSuperExecution(this);
        this.setSubProcessInstance(subProcessInstance);
        subProcessInstance.setProcessDefinition((ProcessDefinitionImpl)processDefinition);
        subProcessInstance.setProcessInstance(subProcessInstance);
        if (businessKey != null) {
            subProcessInstance.setBusinessKey(businessKey);
        }
        return subProcessInstance;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void destroy() {
        this.setScope(false);
    }

    @Override
    public void remove() {
        this.isEnded = true;
        this.isActive = false;
        this.ensureParentInitialized();
        if (this.parent != null) {
            this.parent.ensureExecutionsInitialized();
            this.parent.executions.remove(this);
        }
        ArrayList<ExecutionImpl> childExecutions = new ArrayList<ExecutionImpl>(this.getExecutions());
        for (InterpretableExecution interpretableExecution : childExecutions) {
            if (!interpretableExecution.isEventScope()) continue;
            log.fine("removing eventScope " + interpretableExecution);
            interpretableExecution.destroy();
            interpretableExecution.remove();
        }
    }

    @Override
    public void cancelScope(String reason) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("performing destroy scope behavior for execution " + this);
        }
        ArrayList<ExecutionImpl> executions = new ArrayList<ExecutionImpl>(this.getExecutions());
        for (InterpretableExecution interpretableExecution : executions) {
            if (interpretableExecution.getSubProcessInstance() != null) {
                interpretableExecution.getSubProcessInstance().deleteCascade(reason);
            }
            interpretableExecution.deleteCascade(reason);
        }
    }

    @Override
    public void interruptScope(String reason) {
    }

    @Override
    public ExecutionImpl getParent() {
        this.ensureParentInitialized();
        return this.parent;
    }

    @Override
    public String getParentId() {
        this.ensureActivityInitialized();
        if (this.parent != null) {
            return this.parent.getId();
        }
        return null;
    }

    @Override
    public void setParent(InterpretableExecution parent) {
        this.parent = (ExecutionImpl)parent;
    }

    protected void ensureParentInitialized() {
    }

    public List<ExecutionImpl> getExecutions() {
        this.ensureExecutionsInitialized();
        return this.executions;
    }

    @Override
    public ExecutionImpl getSuperExecution() {
        this.ensureSuperExecutionInitialized();
        return this.superExecution;
    }

    public void setSuperExecution(ExecutionImpl superExecution) {
        this.superExecution = superExecution;
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
        }
    }

    protected void ensureSuperExecutionInitialized() {
    }

    @Override
    public ExecutionImpl getSubProcessInstance() {
        this.ensureSubProcessInstanceInitialized();
        return this.subProcessInstance;
    }

    @Override
    public void setSubProcessInstance(InterpretableExecution subProcessInstance) {
        this.subProcessInstance = (ExecutionImpl)subProcessInstance;
    }

    protected void ensureSubProcessInstanceInitialized() {
    }

    @Override
    public void deleteCascade(String deleteReason) {
        this.deleteReason = deleteReason;
        this.deleteRoot = true;
        this.performOperation(AtomicOperation.DELETE_CASCADE);
    }

    @Override
    public void deleteCascade2(String deleteReason) {
        this.deleteReason = deleteReason;
        this.deleteRoot = true;
        this.performOperation(new FoxAtomicOperationDeleteCascadeFireActivityEnd());
    }

    @Override
    public void end(boolean completeScope) {
        this.setCompleteScope(completeScope);
        this.isActive = false;
        this.isEnded = true;
        this.performOperation(AtomicOperation.ACTIVITY_END);
    }

    @Override
    public ExecutionImpl findExecution(String activityId) {
        if (this.getActivity() != null && this.getActivity().getId().equals(activityId)) {
            return this;
        }
        for (ExecutionImpl nestedExecution : this.getExecutions()) {
            ExecutionImpl result = nestedExecution.findExecution(activityId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public List<String> findActiveActivityIds() {
        ArrayList<String> activeActivityIds = new ArrayList<String>();
        this.collectActiveActivityIds(activeActivityIds);
        return activeActivityIds;
    }

    protected void collectActiveActivityIds(List<String> activeActivityIds) {
        this.ensureActivityInitialized();
        if (this.isActive && this.activity != null) {
            activeActivityIds.add(this.activity.getId());
        }
        this.ensureExecutionsInitialized();
        for (ExecutionImpl execution : this.executions) {
            execution.collectActiveActivityIds(activeActivityIds);
        }
    }

    protected void ensureExecutionsInitialized() {
        if (this.executions == null) {
            this.executions = new ArrayList<ExecutionImpl>();
        }
    }

    @Override
    public ProcessDefinitionImpl getProcessDefinition() {
        this.ensureProcessDefinitionInitialized();
        return this.processDefinition;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.getProcessDefinition().getId();
    }

    protected void ensureProcessDefinitionInitialized() {
    }

    public ExecutionImpl getProcessInstance() {
        this.ensureProcessInstanceInitialized();
        return this.processInstance;
    }

    @Override
    public String getProcessInstanceId() {
        return this.getProcessInstance().getId();
    }

    @Override
    public String getBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public String getProcessBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    @Override
    public void setProcessInstance(InterpretableExecution processInstance) {
        this.processInstance = (ExecutionImpl)processInstance;
    }

    protected void ensureProcessInstanceInitialized() {
    }

    @Override
    public ActivityImpl getActivity() {
        this.ensureActivityInitialized();
        return this.activity;
    }

    @Override
    public void setActivity(PvmActivity activity) {
        this.activity = (ActivityImpl)activity;
    }

    protected void ensureActivityInitialized() {
    }

    @Override
    public void enterActivityInstance() {
        this.activity = this.getActivity();
        if (this.activity == null && this.processInstanceStartContext != null) {
            this.activity = this.processInstanceStartContext.getInitial();
        }
        this.activityInstanceId = this.generateActivityInstanceId(this.activity.getId());
        if (log.isLoggable(Level.FINE)) {
            log.fine("[ENTER] " + this + ": " + this.activityInstanceId + ", parent: " + this.getParentActivityInstanceId());
        }
    }

    @Override
    public void leaveActivityInstance() {
        if (this.activityInstanceId != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("[LEAVE] " + this + ": " + this.activityInstanceId);
            }
            this.activityInstanceId = this.getParentActivityInstanceId();
        }
        this.activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
    }

    @Override
    public String getParentActivityInstanceId() {
        if (this.isProcessInstance()) {
            return String.valueOf(System.identityHashCode(this.getProcessInstance()));
        }
        ExecutionImpl parent = this.getParent();
        ActivityImpl activity = this.getActivity();
        ActivityImpl parentActivity = parent.getActivity();
        if (parent.isScope() && !this.isConcurrent() || parent.isConcurrent && activity != parentActivity) {
            return parent.getActivityInstanceId();
        }
        return parent.getParentActivityInstanceId();
    }

    protected String generateActivityInstanceId(String activityId) {
        int nextId = idGenerator.incrementAndGet();
        String compositeId = activityId + ":" + nextId;
        if (compositeId.length() > 64) {
            return String.valueOf(nextId);
        }
        return compositeId;
    }

    protected void ensureScopeInitialized() {
    }

    @Override
    public boolean isScope() {
        return this.isScope;
    }

    @Override
    public void setScope(boolean isScope) {
        this.isScope = isScope;
    }

    @Override
    public void start() {
        this.start(null, null);
    }

    @Override
    public void start(Map<String, Object> variables) {
        this.start(null, variables);
    }

    @Override
    public void start(String businessKey) {
        this.start(businessKey, null);
    }

    @Override
    public void start(String businessKey, Map<String, Object> variables) {
        if (this.isProcessInstance() && this.processInstanceStartContext == null) {
            this.processInstanceStartContext = new ProcessInstanceStartContext(this.processDefinition.getInitial());
        }
        if (variables != null) {
            this.setVariables(variables);
        }
        if (businessKey != null) {
            this.setBusinessKey(businessKey);
        }
        this.performOperation(AtomicOperation.PROCESS_START);
    }

    @Override
    public void signal(String signalName, Object signalData) {
        this.ensureActivityInitialized();
        SignallableActivityBehavior activityBehavior = (SignallableActivityBehavior)this.activity.getActivityBehavior();
        try {
            activityBehavior.signal(this, signalName, signalData);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PvmException("couldn't process signal '" + signalName + "' on activity '" + this.activity.getId() + "': " + e.getMessage(), e);
        }
    }

    @Override
    public void take(PvmTransition transition) {
        if (this.transition != null) {
            throw new PvmException("already taking a transition");
        }
        if (transition == null) {
            throw new PvmException("transition is null");
        }
        this.setTransition((TransitionImpl)transition);
        this.performOperation(AtomicOperation.TRANSITION_NOTIFY_LISTENER_END);
    }

    @Override
    public void executeActivity(PvmActivity activity) {
        if (activity.isConcurrent()) {
            this.nextActivity = activity;
            this.performOperation(AtomicOperation.ACTIVITY_START_CONCURRENT);
        } else {
            this.setActivity((ActivityImpl)activity);
            this.performOperation(AtomicOperation.ACTIVITY_START);
        }
    }

    @Override
    public List<ActivityExecution> findInactiveConcurrentExecutions(PvmActivity activity) {
        ArrayList<ActivityExecution> inactiveConcurrentExecutionsInActivity = new ArrayList<ActivityExecution>();
        ArrayList<ActivityExecution> otherConcurrentExecutions = new ArrayList<ActivityExecution>();
        if (this.isConcurrent()) {
            List<ExecutionImpl> concurrentExecutions = this.getParent().getExecutions();
            for (ActivityExecution activityExecution : concurrentExecutions) {
                if (activityExecution.getActivity() == activity) {
                    if (activityExecution.isActive()) {
                        throw new PvmException("didn't expect active execution in " + activity + ". bug?");
                    }
                    inactiveConcurrentExecutionsInActivity.add(activityExecution);
                    continue;
                }
                otherConcurrentExecutions.add(activityExecution);
            }
        } else if (!this.isActive()) {
            inactiveConcurrentExecutionsInActivity.add(this);
        } else {
            otherConcurrentExecutions.add(this);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("inactive concurrent executions in '" + activity + "': " + inactiveConcurrentExecutionsInActivity);
            log.fine("other concurrent executions: " + otherConcurrentExecutions);
        }
        return inactiveConcurrentExecutionsInActivity;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void takeAll(List<PvmTransition> transitions, List<ActivityExecution> recyclableExecutions) {
        transitions = new ArrayList<PvmTransition>(transitions);
        List<ActivityExecution> list = recyclableExecutions = recyclableExecutions != null ? new ArrayList<ActivityExecution>(recyclableExecutions) : new ArrayList();
        if (recyclableExecutions.size() > 1) {
            for (ActivityExecution recyclableExecution : recyclableExecutions) {
                if (!((ExecutionImpl)recyclableExecution).isScope()) continue;
                throw new PvmException("joining scope executions is not allowed");
            }
        }
        ExecutionImpl concurrentRoot = this.isConcurrent && !this.isScope ? this.getParent() : this;
        ArrayList<ExecutionImpl> concurrentActiveExecutions = new ArrayList<ExecutionImpl>();
        ArrayList<ExecutionImpl> concurrentInActiveExecutions = new ArrayList<ExecutionImpl>();
        for (ExecutionImpl execution : concurrentRoot.getExecutions()) {
            if (execution.isActive()) {
                concurrentActiveExecutions.add(execution);
                continue;
            }
            concurrentInActiveExecutions.add(execution);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("transitions to take concurrent: " + transitions);
            log.fine("active concurrent executions: " + concurrentActiveExecutions);
        }
        if (transitions.size() == 1 && concurrentActiveExecutions.isEmpty() && this.allExecutionsInSameActivity(concurrentInActiveExecutions)) {
            List<ActivityExecution> recyclableExecutionImpls = recyclableExecutions;
            recyclableExecutions.remove(concurrentRoot);
            for (ExecutionImpl executionImpl : recyclableExecutionImpls) {
                if (executionImpl.isEnded()) continue;
                log.fine("pruning execution " + executionImpl);
                executionImpl.end(false);
            }
            log.fine("activating the concurrent root " + concurrentRoot + " as the single path of execution going forward");
            concurrentRoot.setActive(true);
            concurrentRoot.setActivity(this.activity);
            concurrentRoot.setConcurrent(this.hasConcurrentSiblings(concurrentRoot));
            concurrentRoot.take(transitions.get(0));
        } else {
            ArrayList<OutgoingExecution> outgoingExecutions = new ArrayList<OutgoingExecution>();
            recyclableExecutions.remove(concurrentRoot);
            log.fine("recyclable executions for reuse: " + recyclableExecutions);
            while (!transitions.isEmpty()) {
                void var8_10;
                PvmTransition outgoingTransition = transitions.remove(0);
                Object var8_11 = null;
                if (recyclableExecutions.isEmpty()) {
                    ExecutionImpl executionImpl = concurrentRoot.createExecution();
                    log.fine("new " + executionImpl + " with parent " + executionImpl.getParent() + " created to take transition " + outgoingTransition);
                } else {
                    ExecutionImpl executionImpl = (ExecutionImpl)recyclableExecutions.remove(0);
                    log.fine("recycled " + executionImpl + " to take transition " + outgoingTransition);
                }
                var8_10.setActive(true);
                var8_10.setScope(false);
                var8_10.setConcurrent(true);
                var8_10.setTransitionBeingTaken((TransitionImpl)outgoingTransition);
                outgoingExecutions.add(new OutgoingExecution((InterpretableExecution)var8_10, outgoingTransition, true));
            }
            concurrentRoot.setActivityInstanceId(concurrentRoot.getParentActivityInstanceId());
            boolean isConcurrentEnd = outgoingExecutions.isEmpty();
            for (ActivityExecution prunedExecution : recyclableExecutions) {
                log.fine("pruning execution " + prunedExecution);
                prunedExecution.end(isConcurrentEnd);
            }
            for (OutgoingExecution outgoingExecution : outgoingExecutions) {
                outgoingExecution.take();
            }
            if (isConcurrentEnd) {
                concurrentRoot.end(true);
            }
        }
    }

    protected boolean allExecutionsInSameActivity(List<ExecutionImpl> executions) {
        if (executions.size() > 1) {
            String activityId = executions.get(0).getActivity().getId();
            for (ExecutionImpl execution : executions) {
                String otherActivityId = execution.getActivity().getId();
                if (execution.isEnded || !(activityId == null && otherActivityId != null || activityId != null && otherActivityId == null) && (activityId == null || otherActivityId == null || otherActivityId.equals(activityId))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void performOperation(AtomicOperation executionOperation) {
        this.performOperationSync(executionOperation);
    }

    @Override
    public void performOperationSync(AtomicOperation executionOperation) {
        this.nextOperation = executionOperation;
        if (!this.isOperating) {
            this.isOperating = true;
            while (this.nextOperation != null) {
                AtomicOperation currentOperation = this.nextOperation;
                this.nextOperation = null;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("AtomicOperation: " + currentOperation + " on " + this);
                }
                currentOperation.execute(this);
            }
            this.isOperating = false;
        }
    }

    protected boolean hasConcurrentSiblings(ExecutionImpl concurrentRoot) {
        if (concurrentRoot.isProcessInstance()) {
            return false;
        }
        List<ExecutionImpl> executions = concurrentRoot.getParent().getExecutions();
        for (ExecutionImpl executionImpl : executions) {
            if (executionImpl == concurrentRoot || executionImpl.isEventScope()) continue;
            return true;
        }
        return false;
    }

    public boolean isActive(String activityId) {
        return this.findExecution(activityId) != null;
    }

    @Override
    public Object getVariable(String variableName) {
        this.ensureVariablesInitialized();
        if (this.variables.containsKey(variableName)) {
            return this.variables.get(variableName);
        }
        this.ensureParentInitialized();
        if (this.parent != null) {
            return this.parent.getVariable(variableName);
        }
        return null;
    }

    @Override
    public Map<String, Object> getVariables() {
        HashMap<String, Object> collectedVariables = new HashMap<String, Object>();
        this.collectVariables(collectedVariables);
        return collectedVariables;
    }

    protected void collectVariables(Map<String, Object> collectedVariables) {
        this.ensureParentInitialized();
        if (this.parent != null) {
            this.parent.collectVariables(collectedVariables);
        }
        this.ensureVariablesInitialized();
        for (String variableName : this.variables.keySet()) {
            collectedVariables.put(variableName, this.variables.get(variableName));
        }
    }

    @Override
    public void setVariables(Map<String, ? extends Object> variables) {
        this.ensureVariablesInitialized();
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.setVariable(variableName, variables.get(variableName));
            }
        }
    }

    @Override
    public void setVariable(String variableName, Object value) {
        this.ensureVariablesInitialized();
        if (this.variables.containsKey(variableName)) {
            this.setVariableLocally(variableName, value);
        } else {
            this.ensureParentInitialized();
            if (this.parent != null) {
                this.parent.setVariable(variableName, value);
            } else {
                this.setVariableLocally(variableName, value);
            }
        }
    }

    public void setVariableLocally(String variableName, Object value) {
        log.fine("setting variable '" + variableName + "' to value '" + value + "' on " + this);
        this.variables.put(variableName, value);
    }

    @Override
    public boolean hasVariable(String variableName) {
        this.ensureVariablesInitialized();
        if (this.variables.containsKey(variableName)) {
            return true;
        }
        this.ensureParentInitialized();
        if (this.parent != null) {
            return this.parent.hasVariable(variableName);
        }
        return false;
    }

    protected void ensureVariablesInitialized() {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
    }

    public String toString() {
        if (this.isProcessInstance()) {
            return "ProcessInstance[" + this.getToStringIdentity() + "]";
        }
        return (this.isEventScope ? "EventScope" : "") + (this.isConcurrent ? "Concurrent" : "") + (this.isScope() ? "Scope" : "") + "Execution[" + this.getToStringIdentity() + "]";
    }

    protected String getToStringIdentity() {
        return Integer.toString(System.identityHashCode(this));
    }

    @Override
    public boolean isProcessInstance() {
        this.ensureParentInitialized();
        return this.parent == null;
    }

    @Override
    public void inactivate() {
        this.isActive = false;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public TransitionImpl getTransition() {
        return this.transition;
    }

    @Override
    public void setTransition(TransitionImpl transition) {
        this.transition = transition;
    }

    @Override
    public Integer getExecutionListenerIndex() {
        return this.executionListenerIndex;
    }

    @Override
    public void setExecutionListenerIndex(Integer executionListenerIndex) {
        this.executionListenerIndex = executionListenerIndex;
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public void setConcurrent(boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public boolean isEnded() {
        return this.isEnded;
    }

    @Override
    public boolean isCanceled() {
        return ActivityInstanceState.CANCELED.getStateCode() == this.activityInstanceState;
    }

    @Override
    public void setCanceled(boolean canceled) {
        if (canceled) {
            this.activityInstanceState = ActivityInstanceState.CANCELED.getStateCode();
        }
    }

    @Override
    public boolean isCompleteScope() {
        return ActivityInstanceState.SCOPE_COMPLETE.getStateCode() == this.activityInstanceState;
    }

    @Override
    public void setCompleteScope(boolean completeScope) {
        if (completeScope) {
            this.activityInstanceState = ActivityInstanceState.SCOPE_COMPLETE.getStateCode();
        }
    }

    @Override
    public void setProcessDefinition(ProcessDefinitionImpl processDefinition) {
        this.processDefinition = processDefinition;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Override
    public PvmProcessElement getEventSource() {
        return this.eventSource;
    }

    @Override
    public void setEventSource(PvmProcessElement eventSource) {
        this.eventSource = eventSource;
    }

    @Override
    public String getDeleteReason() {
        return this.deleteReason;
    }

    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    @Override
    public ExecutionImpl getReplacedBy() {
        return this.replacedBy;
    }

    @Override
    public void setReplacedBy(InterpretableExecution replacedBy) {
        this.replacedBy = (ExecutionImpl)replacedBy;
        replacedBy.setActivityInstanceId(this.activityInstanceId);
    }

    @Override
    public void replace(InterpretableExecution execution) {
        this.activityInstanceId = execution.getActivityInstanceId();
        execution.leaveActivityInstance();
    }

    public void setExecutions(List<ExecutionImpl> executions) {
        this.executions = executions;
    }

    @Override
    public boolean isDeleteRoot() {
        return this.deleteRoot;
    }

    @Override
    public String getCurrentActivityId() {
        String currentActivityId = null;
        if (this.activity != null) {
            currentActivityId = this.activity.getId();
        }
        return currentActivityId;
    }

    @Override
    public String getCurrentActivityName() {
        String currentActivityName = null;
        if (this.activity != null) {
            currentActivityName = (String)this.activity.getProperty("name");
        }
        return currentActivityName;
    }

    @Override
    public Object getVariableLocal(String variableName) {
        return null;
    }

    @Override
    public Set<String> getVariableNames() {
        return null;
    }

    @Override
    public Set<String> getVariableNamesLocal() {
        return null;
    }

    @Override
    public Map<String, Object> getVariablesLocal() {
        return null;
    }

    @Override
    public boolean hasVariableLocal(String variableName) {
        return false;
    }

    @Override
    public boolean hasVariables() {
        return false;
    }

    @Override
    public boolean hasVariablesLocal() {
        return false;
    }

    @Override
    public void removeVariable(String variableName) {
    }

    @Override
    public void removeVariableLocal(String variableName) {
    }

    @Override
    public void removeVariables(Collection<String> variableNames) {
    }

    @Override
    public void removeVariablesLocal(Collection<String> variableNames) {
    }

    @Override
    public void removeVariables() {
    }

    @Override
    public void removeVariablesLocal() {
    }

    public void deleteVariablesLocal() {
    }

    @Override
    public void setVariableLocal(String variableName, Object value) {
    }

    @Override
    public void setVariablesLocal(Map<String, ? extends Object> variables) {
    }

    @Override
    public boolean isEventScope() {
        return this.isEventScope;
    }

    @Override
    public void setEventScope(boolean isEventScope) {
        this.isEventScope = isEventScope;
    }

    @Override
    public ProcessInstanceStartContext getProcessInstanceStartContext() {
        return this.processInstanceStartContext;
    }

    @Override
    public void disposeProcessInstanceStartContext() {
        this.processInstanceStartContext = null;
    }

    @Override
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    @Override
    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    @Override
    public PvmActivity getNextActivity() {
        return this.nextActivity;
    }

    public void setTransitionBeingTaken(TransitionImpl transitionBeingTaken) {
        this.transitionBeingTaken = transitionBeingTaken;
    }

    @Override
    public String getCurrentTransitionId() {
        if (this.transition != null) {
            return this.transition.getId();
        }
        return null;
    }
}

