/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.impl.variable.ByteArrayType;
import org.camunda.bpm.engine.impl.variable.ValueFields;

public class SerializableType
extends ByteArrayType {
    public static final String TYPE_NAME = "serializable";

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        Object deserializedObject;
        Object cachedObject = valueFields.getCachedValue();
        if (cachedObject != null) {
            return cachedObject;
        }
        byte[] bytes = (byte[])super.getValue(valueFields);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            ClassloaderAwareObjectInputStream ois = new ClassloaderAwareObjectInputStream(bais);
            deserializedObject = ois.readObject();
            valueFields.setCachedValue(deserializedObject);
            if (valueFields instanceof VariableInstanceEntity) {
                Context.getCommandContext().getDbSqlSession().addDeserializedObject(deserializedObject, bytes, (VariableInstanceEntity)valueFields);
            }
        }
        catch (Exception e) {
            throw new ProcessEngineException("Couldn't deserialize object in variable '" + valueFields.getName() + "'", e);
        }
        finally {
            IoUtil.closeSilently(bais);
        }
        return deserializedObject;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        byte[] byteArray = SerializableType.serialize(value, valueFields);
        valueFields.setCachedValue(value);
        if (valueFields.getByteArrayValue() == null && valueFields instanceof VariableInstanceEntity) {
            Context.getCommandContext().getDbSqlSession().addDeserializedObject(valueFields.getCachedValue(), byteArray, (VariableInstanceEntity)valueFields);
        }
        super.setValue(byteArray, valueFields);
    }

    public static byte[] serialize(Object value, ValueFields valueFields) {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream ois = null;
        try {
            ois = new ObjectOutputStream(baos);
            ois.writeObject(value);
        }
        catch (Exception e) {
            try {
                throw new ProcessEngineException("Couldn't serialize value '" + value + "' in variable '" + valueFields.getName() + "'", e);
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(ois);
                throw throwable;
            }
        }
        IoUtil.closeSilently(ois);
        return baos.toByteArray();
    }

    @Override
    public boolean isAbleToStore(Object value) {
        return value instanceof Serializable;
    }

    @Override
    public String getTypeNameForValue(Object value) {
        return "Serializable";
    }

    protected static class ClassloaderAwareObjectInputStream
    extends ObjectInputStream {
        public ClassloaderAwareObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return ReflectUtil.loadClass(desc.getName());
        }
    }
}

