/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.BatchModificationHelper;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class BatchModificationHistoryTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.rule);
    protected BatchModificationHelper helper = new BatchModificationHelper(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected BpmnModelInstance instance;
    private int defaultBatchJobsPerSeed;
    private int defaultInvocationsPerBatchJob;
    protected static final Date START_DATE = new Date(1457326800000L);

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
    }

    @Before
    public void setClock() {
        ClockUtil.setCurrentTime((Date)START_DATE);
    }

    @Before
    public void createBpmnModelInstance() {
        this.instance = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent("start").userTask("user1").sequenceFlowId("seq")).userTask("user2").endEvent("end").done();
    }

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    @Before
    public void storeEngineSettings() {
        ProcessEngineConfigurationImpl configuration = this.rule.getProcessEngineConfiguration();
        this.defaultBatchJobsPerSeed = configuration.getBatchJobsPerSeed();
        this.defaultInvocationsPerBatchJob = configuration.getInvocationsPerBatchJob();
    }

    @After
    public void restoreEngineSettings() {
        ProcessEngineConfigurationImpl configuration = this.rule.getProcessEngineConfiguration();
        configuration.setBatchJobsPerSeed(this.defaultBatchJobsPerSeed);
        configuration.setInvocationsPerBatchJob(this.defaultInvocationsPerBatchJob);
    }

    @After
    public void removeInstanceIds() {
        this.helper.currentProcessInstances = new ArrayList<String>();
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @Test
    public void testHistoricBatchCreation() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startAfterAsync("process1", 10, "user1", processDefinition.getId());
        HistoricBatch historicBatch = this.helper.getHistoricBatch(batch);
        Assert.assertNotNull((Object)historicBatch);
        Assert.assertEquals((Object)batch.getId(), (Object)historicBatch.getId());
        Assert.assertEquals((Object)batch.getType(), (Object)historicBatch.getType());
        Assert.assertEquals((long)batch.getTotalJobs(), (long)historicBatch.getTotalJobs());
        Assert.assertEquals((long)batch.getBatchJobsPerSeed(), (long)historicBatch.getBatchJobsPerSeed());
        Assert.assertEquals((long)batch.getInvocationsPerBatchJob(), (long)historicBatch.getInvocationsPerBatchJob());
        Assert.assertEquals((Object)batch.getSeedJobDefinitionId(), (Object)historicBatch.getSeedJobDefinitionId());
        Assert.assertEquals((Object)batch.getMonitorJobDefinitionId(), (Object)historicBatch.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)batch.getBatchJobDefinitionId(), (Object)historicBatch.getBatchJobDefinitionId());
        Assert.assertEquals((Object)START_DATE, (Object)historicBatch.getStartTime());
        Assert.assertNull((Object)historicBatch.getEndTime());
    }

    @Test
    public void testHistoricBatchCompletion() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startAfterAsync("process1", 1, "user1", processDefinition.getId());
        this.helper.executeSeedJob(batch);
        this.helper.executeJobs(batch);
        Date endDate = this.helper.addSecondsToClock(12);
        this.helper.executeMonitorJob(batch);
        HistoricBatch historicBatch = this.helper.getHistoricBatch(batch);
        Assert.assertNotNull((Object)historicBatch);
        Assert.assertEquals((Object)endDate, (Object)historicBatch.getEndTime());
    }

    @Test
    public void testHistoricSeedJobLog() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.cancelAllAsync("process1", 1, "user1", processDefinition.getId());
        HistoricJobLog jobLog = this.helper.getHistoricSeedJobLog(batch).get(0);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isCreationLog());
        Assert.assertEquals((Object)batch.getSeedJobDefinitionId(), (Object)jobLog.getJobDefinitionId());
        Assert.assertEquals((Object)"batch-seed-job", (Object)jobLog.getJobDefinitionType());
        Assert.assertEquals((Object)batch.getId(), (Object)jobLog.getJobDefinitionConfiguration());
        Assert.assertEquals((Object)START_DATE, (Object)jobLog.getTimestamp());
        Assert.assertNull((Object)jobLog.getDeploymentId());
        Assert.assertNull((Object)jobLog.getProcessDefinitionId());
        Assert.assertNull((Object)jobLog.getExecutionId());
        Assert.assertNull((Object)jobLog.getJobDueDate());
        Date executionDate = this.helper.addSecondsToClock(12);
        this.helper.executeSeedJob(batch);
        jobLog = this.helper.getHistoricSeedJobLog(batch).get(1);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isSuccessLog());
        Assert.assertEquals((Object)batch.getSeedJobDefinitionId(), (Object)jobLog.getJobDefinitionId());
        Assert.assertEquals((Object)"batch-seed-job", (Object)jobLog.getJobDefinitionType());
        Assert.assertEquals((Object)batch.getId(), (Object)jobLog.getJobDefinitionConfiguration());
        Assert.assertEquals((Object)executionDate, (Object)jobLog.getTimestamp());
        Assert.assertNull((Object)jobLog.getDeploymentId());
        Assert.assertNull((Object)jobLog.getProcessDefinitionId());
        Assert.assertNull((Object)jobLog.getExecutionId());
        Assert.assertNull((Object)jobLog.getJobDueDate());
    }

    @Test
    public void testHistoricMonitorJobLog() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startAfterAsync("process1", 1, "user1", processDefinition.getId());
        this.helper.executeSeedJob(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        List<HistoricJobLog> jobLogs = this.helper.getHistoricMonitorJobLog(batch, monitorJob);
        Assert.assertEquals((long)1L, (long)jobLogs.size());
        HistoricJobLog jobLog = jobLogs.get(0);
        this.assertCommonMonitorJobLogProperties(batch, jobLog);
        Assert.assertTrue((boolean)jobLog.isCreationLog());
        Assert.assertEquals((Object)START_DATE, (Object)jobLog.getTimestamp());
        Assert.assertNull((Object)jobLog.getJobDueDate());
        Date executionDate = this.helper.addSecondsToClock(15);
        Date monitorJobDueDate = this.helper.addSeconds(executionDate, 30);
        this.helper.executeMonitorJob(batch);
        jobLogs = this.helper.getHistoricMonitorJobLog(batch, monitorJob);
        Assert.assertEquals((long)2L, (long)jobLogs.size());
        jobLog = jobLogs.get(1);
        this.assertCommonMonitorJobLogProperties(batch, jobLog);
        Assert.assertTrue((boolean)jobLog.isSuccessLog());
        Assert.assertEquals((Object)executionDate, (Object)jobLog.getTimestamp());
        Assert.assertNull((Object)jobLog.getJobDueDate());
        monitorJob = this.helper.getMonitorJob(batch);
        jobLogs = this.helper.getHistoricMonitorJobLog(batch, monitorJob);
        Assert.assertEquals((long)1L, (long)jobLogs.size());
        jobLog = jobLogs.get(0);
        this.assertCommonMonitorJobLogProperties(batch, jobLog);
        Assert.assertTrue((boolean)jobLog.isCreationLog());
        Assert.assertEquals((Object)executionDate, (Object)jobLog.getTimestamp());
        Assert.assertEquals((Object)monitorJobDueDate, (Object)jobLog.getJobDueDate());
        executionDate = this.helper.addSecondsToClock(15);
        this.helper.executeJobs(batch);
        this.helper.executeMonitorJob(batch);
        jobLogs = this.helper.getHistoricMonitorJobLog(batch, monitorJob);
        Assert.assertEquals((long)2L, (long)jobLogs.size());
        jobLog = jobLogs.get(1);
        this.assertCommonMonitorJobLogProperties(batch, jobLog);
        Assert.assertTrue((boolean)jobLog.isSuccessLog());
        Assert.assertEquals((Object)executionDate, (Object)jobLog.getTimestamp());
        Assert.assertEquals((Object)monitorJobDueDate, (Object)jobLog.getJobDueDate());
    }

    @Test
    public void testHistoricBatchJobLog() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startAfterAsync("process1", 1, "user1", processDefinition.getId());
        this.helper.executeSeedJob(batch);
        Date executionDate = this.helper.addSecondsToClock(12);
        this.helper.executeJobs(batch);
        HistoricJobLog jobLog = this.helper.getHistoricBatchJobLog(batch).get(0);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isCreationLog());
        Assert.assertEquals((Object)batch.getBatchJobDefinitionId(), (Object)jobLog.getJobDefinitionId());
        Assert.assertEquals((Object)"instance-modification", (Object)jobLog.getJobDefinitionType());
        Assert.assertEquals((Object)batch.getId(), (Object)jobLog.getJobDefinitionConfiguration());
        Assert.assertEquals((Object)START_DATE, (Object)jobLog.getTimestamp());
        Assert.assertEquals((Object)processDefinition.getDeploymentId(), (Object)jobLog.getDeploymentId());
        Assert.assertNull((Object)jobLog.getProcessDefinitionId());
        Assert.assertNull((Object)jobLog.getExecutionId());
        Assert.assertNull((Object)jobLog.getJobDueDate());
        jobLog = this.helper.getHistoricBatchJobLog(batch).get(1);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isSuccessLog());
        Assert.assertEquals((Object)batch.getBatchJobDefinitionId(), (Object)jobLog.getJobDefinitionId());
        Assert.assertEquals((Object)"instance-modification", (Object)jobLog.getJobDefinitionType());
        Assert.assertEquals((Object)batch.getId(), (Object)jobLog.getJobDefinitionConfiguration());
        Assert.assertEquals((Object)executionDate, (Object)jobLog.getTimestamp());
        Assert.assertEquals((Object)processDefinition.getDeploymentId(), (Object)jobLog.getDeploymentId());
        Assert.assertNull((Object)jobLog.getProcessDefinitionId());
        Assert.assertNull((Object)jobLog.getExecutionId());
        Assert.assertNull((Object)jobLog.getJobDueDate());
    }

    @Test
    public void testHistoricBatchForBatchDeletion() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startTransitionAsync("process1", 1, "seq", processDefinition.getId());
        Date deletionDate = this.helper.addSecondsToClock(12);
        this.rule.getManagementService().deleteBatch(batch.getId(), false);
        HistoricBatch historicBatch = this.helper.getHistoricBatch(batch);
        Assert.assertNotNull((Object)historicBatch);
        Assert.assertEquals((Object)deletionDate, (Object)historicBatch.getEndTime());
    }

    @Test
    public void testHistoricSeedJobLogForBatchDeletion() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startBeforeAsync("process1", 1, "user1", processDefinition.getId());
        Date deletionDate = this.helper.addSecondsToClock(12);
        this.rule.getManagementService().deleteBatch(batch.getId(), false);
        HistoricJobLog jobLog = this.helper.getHistoricSeedJobLog(batch).get(1);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isDeletionLog());
        Assert.assertEquals((Object)deletionDate, (Object)jobLog.getTimestamp());
    }

    @Test
    public void testHistoricMonitorJobLogForBatchDeletion() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startAfterAsync("process1", 1, "user1", processDefinition.getId());
        this.helper.executeSeedJob(batch);
        Date deletionDate = this.helper.addSecondsToClock(12);
        this.rule.getManagementService().deleteBatch(batch.getId(), false);
        HistoricJobLog jobLog = this.helper.getHistoricMonitorJobLog(batch).get(1);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isDeletionLog());
        Assert.assertEquals((Object)deletionDate, (Object)jobLog.getTimestamp());
    }

    @Test
    public void testHistoricBatchJobLogForBatchDeletion() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startBeforeAsync("process1", 1, "user2", processDefinition.getId());
        this.helper.executeSeedJob(batch);
        Date deletionDate = this.helper.addSecondsToClock(12);
        this.rule.getManagementService().deleteBatch(batch.getId(), false);
        HistoricJobLog jobLog = this.helper.getHistoricBatchJobLog(batch).get(1);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isDeletionLog());
        Assert.assertEquals((Object)deletionDate, (Object)jobLog.getTimestamp());
    }

    @Test
    public void testDeleteHistoricBatch() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startTransitionAsync("process1", 1, "seq", processDefinition.getId());
        this.helper.executeSeedJob(batch);
        this.helper.executeJobs(batch);
        this.helper.executeMonitorJob(batch);
        HistoricBatch historicBatch = this.helper.getHistoricBatch(batch);
        this.rule.getHistoryService().deleteHistoricBatch(historicBatch.getId());
        Assert.assertNull((Object)this.helper.getHistoricBatch(batch));
        Assert.assertTrue((boolean)this.helper.getHistoricSeedJobLog(batch).isEmpty());
        Assert.assertTrue((boolean)this.helper.getHistoricMonitorJobLog(batch).isEmpty());
        Assert.assertTrue((boolean)this.helper.getHistoricBatchJobLog(batch).isEmpty());
    }

    @Test
    public void testHistoricSeedJobIncidentDeletion() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startBeforeAsync("process1", 1, "user2", processDefinition.getId());
        Job seedJob = this.helper.getSeedJob(batch);
        this.rule.getManagementService().setJobRetries(seedJob.getId(), 0);
        this.rule.getManagementService().deleteBatch(batch.getId(), false);
        this.rule.getHistoryService().deleteHistoricBatch(batch.getId());
        long historicIncidents = this.rule.getHistoryService().createHistoricIncidentQuery().count();
        Assert.assertEquals((long)0L, (long)historicIncidents);
    }

    @Test
    public void testHistoricMonitorJobIncidentDeletion() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startTransitionAsync("process1", 1, "seq", processDefinition.getId());
        this.helper.executeSeedJob(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        this.rule.getManagementService().setJobRetries(monitorJob.getId(), 0);
        this.rule.getManagementService().deleteBatch(batch.getId(), false);
        this.rule.getHistoryService().deleteHistoricBatch(batch.getId());
        long historicIncidents = this.rule.getHistoryService().createHistoricIncidentQuery().count();
        Assert.assertEquals((long)0L, (long)historicIncidents);
    }

    @Test
    public void testHistoricBatchJobLogIncidentDeletion() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startAfterAsync("process1", 3, "user1", processDefinition.getId());
        this.helper.executeSeedJob(batch);
        this.helper.failExecutionJobs(batch, 3);
        this.rule.getManagementService().deleteBatch(batch.getId(), false);
        this.rule.getHistoryService().deleteHistoricBatch(batch.getId());
        long historicIncidents = this.rule.getHistoryService().createHistoricIncidentQuery().count();
        Assert.assertEquals((long)0L, (long)historicIncidents);
    }

    protected void assertCommonMonitorJobLogProperties(Batch batch, HistoricJobLog jobLog) {
        Assert.assertNotNull((Object)jobLog);
        Assert.assertEquals((Object)batch.getMonitorJobDefinitionId(), (Object)jobLog.getJobDefinitionId());
        Assert.assertEquals((Object)"batch-monitor-job", (Object)jobLog.getJobDefinitionType());
        Assert.assertEquals((Object)batch.getId(), (Object)jobLog.getJobDefinitionConfiguration());
        Assert.assertNull((Object)jobLog.getDeploymentId());
        Assert.assertNull((Object)jobLog.getProcessDefinitionId());
        Assert.assertNull((Object)jobLog.getExecutionId());
    }
}

