/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.HashMap;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.SignalCatchModels;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationSignalCatchEventTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testMigrateEventSubscription() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(SignalCatchModels.ONE_SIGNAL_CATCH_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(SignalCatchModels.ONE_SIGNAL_CATCH_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("signalCatch", "signalCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("signalCatch", "signalCatch", "Signal");
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("signalCatch").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("signalCatch")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("signalCatch", this.testHelper.getSingleActivityInstanceBeforeMigration("signalCatch").getId()).done());
        this.rule.getRuntimeService().signalEventReceived("Signal");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateEventSubscriptionChangeActivityId() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(SignalCatchModels.ONE_SIGNAL_CATCH_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(SignalCatchModels.ONE_SIGNAL_CATCH_PROCESS).changeElementId("signalCatch", "newSignalCatch"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("signalCatch", "newSignalCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("signalCatch", "newSignalCatch", "Signal");
        this.rule.getRuntimeService().signalEventReceived("Signal");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateEventSubscriptionPreserveSignalName() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(SignalCatchModels.ONE_SIGNAL_CATCH_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((IntermediateCatchEventBuilder)ProcessModels.newModel().startEvent().intermediateCatchEvent("signalCatch").signal("newSignal")).userTask("userTask").endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("signalCatch", "signalCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("signalCatch", "signalCatch", "Signal");
        this.rule.getRuntimeService().signalEventReceived("Signal");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateEventSubscriptionUpdateSignalName() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(SignalCatchModels.ONE_SIGNAL_CATCH_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((IntermediateCatchEventBuilder)ProcessModels.newModel().startEvent().intermediateCatchEvent("signalCatch").signal("newSignal")).userTask("userTask").endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("signalCatch", "signalCatch").updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("signalCatch", "Signal", "signalCatch", "newSignal");
        this.rule.getRuntimeService().signalEventReceived("newSignal");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateJobAddParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(SignalCatchModels.ONE_SIGNAL_CATCH_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(SignalCatchModels.SUBPROCESS_SIGNAL_CATCH_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("signalCatch", "signalCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("signalCatch", "signalCatch", "Signal");
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().child("signalCatch").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("signalCatch")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("signalCatch", this.testHelper.getSingleActivityInstanceBeforeMigration("signalCatch").getId()).done());
        this.rule.getRuntimeService().signalEventReceived("Signal");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateEventSubscriptionUpdateSignalExpressionNameWithVariables() {
        String newSignalName = "newSignal-${var}";
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(SignalCatchModels.ONE_SIGNAL_CATCH_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((IntermediateCatchEventBuilder)ProcessModels.newModel().startEvent().intermediateCatchEvent("signalCatch").signal(newSignalName)).userTask("userTask").endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("signalCatch", "signalCatch").updateEventTrigger().build();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("var", "foo");
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan, variables);
        VariableInstance beforeMigration = this.testHelper.snapshotBeforeMigration.getSingleVariable("var");
        Assert.assertEquals((long)1L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        this.testHelper.assertVariableMigratedToExecution(beforeMigration, beforeMigration.getExecutionId());
        String resolvedSignalName = "newSignal-foo";
        this.testHelper.assertEventSubscriptionMigrated("signalCatch", "Signal", "signalCatch", resolvedSignalName);
        this.rule.getRuntimeService().signalEventReceived(resolvedSignalName);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }
}

