/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.usertask;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;

public class TaskAssignmentExtensionsTest
extends PluggableProcessEngineTestCase {
    public void setUp() throws Exception {
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.identityService.saveUser(this.identityService.newUser("gonzo"));
        this.identityService.saveUser(this.identityService.newUser("fozzie"));
        this.identityService.saveGroup(this.identityService.newGroup("management"));
        this.identityService.saveGroup(this.identityService.newGroup("accountancy"));
        this.identityService.createMembership("kermit", "management");
        this.identityService.createMembership("kermit", "accountancy");
        this.identityService.createMembership("fozzie", "management");
    }

    public void tearDown() throws Exception {
        this.identityService.deleteGroup("accountancy");
        this.identityService.deleteGroup("management");
        this.identityService.deleteUser("fozzie");
        this.identityService.deleteUser("gonzo");
        this.identityService.deleteUser("kermit");
    }

    @Deployment
    public void testAssigneeExtension() {
        this.runtimeService.startProcessInstanceByKey("assigneeExtension");
        List tasks = this.taskService.createTaskQuery().taskAssignee("kermit").list();
        TaskAssignmentExtensionsTest.assertEquals((int)1, (int)tasks.size());
        TaskAssignmentExtensionsTest.assertEquals((String)"my task", (String)((Task)tasks.get(0)).getName());
    }

    public void testDuplicateAssigneeDeclaration() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testDuplicateAssigneeDeclaration");
            this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
            TaskAssignmentExtensionsTest.fail((String)"Invalid BPMN 2.0 process should not parse, but it gets parsed sucessfully");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment
    public void testCandidateUsersExtension() {
        this.runtimeService.startProcessInstanceByKey("candidateUsersExtension");
        List tasks = this.taskService.createTaskQuery().taskCandidateUser("kermit").list();
        TaskAssignmentExtensionsTest.assertEquals((int)1, (int)tasks.size());
        tasks = this.taskService.createTaskQuery().taskCandidateUser("gonzo").list();
        TaskAssignmentExtensionsTest.assertEquals((int)1, (int)tasks.size());
    }

    @Deployment
    public void testCandidateGroupsExtension() {
        this.runtimeService.startProcessInstanceByKey("candidateGroupsExtension");
        List tasks = this.taskService.createTaskQuery().taskCandidateUser("kermit").list();
        TaskAssignmentExtensionsTest.assertEquals((int)1, (int)tasks.size());
        TaskAssignmentExtensionsTest.assertEquals((String)"make profit", (String)((Task)tasks.get(0)).getName());
        tasks = this.taskService.createTaskQuery().taskCandidateUser("fozzie").list();
        TaskAssignmentExtensionsTest.assertEquals((int)1, (int)tasks.size());
        TaskAssignmentExtensionsTest.assertEquals((String)"make profit", (String)((Task)tasks.get(0)).getName());
        TaskQuery query = this.taskService.createTaskQuery();
        TaskAssignmentExtensionsTest.assertEquals((long)1L, (long)query.taskCandidateGroup("management").count());
        TaskAssignmentExtensionsTest.assertEquals((long)1L, (long)query.taskCandidateGroup("accountancy").count());
    }

    @Deployment
    public void testMixedCandidateUserDefinition() {
        this.runtimeService.startProcessInstanceByKey("mixedCandidateUser");
        List tasks = this.taskService.createTaskQuery().taskCandidateUser("kermit").list();
        TaskAssignmentExtensionsTest.assertEquals((int)1, (int)tasks.size());
        tasks = this.taskService.createTaskQuery().taskCandidateUser("fozzie").list();
        TaskAssignmentExtensionsTest.assertEquals((int)1, (int)tasks.size());
        tasks = this.taskService.createTaskQuery().taskCandidateUser("gonzo").list();
        TaskAssignmentExtensionsTest.assertEquals((int)1, (int)tasks.size());
        tasks = this.taskService.createTaskQuery().taskCandidateUser("mispiggy").list();
        TaskAssignmentExtensionsTest.assertEquals((int)0, (int)tasks.size());
    }
}

