/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.dmn;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.variables.JavaSerializable;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@RequiredHistoryLevel(value="full")
public class HistoricDecisionInstanceInputOutputValueTest {
    protected static final String DECISION_PROCESS = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml";
    protected static final String DECISION_SINGLE_OUTPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml";
    @Parameterized.Parameter(value=0)
    public String valueType;
    @Parameterized.Parameter(value=1)
    public Object inputValue;
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();

    @Parameterized.Parameters(name="{index}: input({0}) = {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"string", "a"}, {"long", 1L}, {"double", 2.5}, {"bytes", "object".getBytes()}, {"object", new JavaSerializable("foo")}, {"object", Collections.singletonList(new JavaSerializable("bar"))});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void decisionInputInstanceValue() {
        this.startProcessInstanceAndEvaluateDecision(this.inputValue);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.engineRule.getHistoryService().createHistoricDecisionInstanceQuery().includeInputs().singleResult();
        List inputInstances = historicDecisionInstance.getInputs();
        Assert.assertThat((Object)inputInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionInputInstance inputInstance = (HistoricDecisionInputInstance)inputInstances.get(0);
        Assert.assertThat((Object)inputInstance.getTypeName(), (Matcher)CoreMatchers.is((Object)this.valueType));
        Assert.assertThat((Object)inputInstance.getValue(), (Matcher)CoreMatchers.is((Object)this.inputValue));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void decisionOutputInstanceValue() {
        this.startProcessInstanceAndEvaluateDecision(this.inputValue);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.engineRule.getHistoryService().createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        List outputInstances = historicDecisionInstance.getOutputs();
        Assert.assertThat((Object)outputInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionOutputInstance outputInstance = (HistoricDecisionOutputInstance)outputInstances.get(0);
        Assert.assertThat((Object)outputInstance.getTypeName(), (Matcher)CoreMatchers.is((Object)this.valueType));
        Assert.assertThat((Object)outputInstance.getValue(), (Matcher)CoreMatchers.is((Object)this.inputValue));
    }

    protected ProcessInstance startProcessInstanceAndEvaluateDecision(Object input) {
        return this.engineRule.getRuntimeService().startProcessInstanceByKey("testProcess", (Map)Variables.createVariables().putValue("input1", input));
    }
}

