/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.ManagementServiceImpl;
import org.camunda.bpm.engine.impl.RuntimeServiceImpl;
import org.camunda.bpm.engine.impl.TaskServiceImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestBaseRule;
import org.camunda.bpm.engine.test.standalone.history.CustomHistoryLevelUserOperationLog;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class CustomHistoryLevelUserOperationLogTest {
    public static final String USER_ID = "demo";
    protected static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String ONE_TASK_CASE = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    HistoryLevel customHistoryLevelUOL = new CustomHistoryLevelUserOperationLog();
    public ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setJdbcUrl("jdbc:h2:mem:CustomHistoryLevelUserOperationLogTest");
            configuration.setCustomHistoryLevels(Arrays.asList(CustomHistoryLevelUserOperationLogTest.this.customHistoryLevelUOL));
            configuration.setHistory("aCustomHistoryLevelUOL");
            configuration.setDatabaseSchemaUpdate("create-drop");
            return configuration;
        }
    };
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    public AuthorizationTestBaseRule authRule = new AuthorizationTestBaseRule(this.engineRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testRule);
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected ManagementServiceImpl managementService;
    protected IdentityService identityService;
    protected RepositoryService repositoryService;
    protected TaskService taskService;
    protected CaseService caseService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected ProcessInstance process;
    protected Task userTask;
    protected String processTaskId;

    @Before
    public void setUp() throws Exception {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = (ManagementServiceImpl)this.engineRule.getManagementService();
        this.identityService = this.engineRule.getIdentityService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.taskService = this.engineRule.getTaskService();
        this.caseService = this.engineRule.getCaseService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.identityService.setAuthenticatedUserId(USER_ID);
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.clearAuthentication();
        this.managementService.purge();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessInstanceOperationsById() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.suspendProcessInstanceById(this.process.getId());
        this.runtimeService.activateProcessInstanceById(this.process.getId());
        this.runtimeService.deleteProcessInstance(this.process.getId(), "a delete reason");
        Assert.assertEquals((long)3L, (long)this.query().entityType("ProcessInstance").count());
        UserOperationLogEntry deleteEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processInstanceId(this.process.getId()).operationType("Delete").singleResult();
        Assert.assertNotNull((Object)deleteEntry);
        Assert.assertEquals((Object)this.process.getId(), (Object)deleteEntry.getProcessInstanceId());
        Assert.assertNotNull((Object)deleteEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)deleteEntry.getProcessDefinitionKey());
        UserOperationLogEntry suspendEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processInstanceId(this.process.getId()).operationType("Suspend").singleResult();
        Assert.assertNotNull((Object)suspendEntry);
        Assert.assertEquals((Object)this.process.getId(), (Object)suspendEntry.getProcessInstanceId());
        Assert.assertNotNull((Object)suspendEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)suspendEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)"suspensionState", (Object)suspendEntry.getProperty());
        Assert.assertEquals((Object)"suspended", (Object)suspendEntry.getNewValue());
        Assert.assertNull((Object)suspendEntry.getOrgValue());
        UserOperationLogEntry activateEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processInstanceId(this.process.getId()).operationType("Activate").singleResult();
        Assert.assertNotNull((Object)activateEntry);
        Assert.assertEquals((Object)this.process.getId(), (Object)activateEntry.getProcessInstanceId());
        Assert.assertNotNull((Object)activateEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)activateEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)"suspensionState", (Object)activateEntry.getProperty());
        Assert.assertEquals((Object)"active", (Object)activateEntry.getNewValue());
        Assert.assertNull((Object)activateEntry.getOrgValue());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessDefinitionOperationsByKey() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.suspendProcessDefinitionByKey("oneTaskProcess", true, null);
        this.repositoryService.activateProcessDefinitionByKey("oneTaskProcess", true, null);
        this.repositoryService.deleteProcessDefinitions().byKey("oneTaskProcess").cascade().delete();
        Assert.assertEquals((long)3L, (long)this.query().entityType("ProcessDefinition").count());
        UserOperationLogEntry suspendDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionKey("oneTaskProcess").operationType("SuspendProcessDefinition").singleResult();
        Assert.assertNotNull((Object)suspendDefinitionEntry);
        Assert.assertNull((Object)suspendDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)suspendDefinitionEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)suspendDefinitionEntry.getDeploymentId());
        Assert.assertEquals((Object)"suspensionState", (Object)suspendDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"suspended", (Object)suspendDefinitionEntry.getNewValue());
        Assert.assertNull((Object)suspendDefinitionEntry.getOrgValue());
        UserOperationLogEntry activateDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionKey("oneTaskProcess").operationType("ActivateProcessDefinition").singleResult();
        Assert.assertNotNull((Object)activateDefinitionEntry);
        Assert.assertNull((Object)activateDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)activateDefinitionEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)activateDefinitionEntry.getDeploymentId());
        Assert.assertEquals((Object)"suspensionState", (Object)activateDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"active", (Object)activateDefinitionEntry.getNewValue());
        Assert.assertNull((Object)activateDefinitionEntry.getOrgValue());
        UserOperationLogEntry deleteDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionKey("oneTaskProcess").operationType("Delete").singleResult();
        Assert.assertNotNull((Object)deleteDefinitionEntry);
        Assert.assertNotNull((Object)deleteDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)deleteDefinitionEntry.getProcessDefinitionKey());
        Assert.assertNotNull((Object)deleteDefinitionEntry.getDeploymentId());
        Assert.assertEquals((Object)"cascade", (Object)deleteDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"true", (Object)deleteDefinitionEntry.getNewValue());
        Assert.assertNotNull((Object)deleteDefinitionEntry.getOrgValue());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryJobOperations() {
        this.process = this.runtimeService.startProcessInstanceByKey("process");
        this.managementService.suspendJobDefinitionByProcessDefinitionId(this.process.getProcessDefinitionId());
        this.managementService.activateJobDefinitionByProcessDefinitionId(this.process.getProcessDefinitionId());
        this.managementService.suspendJobByProcessInstanceId(this.process.getId());
        this.managementService.activateJobByProcessInstanceId(this.process.getId());
        Assert.assertEquals((long)2L, (long)this.query().entityType("JobDefinition").count());
        Assert.assertEquals((long)2L, (long)this.query().entityType("Job").count());
        UserOperationLogEntry activeJobDefinitionEntry = (UserOperationLogEntry)this.query().entityType("JobDefinition").processDefinitionId(this.process.getProcessDefinitionId()).operationType("ActivateJobDefinition").singleResult();
        Assert.assertNotNull((Object)activeJobDefinitionEntry);
        Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)activeJobDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"suspensionState", (Object)activeJobDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"active", (Object)activeJobDefinitionEntry.getNewValue());
        Assert.assertNull((Object)activeJobDefinitionEntry.getOrgValue());
        UserOperationLogEntry activateJobIdEntry = (UserOperationLogEntry)this.query().entityType("Job").processInstanceId(this.process.getProcessInstanceId()).operationType("ActivateJob").singleResult();
        Assert.assertNotNull((Object)activateJobIdEntry);
        Assert.assertEquals((Object)this.process.getProcessInstanceId(), (Object)activateJobIdEntry.getProcessInstanceId());
        Assert.assertEquals((Object)"suspensionState", (Object)activateJobIdEntry.getProperty());
        Assert.assertEquals((Object)"active", (Object)activateJobIdEntry.getNewValue());
        Assert.assertNull((Object)activateJobIdEntry.getOrgValue());
        UserOperationLogEntry suspendJobDefinitionEntry = (UserOperationLogEntry)this.query().entityType("JobDefinition").processDefinitionId(this.process.getProcessDefinitionId()).operationType("SuspendJobDefinition").singleResult();
        Assert.assertNotNull((Object)suspendJobDefinitionEntry);
        Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)suspendJobDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"suspensionState", (Object)suspendJobDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"suspended", (Object)suspendJobDefinitionEntry.getNewValue());
        Assert.assertNull((Object)suspendJobDefinitionEntry.getOrgValue());
        UserOperationLogEntry suspendedJobEntry = (UserOperationLogEntry)this.query().entityType("Job").processInstanceId(this.process.getProcessInstanceId()).operationType("SuspendJob").singleResult();
        Assert.assertNotNull((Object)suspendedJobEntry);
        Assert.assertEquals((Object)this.process.getProcessInstanceId(), (Object)suspendedJobEntry.getProcessInstanceId());
        Assert.assertEquals((Object)"suspensionState", (Object)suspendedJobEntry.getProperty());
        Assert.assertEquals((Object)"suspended", (Object)suspendedJobEntry.getNewValue());
        Assert.assertNull((Object)suspendedJobEntry.getOrgValue());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedServiceTask.bpmn20.xml"})
    public void testQueryJobRetryOperationsById() {
        this.process = this.runtimeService.startProcessInstanceByKey("failedServiceTask");
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(this.process.getProcessInstanceId()).singleResult();
        this.managementService.setJobRetries(job.getId(), 10);
        Assert.assertEquals((long)1L, (long)this.query().entityType("Job").operationType("SetJobRetries").count());
        UserOperationLogEntry jobRetryEntry = (UserOperationLogEntry)this.query().entityType("Job").jobId(job.getId()).operationType("SetJobRetries").singleResult();
        Assert.assertNotNull((Object)jobRetryEntry);
        Assert.assertEquals((Object)job.getId(), (Object)jobRetryEntry.getJobId());
        Assert.assertEquals((Object)"3", (Object)jobRetryEntry.getOrgValue());
        Assert.assertEquals((Object)"10", (Object)jobRetryEntry.getNewValue());
        Assert.assertEquals((Object)"retries", (Object)jobRetryEntry.getProperty());
        Assert.assertEquals((Object)job.getJobDefinitionId(), (Object)jobRetryEntry.getJobDefinitionId());
        Assert.assertEquals((Object)job.getProcessInstanceId(), (Object)jobRetryEntry.getProcessInstanceId());
        Assert.assertEquals((Object)job.getProcessDefinitionKey(), (Object)jobRetryEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)job.getProcessDefinitionId(), (Object)jobRetryEntry.getProcessDefinitionId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessInstanceModificationOperation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theTask")).execute();
        UserOperationLogQuery logQuery = this.query().entityType("ProcessInstance").operationType("ModifyProcessInstance");
        Assert.assertEquals((long)1L, (long)logQuery.count());
        UserOperationLogEntry logEntry = (UserOperationLogEntry)logQuery.singleResult();
        Assert.assertEquals((Object)processInstanceId, (Object)logEntry.getProcessInstanceId());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)logEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)definition.getKey(), (Object)logEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)"ModifyProcessInstance", (Object)logEntry.getOperationType());
        Assert.assertEquals((Object)"ProcessInstance", (Object)logEntry.getEntityType());
        Assert.assertNull((Object)logEntry.getProperty());
        Assert.assertNull((Object)logEntry.getOrgValue());
        Assert.assertNull((Object)logEntry.getNewValue());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryAddExecutionVariableOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(this.process.getId(), "testVariable1", (Object)"THIS IS TESTVARIABLE!!!");
        this.verifyVariableOperationAsserts(1, "SetVariable");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryAddTaskVariablesSingleAndMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariable(this.processTaskId, "testVariable3", (Object)"foo");
        this.taskService.setVariables(this.processTaskId, this.createMapForVariableAddition());
        this.taskService.setVariable(this.processTaskId, "testVariable4", (Object)"bar");
        this.verifyVariableOperationAsserts(3, "SetVariable");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryPatchExecutionVariablesOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(this.process.getId(), this.createMapForVariableAddition(), this.createCollectionForVariableDeletion());
        this.verifyVariableOperationAsserts(1, "ModifyVariable");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryPatchTaskVariablesOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(this.processTaskId, this.createMapForVariableAddition(), this.createCollectionForVariableDeletion());
        this.verifyVariableOperationAsserts(1, "ModifyVariable");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryRemoveExecutionVariablesMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.removeVariables(this.process.getId(), this.createCollectionForVariableDeletion());
        this.verifyVariableOperationAsserts(1, "RemoveVariable");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryRemoveTaskVariableOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.removeVariable(this.processTaskId, "testVariable1");
        this.verifyVariableOperationAsserts(1, "RemoveVariable");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByEntityTypes() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setAssignee(this.processTaskId, "foo");
        this.taskService.setVariable(this.processTaskId, "foo", (Object)"bar");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().entityTypeIn(new String[]{"Task", "Variable"});
        this.verifyQueryResults(query, 2);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseExecutionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setAssignee(task.getId(), USER_ID);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().caseExecutionId(caseExecutionId);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDeploymentId() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(ONE_TASK_PROCESS).deploy().getId();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().deploymentId(deploymentId);
        this.verifyQueryResults(query, 1);
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    protected void verifyQueryResults(UserOperationLogQuery query, int countExpected) {
        Assert.assertEquals((long)countExpected, (long)query.list().size());
        Assert.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            Assert.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            Assert.assertNull((Object)query.singleResult());
        }
    }

    protected void verifySingleResultFails(UserOperationLogQuery query) {
        try {
            query.singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    protected Map<String, Object> createMapForVariableAddition() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("testVariable1", "THIS IS TESTVARIABLE!!!");
        variables.put("testVariable2", "OVER 9000!");
        return variables;
    }

    protected Collection<String> createCollectionForVariableDeletion() {
        ArrayList<String> variables = new ArrayList<String>();
        variables.add("testVariable3");
        variables.add("testVariable4");
        return variables;
    }

    protected void verifyVariableOperationAsserts(int countAssertValue, String operationType) {
        UserOperationLogQuery logQuery = this.query().entityType("Variable").operationType(operationType);
        Assert.assertEquals((long)countAssertValue, (long)logQuery.count());
        if (countAssertValue > 1) {
            List logEntryList = logQuery.list();
            for (UserOperationLogEntry logEntry : logEntryList) {
                Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)logEntry.getProcessDefinitionId());
                Assert.assertEquals((Object)this.process.getProcessInstanceId(), (Object)logEntry.getProcessInstanceId());
            }
        } else {
            UserOperationLogEntry logEntry = (UserOperationLogEntry)logQuery.singleResult();
            Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)logEntry.getProcessDefinitionId());
            Assert.assertEquals((Object)this.process.getProcessInstanceId(), (Object)logEntry.getProcessInstanceId());
        }
    }

    protected UserOperationLogQuery query() {
        return this.historyService.createUserOperationLogQuery();
    }
}

