/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.ManagementServiceImpl;
import org.camunda.bpm.engine.impl.RuntimeServiceImpl;
import org.camunda.bpm.engine.impl.TaskServiceImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestBaseRule;
import org.camunda.bpm.engine.test.standalone.history.CustomHistoryLevelFullWithoutUserOperationLog;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class CustomHistoryLevelWithoutUserOperationLogTest {
    public static final String USER_ID = "demo";
    private static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String ONE_TASK_CASE = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    HistoryLevel customHistoryLevelFullWUOL = new CustomHistoryLevelFullWithoutUserOperationLog();
    public ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setJdbcUrl("jdbc:h2:mem:CustomHistoryLevelWithoutUserOperationLogTest");
            configuration.setCustomHistoryLevels(Arrays.asList(CustomHistoryLevelWithoutUserOperationLogTest.this.customHistoryLevelFullWUOL));
            configuration.setHistory("aCustomHistoryLevelWUOL");
            configuration.setDatabaseSchemaUpdate("create-drop");
            return configuration;
        }
    };
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    public AuthorizationTestBaseRule authRule = new AuthorizationTestBaseRule(this.engineRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testRule);
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected ManagementServiceImpl managementService;
    protected IdentityService identityService;
    protected RepositoryService repositoryService;
    protected TaskService taskService;
    protected CaseService caseService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected ProcessInstance process;
    protected Task userTask;
    protected String processTaskId;

    @Before
    public void setUp() throws Exception {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = (ManagementServiceImpl)this.engineRule.getManagementService();
        this.identityService = this.engineRule.getIdentityService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.taskService = this.engineRule.getTaskService();
        this.caseService = this.engineRule.getCaseService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.identityService.setAuthenticatedUserId(USER_ID);
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.clearAuthentication();
        this.managementService.purge();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessInstanceOperationsByProcessDefinitionKey() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey("oneTaskProcess");
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey("oneTaskProcess");
        Assert.assertEquals((long)0L, (long)this.query().entityType("ProcessInstance").count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessDefinitionOperationsById() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.suspendProcessDefinitionById(this.process.getProcessDefinitionId(), true, null);
        this.repositoryService.activateProcessDefinitionById(this.process.getProcessDefinitionId(), true, null);
        Assert.assertEquals((long)0L, (long)this.query().entityType("ProcessDefinition").count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryJobOperations() {
        this.process = this.runtimeService.startProcessInstanceByKey("process");
        this.managementService.suspendJobDefinitionByProcessDefinitionId(this.process.getProcessDefinitionId());
        this.managementService.activateJobDefinitionByProcessDefinitionId(this.process.getProcessDefinitionId());
        this.managementService.suspendJobByProcessInstanceId(this.process.getId());
        this.managementService.activateJobByProcessInstanceId(this.process.getId());
        Assert.assertEquals((long)0L, (long)this.query().entityType("JobDefinition").count());
        Assert.assertEquals((long)0L, (long)this.query().entityType("Job").count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedServiceTask.bpmn20.xml"})
    public void testQueryJobRetryOperationsById() {
        this.process = this.runtimeService.startProcessInstanceByKey("failedServiceTask");
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(this.process.getProcessInstanceId()).singleResult();
        this.managementService.setJobRetries(job.getId(), 10);
        Assert.assertEquals((long)0L, (long)this.query().entityType("Job").operationType("SetJobRetries").count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessInstanceModificationOperation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        processInstance.getId();
        this.repositoryService.createProcessDefinitionQuery().singleResult();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theTask")).execute();
        UserOperationLogQuery logQuery = this.query().entityType("ProcessInstance").operationType("ModifyProcessInstance");
        Assert.assertEquals((long)0L, (long)logQuery.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryAddExecutionVariablesMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariables(this.process.getId(), this.createMapForVariableAddition());
        this.verifyVariableOperationAsserts("SetVariable");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryAddTaskVariableOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariable(this.processTaskId, "testVariable1", (Object)"THIS IS TESTVARIABLE!!!");
        this.verifyVariableOperationAsserts("SetVariable");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryPatchExecutionVariablesOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(this.process.getId(), this.createMapForVariableAddition(), this.createCollectionForVariableDeletion());
        this.verifyVariableOperationAsserts("ModifyVariable");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryPatchTaskVariablesOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(this.processTaskId, this.createMapForVariableAddition(), this.createCollectionForVariableDeletion());
        this.verifyVariableOperationAsserts("ModifyVariable");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryRemoveExecutionVariableOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.removeVariable(this.process.getId(), "testVariable1");
        this.verifyVariableOperationAsserts("RemoveVariable");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByEntityTypes() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setAssignee(this.processTaskId, "foo");
        this.taskService.setVariable(this.processTaskId, "foo", (Object)"bar");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().entityTypeIn(new String[]{"Task", "Variable"});
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseDefinitionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setAssignee(task.getId(), USER_ID);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().caseDefinitionId(caseDefinitionId);
        Assert.assertEquals((long)0L, (long)query.count());
        this.taskService.setAssignee(task.getId(), null);
    }

    @Test
    public void testQueryByDeploymentId() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(ONE_TASK_PROCESS).deploy().getId();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().deploymentId(deploymentId);
        Assert.assertEquals((long)0L, (long)query.count());
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    protected Map<String, Object> createMapForVariableAddition() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("testVariable1", "THIS IS TESTVARIABLE!!!");
        variables.put("testVariable2", "OVER 9000!");
        return variables;
    }

    protected Collection<String> createCollectionForVariableDeletion() {
        ArrayList<String> variables = new ArrayList<String>();
        variables.add("testVariable3");
        variables.add("testVariable4");
        return variables;
    }

    protected void verifyVariableOperationAsserts(String operationType) {
        UserOperationLogQuery logQuery = this.query().entityType("Variable").operationType(operationType);
        Assert.assertEquals((long)0L, (long)logQuery.count());
    }

    protected UserOperationLogQuery query() {
        return this.historyService.createUserOperationLogQuery();
    }
}

