/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.io.InputStream;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.RepositoryServiceImpl;
import org.camunda.bpm.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.DiagramLayout;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;

public class ProcessDefinitionAuthorizationTest
extends AuthorizationTest {
    protected static final String ONE_TASK_PROCESS_KEY = "oneTaskProcess";
    protected static final String TWO_TASKS_PROCESS_KEY = "twoTasksProcess";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testQueryWithoutAuthorization() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadPermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults(query, 2);
    }

    public void testQueryWithMultiple() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults(query, 2);
    }

    public void testQueryWithReadPermissionOnOneTaskProcess() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults(query, 1);
        ProcessDefinition definition = (ProcessDefinition)query.singleResult();
        ProcessDefinitionAuthorizationTest.assertNotNull((Object)definition);
        ProcessDefinitionAuthorizationTest.assertEquals((String)ONE_TASK_PROCESS_KEY, (String)definition.getKey());
    }

    public void testQueryWithRevokedReadPermission() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.ALL});
        Authorization authorization = this.createRevokeAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY);
        authorization.setUserId(this.userId);
        authorization.removePermission((Permission)Permissions.READ);
        this.saveAuthorization(authorization);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults(query, 1);
        ProcessDefinition definition = (ProcessDefinition)query.singleResult();
        ProcessDefinitionAuthorizationTest.assertNotNull((Object)definition);
        ProcessDefinitionAuthorizationTest.assertEquals((String)TWO_TASKS_PROCESS_KEY, (String)definition.getKey());
    }

    public void testQueryWithGroupAuthorizationRevokedReadPermission() {
        Authorization authorization = this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*");
        authorization.setGroupId(this.groupId);
        authorization.addPermission((Permission)Permissions.ALL);
        this.saveAuthorization(authorization);
        authorization = this.createRevokeAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY);
        authorization.setGroupId(this.groupId);
        authorization.removePermission((Permission)Permissions.READ);
        this.saveAuthorization(authorization);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults(query, 1);
        ProcessDefinition definition = (ProcessDefinition)query.singleResult();
        ProcessDefinitionAuthorizationTest.assertNotNull((Object)definition);
        ProcessDefinitionAuthorizationTest.assertEquals((String)TWO_TASKS_PROCESS_KEY, (String)definition.getKey());
    }

    public void testGetProcessDefinitionWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        try {
            this.repositoryService.getProcessDefinition(processDefinitionId);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ProcessDefinition definition = this.repositoryService.getProcessDefinition(processDefinitionId);
        ProcessDefinitionAuthorizationTest.assertNotNull((Object)definition);
    }

    public void testGetDeployedProcessDefinitionWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        try {
            ((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinitionId);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetDeployedProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ReadOnlyProcessDefinition definition = ((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinitionId);
        ProcessDefinitionAuthorizationTest.assertNotNull((Object)definition);
    }

    public void testGetProcessDiagramWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        try {
            this.repositoryService.getProcessDiagram(processDefinitionId);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the process diagram");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetProcessDiagram() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        InputStream stream = this.repositoryService.getProcessDiagram(processDefinitionId);
        ProcessDefinitionAuthorizationTest.assertNull((Object)stream);
    }

    public void testGetProcessModelWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        try {
            this.repositoryService.getProcessModel(processDefinitionId);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the process model");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetProcessModel() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        InputStream stream = this.repositoryService.getProcessModel(processDefinitionId);
        ProcessDefinitionAuthorizationTest.assertNotNull((Object)stream);
    }

    public void testGetBpmnModelInstanceWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        try {
            this.repositoryService.getBpmnModelInstance(processDefinitionId);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the bpmn model instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetBpmnModelInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        BpmnModelInstance modelInstance = this.repositoryService.getBpmnModelInstance(processDefinitionId);
        ProcessDefinitionAuthorizationTest.assertNotNull((Object)modelInstance);
    }

    public void testGetProcessDiagramLayoutWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        try {
            this.repositoryService.getProcessDiagramLayout(processDefinitionId);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the process diagram layout");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetProcessDiagramLayout() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        DiagramLayout diagramLayout = this.repositoryService.getProcessDiagramLayout(processDefinitionId);
        ProcessDefinitionAuthorizationTest.assertNull((Object)diagramLayout);
    }

    public void testSuspendProcessDefinitionByIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        try {
            this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessDefinitionById() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinitionAuthorizationTest.assertTrue((boolean)definition.isSuspended());
    }

    public void testActivateProcessDefinitionByIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessDefinitionById(processDefinitionId);
        try {
            this.repositoryService.activateProcessDefinitionById(processDefinitionId);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to activate the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessDefinitionById() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessDefinitionById(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.repositoryService.activateProcessDefinitionById(processDefinitionId);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinitionAuthorizationTest.assertFalse((boolean)definition.isSuspended());
    }

    public void testSuspendProcessDefinitionByIdIncludingInstancesWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessDefinitionByIdIncludingInstancesWithUpdatePermissionOnProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessDefinitionByIdIncludingInstancesWithUpdatePermissionOnAnyProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinitionAuthorizationTest.assertTrue((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessDefinitionAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessDefinitionByIdIncludingInstancesWithUpdateInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinitionAuthorizationTest.assertTrue((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessDefinitionAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testActivateProcessDefinitionByIdIncludingInstancesWithoutAuthorization() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessDefinitionById(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to activate the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessDefinitionByIdIncludingInstancesWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessDefinitionById(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to activate the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessDefinitionByIdIncludingInstancesWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessDefinitionById(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinitionAuthorizationTest.assertFalse((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessDefinitionAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessDefinitionByIdIncludingInstancesWithUpdateInstancePermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessDefinitionById(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinitionAuthorizationTest.assertFalse((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessDefinitionAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testSuspendProcessDefinitionByKeyWithoutAuthorization() {
        try {
            this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessDefinitionByKey() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinitionAuthorizationTest.assertTrue((boolean)definition.isSuspended());
    }

    public void testActivateProcessDefinitionByKeyWithoutAuthorization() {
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        try {
            this.repositoryService.activateProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to activate the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessDefinitionByKey() {
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.repositoryService.activateProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinitionAuthorizationTest.assertFalse((boolean)definition.isSuspended());
    }

    public void testSuspendProcessDefinitionByKeyIncludingInstancesWithoutAuthorization() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessDefinitionByKeyIncludingInstancesWithUpdatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessDefinitionByKeyIncludingInstancesWithUpdatePermissionOnAnyProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinitionAuthorizationTest.assertTrue((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessDefinitionAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessDefinitionByKeyIncludingInstancesWithUpdateInstancePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinitionAuthorizationTest.assertTrue((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessDefinitionAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testActivateProcessDefinitionByKeyIncludingInstancesWithoutAuthorization() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.repositoryService.activateProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to activate the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessDefinitionByKeyIncludingInstancesWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.repositoryService.activateProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to activate the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessDefinitionByKeyIncludingInstancesWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.repositoryService.activateProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinitionAuthorizationTest.assertFalse((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessDefinitionAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessDefinitionByKeyIncludingInstancesWithUpdateInstancePermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.repositoryService.activateProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinitionAuthorizationTest.assertFalse((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessDefinitionAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testProcessDefinitionUpdateTimeToLive() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(definition.getId(), Integer.valueOf(6));
        definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinitionAuthorizationTest.assertEquals((int)6, (int)definition.getHistoryTimeToLive());
    }

    public void testDecisionDefinitionUpdateTimeToLiveWithoutAuthorizations() {
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        try {
            this.repositoryService.updateProcessDefinitionHistoryTimeToLive(definition.getId(), Integer.valueOf(6));
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testStartableInTasklist() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().startablePermissionCheck().startableInTasklist().list();
        ProcessDefinitionAuthorizationTest.assertNotNull((Object)processDefinitions);
        ProcessDefinitionAuthorizationTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().startablePermissionCheck().startableInTasklist().count());
        ProcessDefinitionAuthorizationTest.assertEquals((String)definition.getId(), (String)((ProcessDefinition)processDefinitions.get(0)).getId());
        ProcessDefinitionAuthorizationTest.assertTrue((boolean)((ProcessDefinition)processDefinitions.get(0)).isStartableInTasklist());
    }

    public void testStartableInTasklistReadAllProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().startablePermissionCheck().startableInTasklist().list();
        ProcessDefinitionAuthorizationTest.assertNotNull((Object)processDefinitions);
        ProcessDefinitionAuthorizationTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().startablePermissionCheck().startableInTasklist().count());
        ProcessDefinitionAuthorizationTest.assertEquals((String)definition.getId(), (String)((ProcessDefinition)processDefinitions.get(0)).getId());
        ProcessDefinitionAuthorizationTest.assertTrue((boolean)((ProcessDefinition)processDefinitions.get(0)).isStartableInTasklist());
    }

    public void testStartableInTasklistWithoutCreateInstancePerm() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().startablePermissionCheck().startableInTasklist().list();
        ProcessDefinitionAuthorizationTest.assertNotNull((Object)processDefinitions);
        ProcessDefinitionAuthorizationTest.assertEquals((int)0, (int)processDefinitions.size());
    }

    public void testStartableInTasklistWithoutReadDefPerm() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().startablePermissionCheck().startableInTasklist().list();
        ProcessDefinitionAuthorizationTest.assertNotNull((Object)processDefinitions);
        ProcessDefinitionAuthorizationTest.assertEquals((int)0, (int)processDefinitions.size());
    }

    public void testStartableInTasklistWithoutCreatePerm() {
        this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().startablePermissionCheck().startableInTasklist().list();
        ProcessDefinitionAuthorizationTest.assertNotNull((Object)processDefinitions);
        ProcessDefinitionAuthorizationTest.assertEquals((int)0, (int)processDefinitions.size());
    }

    protected void verifyQueryResults(ProcessDefinitionQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }
}

