/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.batch;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.api.authorization.batch.AbstractBatchAuthorizationTest;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DeleteProcessInstancesBatchAuthorizationTest
extends AbstractBatchAuthorizationTest {
    protected static final long BATCH_OPERATIONS = 3L;
    @Rule
    public RuleChain ruleChain;
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    public DeleteProcessInstancesBatchAuthorizationTest() {
        this.ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    }

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance1", "userId", new Permission[]{Permissions.READ, Permissions.DELETE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance2", "userId", new Permission[]{Permissions.READ})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance2", "userId", new Permission[]{Permissions.DELETE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process_2", "userId", new Permission[]{Permissions.DELETE_INSTANCE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance1", "userId", new Permission[]{Permissions.ALL}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance2", "userId", new Permission[]{Permissions.ALL})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process_2", "userId", new Permission[]{Permissions.READ_INSTANCE, Permissions.DELETE_INSTANCE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process_1", "userId", new Permission[]{Permissions.READ_INSTANCE, Permissions.DELETE_INSTANCE})).succeeds());
    }

    @Test
    public void testWithTwoInvocationsProcessInstancesList() {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        this.setupAndExecuteProcessInstancesListTest();
        this.assertScenario();
    }

    @Test
    public void testProcessInstancesList() {
        this.setupAndExecuteProcessInstancesListTest();
        this.assertScenario();
    }

    @Test
    public void testWithQuery() {
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceIds(new HashSet<String>(Arrays.asList(this.processInstance.getId(), this.processInstance2.getId())));
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstance1", this.processInstance.getId()).bindResource("processInstance2", this.processInstance2.getId()).bindResource("Process_2", this.sourceDefinition2.getKey()).start();
        this.batch = this.runtimeService.deleteProcessInstancesAsync(null, processInstanceQuery, "test reason");
        this.executeSeedAndBatchJobs();
        if (this.authRule.assertScenario(this.scenario) && this.testHelper.isHistoryLevelFull()) {
            Assert.assertThat((Object)this.engineRule.getHistoryService().createUserOperationLogQuery().count(), (Matcher)Is.is((Object)3L));
        }
    }

    protected void setupAndExecuteProcessInstancesListTest() {
        List<String> processInstanceIds = Arrays.asList(this.processInstance.getId(), this.processInstance2.getId());
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstance1", this.processInstance.getId()).bindResource("processInstance2", this.processInstance2.getId()).bindResource("Process_2", this.sourceDefinition2.getKey()).bindResource("Process_1", this.sourceDefinition.getKey()).start();
        this.batch = this.runtimeService.deleteProcessInstancesAsync(processInstanceIds, null, "test reason");
        this.executeSeedAndBatchJobs();
    }

    protected void assertScenario() {
        if (this.authRule.assertScenario(this.getScenario())) {
            if (this.testHelper.isHistoryLevelFull()) {
                Assert.assertThat((Object)this.engineRule.getHistoryService().createUserOperationLogQuery().count(), (Matcher)Is.is((Object)3L));
                HistoricBatch historicBatch = (HistoricBatch)this.engineRule.getHistoryService().createHistoricBatchQuery().list().get(0);
                Assert.assertEquals((Object)"userId", (Object)historicBatch.getCreateUserId());
            }
            if (this.authRule.scenarioSucceeded()) {
                Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Is.is((Object)0L));
            }
        }
    }

    @Override
    public AuthorizationScenario getScenario() {
        return this.scenario;
    }
}

