/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.history.handler.CompositeHistoryEventHandler;
import org.camunda.bpm.engine.impl.history.handler.DbHistoryEventHandler;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.history.AbstractCompositeHistoryEventHandlerTest;

public class CompositeHistoryEventHandlerTest
extends AbstractCompositeHistoryEventHandlerTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testDefaultHistoryEventHandler() {
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)new DbHistoryEventHandler());
        this.startProcessAndCompleteUserTask();
        CompositeHistoryEventHandlerTest.assertEquals((int)0, (int)this.countCustomHistoryEventHandler);
        CompositeHistoryEventHandlerTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testCompositeHistoryEventHandlerNonArgumentConstructor() {
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)new CompositeHistoryEventHandler());
        this.startProcessAndCompleteUserTask();
        CompositeHistoryEventHandlerTest.assertEquals((int)0, (int)this.countCustomHistoryEventHandler);
        CompositeHistoryEventHandlerTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    public void testCompositeHistoryEventHandlerNonArgumentConstructorAddNullEvent() {
        CompositeHistoryEventHandler compositeHistoryEventHandler = new CompositeHistoryEventHandler();
        try {
            compositeHistoryEventHandler.add(null);
            CompositeHistoryEventHandlerTest.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            this.assertTextPresent("History event handler is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testCompositeHistoryEventHandlerNonArgumentConstructorAddNotNullEvent() {
        CompositeHistoryEventHandler compositeHistoryEventHandler = new CompositeHistoryEventHandler();
        compositeHistoryEventHandler.add((HistoryEventHandler)new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler());
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        CompositeHistoryEventHandlerTest.assertEquals((int)2, (int)this.countCustomHistoryEventHandler);
        CompositeHistoryEventHandlerTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testCompositeHistoryEventHandlerNonArgumentConstructorAddNotNullTwoEvents() {
        CompositeHistoryEventHandler compositeHistoryEventHandler = new CompositeHistoryEventHandler();
        compositeHistoryEventHandler.add((HistoryEventHandler)new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler());
        compositeHistoryEventHandler.add((HistoryEventHandler)new DbHistoryEventHandler());
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        CompositeHistoryEventHandlerTest.assertEquals((int)2, (int)this.countCustomHistoryEventHandler);
        CompositeHistoryEventHandlerTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    public void testCompositeHistoryEventHandlerArgumentConstructorWithNullVarargs() {
        Object historyEventHandler = null;
        try {
            new CompositeHistoryEventHandler(new HistoryEventHandler[]{historyEventHandler});
            CompositeHistoryEventHandlerTest.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            this.assertTextPresent("History event handler is null", e.getMessage());
        }
    }

    public void testCompositeHistoryEventHandlerArgumentConstructorWithNullTwoVarargs() {
        try {
            new CompositeHistoryEventHandler(new HistoryEventHandler[]{null, null});
            CompositeHistoryEventHandlerTest.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            this.assertTextPresent("History event handler is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testCompositeHistoryEventHandlerArgumentConstructorWithNotNullVarargsOneEvent() {
        CompositeHistoryEventHandler compositeHistoryEventHandler = new CompositeHistoryEventHandler(new HistoryEventHandler[]{new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler()});
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        CompositeHistoryEventHandlerTest.assertEquals((int)2, (int)this.countCustomHistoryEventHandler);
        CompositeHistoryEventHandlerTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testCompositeHistoryEventHandlerArgumentConstructorWithNotNullVarargsTwoEvents() {
        CompositeHistoryEventHandler compositeHistoryEventHandler = new CompositeHistoryEventHandler(new HistoryEventHandler[]{new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler(), new DbHistoryEventHandler()});
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        CompositeHistoryEventHandlerTest.assertEquals((int)2, (int)this.countCustomHistoryEventHandler);
        CompositeHistoryEventHandlerTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testCompositeHistoryEventHandlerArgumentConstructorWithEmptyList() {
        CompositeHistoryEventHandler compositeHistoryEventHandler = new CompositeHistoryEventHandler(new ArrayList());
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        CompositeHistoryEventHandlerTest.assertEquals((int)0, (int)this.countCustomHistoryEventHandler);
        CompositeHistoryEventHandlerTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    public void testCompositeHistoryEventHandlerArgumentConstructorWithNotEmptyListNullTwoEvents() {
        ArrayList<Object> historyEventHandlers = new ArrayList<Object>();
        historyEventHandlers.add(null);
        historyEventHandlers.add(null);
        try {
            new CompositeHistoryEventHandler(historyEventHandlers);
            CompositeHistoryEventHandlerTest.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            this.assertTextPresent("History event handler is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testCompositeHistoryEventHandlerArgumentConstructorWithNotEmptyListNotNullTwoEvents() {
        ArrayList<AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler> historyEventHandlers = new ArrayList<AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler>();
        historyEventHandlers.add(new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler());
        historyEventHandlers.add((AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler)new DbHistoryEventHandler());
        CompositeHistoryEventHandler compositeHistoryEventHandler = new CompositeHistoryEventHandler(historyEventHandlers);
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        CompositeHistoryEventHandlerTest.assertEquals((int)2, (int)this.countCustomHistoryEventHandler);
        CompositeHistoryEventHandlerTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
    }
}

