/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.authentication;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.AuthenticationException;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.test.ResourceProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.junit.Test;

public class LoginAttemptsTest
extends ResourceProcessEngineTestCase {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public LoginAttemptsTest() {
        super("org/camunda/bpm/engine/test/standalone/authentication/camunda.cfg.xml");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ClockUtil.setCurrentTime((Date)new Date());
    }

    @Test
    public void testUsuccessfulAttemptsResultInException() throws ParseException {
        User user = this.identityService.newUser("johndoe");
        user.setPassword("xxx");
        this.identityService.saveUser(user);
        Date now = sdf.parse("2000-01-24T13:00:00");
        ClockUtil.setCurrentTime((Date)now);
        try {
            for (int i = 0; i <= 6; ++i) {
                LoginAttemptsTest.assertFalse((boolean)this.identityService.checkPassword("johndoe", "invalid pwd"));
                now = DateUtils.addSeconds((Date)now, (int)5);
                ClockUtil.setCurrentTime((Date)now);
            }
            LoginAttemptsTest.fail((String)"expected exception");
        }
        catch (AuthenticationException e) {
            LoginAttemptsTest.assertTrue((boolean)e.getMessage().contains("The user with id 'johndoe' is locked."));
        }
        this.identityService.deleteUser(user.getId());
    }
}

