/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.entitymanager.cache;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.history.event.HistoricDetailEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricFormPropertyEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricVariableUpdateEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricFormPropertyEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;

public class DbEntityCacheKeyMapping {
    protected Map<Class<?>, Class<?>> entityCacheKeys = new HashMap();

    public Class<?> getEntityCacheKey(Class<?> entityType) {
        Class<?> entityCacheKey = this.entityCacheKeys.get(entityType);
        if (entityCacheKey == null) {
            return entityType;
        }
        return entityCacheKey;
    }

    public void registerEntityCacheKey(Class<?> entityType, Class<?> cacheKey) {
        this.entityCacheKeys.put(entityType, cacheKey);
    }

    public static DbEntityCacheKeyMapping defaultEntityCacheKeyMapping() {
        DbEntityCacheKeyMapping mapping = new DbEntityCacheKeyMapping();
        mapping.registerEntityCacheKey(MessageEntity.class, JobEntity.class);
        mapping.registerEntityCacheKey(TimerEntity.class, JobEntity.class);
        mapping.registerEntityCacheKey(HistoricFormPropertyEntity.class, HistoricDetailEventEntity.class);
        mapping.registerEntityCacheKey(HistoricFormPropertyEventEntity.class, HistoricDetailEventEntity.class);
        mapping.registerEntityCacheKey(HistoricVariableUpdateEventEntity.class, HistoricDetailEventEntity.class);
        mapping.registerEntityCacheKey(HistoricDetailVariableInstanceUpdateEntity.class, HistoricDetailEventEntity.class);
        return mapping;
    }

    public static DbEntityCacheKeyMapping emptyMapping() {
        return new DbEntityCacheKeyMapping();
    }
}

