/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.optimize;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;

public class OptimizeManager
extends AbstractManager {
    public List<HistoricActivityInstance> getCompletedHistoricActivityInstances(Date finishedAfter, Date finishedAt, int maxResults) {
        this.checkAuthorization();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("finishedAfter", finishedAfter);
        params.put("finishedAt", finishedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectCompletedHistoricActivityPage", params);
    }

    private void checkAuthorization() {
        this.getAuthorizationManager().checkAuthorization(Permissions.READ_HISTORY, Resources.PROCESS_DEFINITION);
    }

    public List<HistoricProcessInstance> getCompletedHistoricProcessInstances(Date finishedAfter, Date finishedAt, int maxResults) {
        this.checkAuthorization();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("finishedAfter", finishedAfter);
        params.put("finishedAt", finishedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectCompletedHistoricProcessInstancePage", params);
    }

    public List<HistoricProcessInstance> getRunningHistoricProcessInstances(Date startedAfter, Date startedAt, int maxResults) {
        this.checkAuthorization();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("startedAfter", startedAfter);
        params.put("startedAt", startedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectRunningHistoricProcessInstancePage", params);
    }

    public List<HistoricVariableUpdate> getHistoricVariableUpdates(Date occurredAfter, Date occurredAt, int maxResults) {
        this.checkAuthorization();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("occurredAfter", occurredAfter);
        params.put("occurredAt", occurredAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectHistoricVariableUpdatePage", params);
    }
}

