/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.externaltask;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.variable.Variables;

public class ExternalTaskQueryByPriorityTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml"})
    public void testOrderByPriority() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        TestOrderingUtil.verifySortingAndCount(this.externalTaskService.createExternalTaskQuery().orderByPriority().asc(), 10, TestOrderingUtil.externalTaskByPriority());
        TestOrderingUtil.verifySortingAndCount(this.externalTaskService.createExternalTaskQuery().orderByPriority().desc(), 10, TestOrderingUtil.inverted(TestOrderingUtil.externalTaskByPriority()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml"})
    public void testFilterByExternalTaskPriorityLowerThanOrEquals() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        List tasks = this.externalTaskService.createExternalTaskQuery().priorityLowerThanOrEquals(2L).list();
        ExternalTaskQueryByPriorityTest.assertEquals((int)8, (int)tasks.size());
        for (ExternalTask task : tasks) {
            ExternalTaskQueryByPriorityTest.assertTrue((task.getPriority() <= 2L ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml"})
    public void testFilterByExternalTaskPriorityLowerThanOrEqualsAndHigherThanOrEqual() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        ExternalTaskQueryByPriorityTest.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().priorityLowerThanOrEquals(2L).priorityHigherThanOrEquals(3L).count());
        ExternalTaskQueryByPriorityTest.assertEquals((long)2L, (long)this.externalTaskService.createExternalTaskQuery().priorityHigherThanOrEquals(2L).priorityLowerThanOrEquals(3L).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml"})
    public void testFilterByExternalTaskPriorityHigherThanOrEquals() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        List tasks = this.externalTaskService.createExternalTaskQuery().priorityHigherThanOrEquals(2L).list();
        ExternalTaskQueryByPriorityTest.assertEquals((int)3, (int)tasks.size());
        HashSet<String> processInstanceIds = new HashSet<String>();
        processInstanceIds.add(((ProcessInstance)instances.get(2)).getId());
        processInstanceIds.add(((ProcessInstance)instances.get(3)).getId());
        processInstanceIds.add(((ProcessInstance)instances.get(4)).getId());
        for (ExternalTask task : tasks) {
            ExternalTaskQueryByPriorityTest.assertTrue((task.getPriority() >= 2L ? 1 : 0) != 0);
            ExternalTaskQueryByPriorityTest.assertTrue((boolean)processInstanceIds.contains(task.getProcessInstanceId()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml"})
    public void testFilterByExternalTaskPriorityLowerAndHigher() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().priorityHigherThanOrEquals(2L).priorityLowerThanOrEquals(2L).singleResult();
        ExternalTaskQueryByPriorityTest.assertNotNull((Object)task);
        ExternalTaskQueryByPriorityTest.assertEquals((long)2L, (long)task.getPriority());
        ExternalTaskQueryByPriorityTest.assertEquals((String)((ProcessInstance)instances.get(2)).getId(), (String)task.getProcessInstanceId());
    }
}

