/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Collections;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MultiTenancyCommandTenantCheckTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected IdentityService identityService;

    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.identityService = this.engineRule.getIdentityService();
        this.identityService.setAuthentication("user", null, null);
    }

    @Test
    public void disableTenantCheckForProcessEngine() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.enableTenantCheck();
                Assert.assertThat((Object)commandContext.getTenantManager().isTenantCheckEnabled(), (Matcher)CoreMatchers.is((Object)false));
                return null;
            }
        });
    }

    @Test
    public void disableTenantCheckForCommand() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.disableTenantCheck();
                Assert.assertThat((Object)commandContext.isTenantCheckEnabled(), (Matcher)CoreMatchers.is((Object)false));
                Assert.assertThat((Object)commandContext.getTenantManager().isTenantCheckEnabled(), (Matcher)CoreMatchers.is((Object)false));
                return null;
            }
        });
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                Assert.assertThat((Object)commandContext.isTenantCheckEnabled(), (Matcher)CoreMatchers.is((Object)true));
                Assert.assertThat((Object)commandContext.getTenantManager().isTenantCheckEnabled(), (Matcher)CoreMatchers.is((Object)true));
                return null;
            }
        });
    }

    @Test
    public void disableAndEnableTenantCheckForCommand() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.disableTenantCheck();
                Assert.assertThat((Object)commandContext.getTenantManager().isTenantCheckEnabled(), (Matcher)CoreMatchers.is((Object)false));
                commandContext.enableTenantCheck();
                Assert.assertThat((Object)commandContext.getTenantManager().isTenantCheckEnabled(), (Matcher)CoreMatchers.is((Object)true));
                return null;
            }
        });
    }

    @Test
    public void disableTenantCheckForCamundaAdmin() {
        this.identityService.setAuthentication("user", Collections.singletonList("camunda-admin"), null);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                Assert.assertThat((Object)commandContext.getTenantManager().isTenantCheckEnabled(), (Matcher)CoreMatchers.is((Object)false));
                return null;
            }
        });
    }
}

