/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.ArrayList;
import java.util.Collections;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class AdminGroupsTest {
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            ArrayList<String> adminGroups = new ArrayList<String>();
            adminGroups.add("adminGroup");
            configuration.setAdminGroups(adminGroups);
            return configuration;
        }
    };
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected IdentityService identityService;
    protected AuthorizationService authorizationService;

    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.identityService = this.engineRule.getIdentityService();
        this.authorizationService = this.engineRule.getAuthorizationService();
    }

    @After
    public void tearDown() throws Exception {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.cleanupAfterTest();
    }

    protected void cleanupAfterTest() {
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }

    @Test
    public void testWithoutAdminGroup() {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.identityService.newUser("jonny1");
        this.identityService.setAuthentication("nonAdmin", null, null);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.thrown.expect(AuthorizationException.class);
        this.thrown.expectMessage("Required admin authenticated group.");
        this.identityService.unlockUser("jonny1");
    }

    @Test
    public void testWithAdminGroup() {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.identityService.setAuthentication("admin", Collections.singletonList("adminGroup"), null);
        Authorization userAuth = this.authorizationService.createNewAuthorization(1);
        userAuth.setUserId("admin");
        userAuth.setResource((Resource)Resources.USER);
        userAuth.setResourceId("*");
        userAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(userAuth);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.unlockUser("jonny1");
    }
}

