/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.compensate;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.bpmn.event.compensate.helper.IncreaseCurrentTimeServiceTask;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.AssociationDirection;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CompensateEventDefinitionBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.instance.Association;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.BoundaryEvent;
import org.camunda.bpm.model.bpmn.instance.ServiceTask;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

@RequiredHistoryLevel(value="activity")
public class CompensateEventOrderTest {
    @Rule
    public ProcessEngineRule engineRule = new ProcessEngineRule();
    @Rule
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);

    @Test
    public void testTwoCompensateEventsInReverseOrder() {
        BpmnModelInstance model = ((CompensateEventDefinitionBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process_1").startEvent().serviceTask("serviceTask1").camundaClass(IncreaseCurrentTimeServiceTask.class.getName())).boundaryEvent("compensationBoundary1").compensateEventDefinition().compensateEventDefinitionDone().moveToActivity("serviceTask1").serviceTask("serviceTask2").camundaClass(IncreaseCurrentTimeServiceTask.class.getName())).boundaryEvent("compensationBoundary2").compensateEventDefinition().compensateEventDefinitionDone().moveToActivity("serviceTask2").intermediateThrowEvent("compensationEvent").compensateEventDefinition().waitForCompletion(true)).compensateEventDefinitionDone().endEvent().done();
        this.addServiceTaskCompensationHandler(model, "compensationBoundary1", "A");
        this.addServiceTaskCompensationHandler(model, "compensationBoundary2", "B");
        this.testHelper.deploy(model);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("Process_1", (Map)Variables.createVariables().putValue("currentTime", (Object)new Date()));
        List list = ((HistoricActivityInstanceQuery)this.engineRule.getHistoryService().createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceEndTime().asc()).list();
        long indexA = this.searchForActivityIndex(list, "A");
        long indexB = this.searchForActivityIndex(list, "B");
        Assert.assertNotEquals((long)-1L, (long)indexA);
        Assert.assertNotEquals((long)-1L, (long)indexB);
        Assert.assertTrue((String)"Compensation activities were executed in wrong order.", (indexA > indexB ? 1 : 0) != 0);
    }

    private long searchForActivityIndex(List<HistoricActivityInstance> historicActivityInstances, String activityId) {
        for (int i = 0; i < historicActivityInstances.size(); ++i) {
            HistoricActivityInstance historicActivityInstance = historicActivityInstances.get(i);
            if (!historicActivityInstance.getActivityId().equals(activityId)) continue;
            return i;
        }
        return -1L;
    }

    private void addServiceTaskCompensationHandler(BpmnModelInstance modelInstance, String boundaryEventId, String compensationHandlerId) {
        BoundaryEvent boundaryEvent = (BoundaryEvent)modelInstance.getModelElementById(boundaryEventId);
        BaseElement scope = (BaseElement)boundaryEvent.getParentElement();
        ServiceTask compensationHandler = (ServiceTask)modelInstance.newInstance(ServiceTask.class);
        compensationHandler.setId(compensationHandlerId);
        compensationHandler.setForCompensation(true);
        compensationHandler.setCamundaClass(IncreaseCurrentTimeServiceTask.class.getName());
        scope.addChildElement((ModelElementInstance)compensationHandler);
        Association association = (Association)modelInstance.newInstance(Association.class);
        association.setAssociationDirection(AssociationDirection.One);
        association.setSource((BaseElement)boundaryEvent);
        association.setTarget((BaseElement)compensationHandler);
        scope.addChildElement((ModelElementInstance)association);
    }
}

