/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.test.api.runtime.migration.models.CallActivityModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

@RequiredHistoryLevel(value="audit")
public class HistoricProcessInstanceTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricDataCreatedForProcessExecution() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, 2010);
        calendar.set(2, 8);
        calendar.set(5, 30);
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date noon = calendar.getTime();
        ClockUtil.setCurrentTime((Date)noon);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "myBusinessKey");
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        HistoricProcessInstanceTest.assertEquals((String)processInstance.getId(), (String)historicProcessInstance.getId());
        HistoricProcessInstanceTest.assertEquals((String)processInstance.getBusinessKey(), (String)historicProcessInstance.getBusinessKey());
        HistoricProcessInstanceTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)historicProcessInstance.getProcessDefinitionId());
        HistoricProcessInstanceTest.assertEquals((Object)noon, (Object)historicProcessInstance.getStartTime());
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getDurationInMillis());
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getCaseInstanceId());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        HistoricProcessInstanceTest.assertEquals((int)1, (int)tasks.size());
        Date twentyFiveSecsAfterNoon = new Date(noon.getTime() + 25000L);
        ClockUtil.setCurrentTime((Date)twentyFiveSecsAfterNoon);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        HistoricProcessInstanceTest.assertEquals((String)processInstance.getId(), (String)historicProcessInstance.getId());
        HistoricProcessInstanceTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)historicProcessInstance.getProcessDefinitionId());
        HistoricProcessInstanceTest.assertEquals((Object)noon, (Object)historicProcessInstance.getStartTime());
        HistoricProcessInstanceTest.assertEquals((Object)twentyFiveSecsAfterNoon, (Object)historicProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertEquals((Object)new Long(25000L), (Object)historicProcessInstance.getDurationInMillis());
        HistoricProcessInstanceTest.assertTrue((((HistoricProcessInstanceEventEntity)historicProcessInstance).getDurationRaw() >= 25000L ? 1 : 0) != 0);
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getCaseInstanceId());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "myBusinessKey");
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().unfinished().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testLongRunningHistoricDataCreatedForProcessExecution() {
        long ONE_YEAR = 1471228928L;
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(14, 0);
        Date now = cal.getTime();
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "myBusinessKey");
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertEquals((Object)now, (Object)historicProcessInstance.getStartTime());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        HistoricProcessInstanceTest.assertEquals((int)1, (int)tasks.size());
        cal.add(1, 1);
        Date oneYearLater = cal.getTime();
        ClockUtil.setCurrentTime((Date)oneYearLater);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertEquals((Object)now, (Object)historicProcessInstance.getStartTime());
        HistoricProcessInstanceTest.assertEquals((Object)oneYearLater, (Object)historicProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertTrue((historicProcessInstance.getDurationInMillis() >= 1471228928L ? 1 : 0) != 0);
        HistoricProcessInstanceTest.assertTrue((((HistoricProcessInstanceEventEntity)historicProcessInstance).getDurationRaw() >= 1471228928L ? 1 : 0) != 0);
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstanceHistoryCreated() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        HistoricProcessInstanceTest.assertNotNull((Object)processInstance);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "cancel");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getEndTime());
    }

    public void testDeleteProcessInstanceWithoutSubprocessInstances() {
        BpmnModelInstance calling = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"calling").startEvent().callActivity().calledElement("called")).endEvent("endA").done();
        BpmnModelInstance called = Bpmn.createExecutableProcess((String)"called").startEvent().userTask("Task1").endEvent().done();
        this.deployment(new BpmnModelInstance[]{calling, called});
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("calling");
        String id = instance.getId();
        this.runtimeService.deleteProcessInstance(id, "test_purposes", false, true, false, true);
        List historicSubprocessList = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("called").list();
        for (HistoricProcessInstance historicProcessInstance : historicSubprocessList) {
            HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getSuperProcessInstanceId());
        }
    }

    public void testDeleteProcessInstanceWithSubprocessInstances() {
        BpmnModelInstance calling = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"calling").startEvent().callActivity().calledElement("called")).endEvent("endA").done();
        BpmnModelInstance called = Bpmn.createExecutableProcess((String)"called").startEvent().userTask("Task1").endEvent().done();
        this.deployment(new BpmnModelInstance[]{calling, called});
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("calling");
        String id = instance.getId();
        this.runtimeService.deleteProcessInstance(id, "test_purposes", false, true, false, false);
        List historicSubprocessList = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("called").list();
        for (HistoricProcessInstance historicProcessInstance : historicSubprocessList) {
            HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getSuperProcessInstanceId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceStartDate() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Date date = new Date();
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateOn(date).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateBy(date).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateBy(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateBy(DateUtils.addDays((Date)date, (int)1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateOn(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateOn(DateUtils.addDays((Date)date, (int)1)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceFinishDateUnfinished() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Date date = new Date();
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(date).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(date).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(DateUtils.addDays((Date)date, (int)1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(DateUtils.addDays((Date)date, (int)1)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceFinishDateFinished() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Date date = new Date();
        this.runtimeService.deleteProcessInstance(pi.getId(), "cancel");
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(date).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(date).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(DateUtils.addDays((Date)date, (int)1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(DateUtils.addDays((Date)date, (int)1)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceDelete() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.deleteProcessInstance(pi.getId(), "cancel");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getDeleteReason());
        HistoricProcessInstanceTest.assertEquals((String)"cancel", (String)historicProcessInstance.getDeleteReason());
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getEndTime());
    }

    @Deployment
    public void testHistoricProcessInstanceDeleteAsync() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failing");
        this.runtimeService.deleteProcessInstance(pi.getId(), "cancel");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getDeleteReason());
        HistoricProcessInstanceTest.assertEquals((String)"cancel", (String)historicProcessInstance.getDeleteReason());
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getEndTime());
    }

    @Deployment
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcessInstanceQueryWithIncidents() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        this.executeAvailableJobs();
        this.runtimeService.startProcessInstanceByKey("Process_1");
        HistoricProcessInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        HistoricProcessInstanceTest.assertEquals((int)2, (int)this.historyService.createHistoricProcessInstanceQuery().list().size());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().withIncidents().count());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricProcessInstanceQuery().withIncidents().list().size());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike("Unknown property used%\\_Tr%").count());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike("Unknown property used%\\_Tr%").list().size());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike("Unknown message%").count());
        HistoricProcessInstanceTest.assertEquals((int)0, (int)this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike("Unknown message%").list().size());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown property used in expression: ${incidentTrigger1}. Cause: Cannot resolve identifier 'incidentTrigger1'").count());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown property used in expression: ${incidentTrigger1}. Cause: Cannot resolve identifier 'incidentTrigger1'").list().size());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown property used in expression: ${incident_Trigger2}. Cause: Cannot resolve identifier 'incident_Trigger2'").count());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown property used in expression: ${incident_Trigger2}. Cause: Cannot resolve identifier 'incident_Trigger2'").list().size());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown message").count());
        HistoricProcessInstanceTest.assertEquals((int)0, (int)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown message").list().size());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentType("failedJob").count());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricProcessInstanceQuery().incidentType("failedJob").list().size());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().withRootIncidents().count());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricProcessInstanceQuery().withRootIncidents().list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldDeleteIncidentAfterJobWasSuccessfully.bpmn"})
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcessInstanceQueryIncidentStatusOpen() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("failingProcessWithUserTask", parameters);
        this.executeAvailableJobs();
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentStatus("open").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldDeleteIncidentAfterJobWasSuccessfully.bpmn"})
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcessInstanceQueryIncidentStatusResolved() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        ProcessInstance pi1 = this.runtimeService.startProcessInstanceByKey("failingProcessWithUserTask", parameters);
        this.executeAvailableJobs();
        this.runtimeService.setVariable(pi1.getId(), "fail", (Object)false);
        Job jobToResolve = (Job)this.managementService.createJobQuery().processInstanceId(pi1.getId()).singleResult();
        this.managementService.setJobRetries(jobToResolve.getId(), 1);
        this.executeAvailableJobs();
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentStatus("resolved").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldDeleteIncidentAfterJobWasSuccessfully.bpmn"})
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcessInstanceQueryIncidentStatusOpenWithTwoProcesses() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        ProcessInstance pi1 = this.runtimeService.startProcessInstanceByKey("failingProcessWithUserTask", parameters);
        this.runtimeService.startProcessInstanceByKey("failingProcessWithUserTask", parameters);
        this.executeAvailableJobs();
        HistoricProcessInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentStatus("open").count());
        this.runtimeService.setVariable(pi1.getId(), "fail", (Object)false);
        Job jobToResolve = (Job)this.managementService.createJobQuery().processInstanceId(pi1.getId()).singleResult();
        this.managementService.setJobRetries(jobToResolve.getId(), 1);
        this.executeAvailableJobs();
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentStatus("open").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentStatus("resolved").count());
    }

    public void testHistoricProcessInstanceQueryWithIncidentMessageNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().incidentMessage(null).count();
            HistoricProcessInstanceTest.fail((String)"incidentMessage with null value is not allowed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testHistoricProcessInstanceQueryWithIncidentMessageLikeNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike(null).count();
            HistoricProcessInstanceTest.fail((String)"incidentMessageLike with null value is not allowed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneAsyncTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceQuery() {
        Calendar startTime = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)startTime.getTime());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "businessKey_123");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        Calendar hourAgo = Calendar.getInstance();
        hourAgo.add(11, -1);
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.add(11, 1);
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedBefore(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedBefore(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startedBefore(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startedBefore(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startedAfter(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startedAfter(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startedAfter(hourFromNow.getTime()).startedBefore(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionId(processInstance.getProcessDefinitionId()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey("businessKey_123").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKeyLike("business%").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKeyLike("%sinessKey\\_123").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKeyLike("%siness%").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionName("The One Task_Process").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionNameLike("The One Task%").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionNameLike("%One Task\\_Process").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionNameLike("%One Task%").count());
        ArrayList<String> exludeIds = new ArrayList<String>();
        exludeIds.add("unexistingProcessDefinition");
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKeyNotIn(exludeIds).count());
        exludeIds.add("oneTaskProcess");
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("oneTaskProcess").processDefinitionKeyNotIn(exludeIds).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKeyNotIn(exludeIds).count());
        try {
            this.historyService.createHistoricProcessInstanceQuery().processDefinitionKeyNotIn(Arrays.asList(""));
            HistoricProcessInstanceTest.fail((String)"Exception expected");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult()).getId());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedBefore(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedBefore(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourFromNow.getTime()).finishedBefore(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().withIncidents().count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike("Unknown property used%").count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown property used in expression: #{failing}. Cause: Cannot resolve identifier 'failing'").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().executedActivityBefore(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().executedActivityBefore(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(hourFromNow.getTime()).count());
        if (this.processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
            HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().executedJobAfter(hourAgo.getTime()).count());
            HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().executedActivityBefore(hourAgo.getTime()).count());
            HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().executedActivityBefore(hourFromNow.getTime()).count());
            HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(hourFromNow.getTime()).count());
        }
    }

    public void testHistoricProcessInstanceSorting() {
        this.deployment(new String[]{"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"});
        this.deployment(new String[]{"org/camunda/bpm/engine/test/history/HistoricActivityInstanceTest.testSorting.bpmn20.xml"});
        this.deployment(new String[]{"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"});
        List processDefinitions = this.processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").list();
        for (ProcessDefinition processDefinition : processDefinitions) {
            this.runtimeService.startProcessInstanceById(processDefinition.getId());
        }
        this.runtimeService.startProcessInstanceByKey("process");
        List processInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().asc()).list();
        HistoricProcessInstanceTest.assertEquals((int)3, (int)processInstances.size());
        TestOrderingUtil.verifySorting(processInstances, TestOrderingUtil.historicProcessInstanceByProcessInstanceId());
        HistoricProcessInstanceTest.assertEquals((int)3, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().asc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)3, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceEndTime().asc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)3, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceDuration().asc()).list().size());
        processInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionId().asc()).list();
        HistoricProcessInstanceTest.assertEquals((int)3, (int)processInstances.size());
        TestOrderingUtil.verifySorting(processInstances, TestOrderingUtil.historicProcessInstanceByProcessDefinitionId());
        processInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionKey().asc()).list();
        HistoricProcessInstanceTest.assertEquals((int)3, (int)processInstances.size());
        TestOrderingUtil.verifySorting(processInstances, TestOrderingUtil.historicProcessInstanceByProcessDefinitionKey());
        processInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionName().asc()).list();
        HistoricProcessInstanceTest.assertEquals((int)3, (int)processInstances.size());
        TestOrderingUtil.verifySorting(processInstances, TestOrderingUtil.historicProcessInstanceByProcessDefinitionName());
        processInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionVersion().asc()).list();
        HistoricProcessInstanceTest.assertEquals((int)3, (int)processInstances.size());
        TestOrderingUtil.verifySorting(processInstances, TestOrderingUtil.historicProcessInstanceByProcessDefinitionVersion());
        HistoricProcessInstanceTest.assertEquals((int)3, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceBusinessKey().asc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)3, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)3, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)3, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceEndTime().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)3, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceDuration().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)3, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionId().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)3, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceBusinessKey().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceEndTime().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceDuration().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionId().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceBusinessKey().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().desc()).count());
        HistoricProcessInstanceTest.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().desc()).count());
        HistoricProcessInstanceTest.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceEndTime().desc()).count());
        HistoricProcessInstanceTest.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceDuration().desc()).count());
        HistoricProcessInstanceTest.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionId().desc()).count());
        HistoricProcessInstanceTest.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceBusinessKey().desc()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceSubProcess() {
        ProcessInstance superPi = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest");
        ProcessInstance subPi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(superPi.getProcessInstanceId()).singleResult();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().subProcessInstanceId(subPi.getProcessInstanceId()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        HistoricProcessInstanceTest.assertEquals((String)historicProcessInstance.getId(), (String)superPi.getId());
    }

    public void testInvalidSorting() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().asc();
            HistoricProcessInstanceTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricProcessInstanceQuery().desc();
            HistoricProcessInstanceTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().list();
            HistoricProcessInstanceTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testDeleteReason() {
        if (!"none".equals(this.processEngineConfiguration.getHistory())) {
            String deleteReason = "some delete reason";
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            this.runtimeService.deleteProcessInstance(pi.getId(), "some delete reason");
            HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(pi.getId()).singleResult();
            HistoricProcessInstanceTest.assertEquals((String)"some delete reason", (String)hpi.getDeleteReason());
        }
    }

    @Deployment
    public void testLongProcessDefinitionKey() {
        String PROCESS_DEFINITION_KEY = "myrealrealrealrealrealrealrealrealrealrealreallongprocessdefinitionkeyawesome";
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("myrealrealrealrealrealrealrealrealrealrealreallongprocessdefinitionkeyawesome").singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)hpi);
        this.assertProcessEnded(hpi.getId());
        HistoricProcessInstance hpi2 = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("myrealrealrealrealrealrealrealrealrealrealreallongprocessdefinitionkeyawesome").singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)hpi2);
        this.assertProcessEnded(hpi2.getId());
        HistoricProcessInstanceTest.assertEquals((String)hpi.getId(), (String)hpi2.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testQueryByCaseInstanceId.cmmn", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testQueryByCaseInstanceId.bpmn20.xml"})
    public void testQueryByCaseInstanceId() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.caseInstanceId(caseInstanceId);
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertEquals((String)caseInstanceId, (String)historicProcessInstance.getCaseInstanceId());
        String taskId = ((Task)this.taskService.createTaskQuery().caseInstanceId(caseInstanceId).singleResult()).getId();
        this.taskService.complete(taskId);
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)query.list().size());
        historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertEquals((String)caseInstanceId, (String)historicProcessInstance.getCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testQueryByCaseInstanceId.cmmn", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testQueryByCaseInstanceIdHierarchy-super.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testQueryByCaseInstanceIdHierarchy-sub.bpmn20.xml"})
    public void testQueryByCaseInstanceIdHierarchy() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.caseInstanceId(caseInstanceId);
        HistoricProcessInstanceTest.assertEquals((long)2L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)2, (int)query.list().size());
        for (HistoricProcessInstance hpi : query.list()) {
            HistoricProcessInstanceTest.assertEquals((String)caseInstanceId, (String)hpi.getCaseInstanceId());
        }
        String taskId = ((Task)this.taskService.createTaskQuery().caseInstanceId(caseInstanceId).singleResult()).getId();
        this.taskService.complete(taskId);
        HistoricProcessInstanceTest.assertEquals((long)2L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)2, (int)query.list().size());
        for (HistoricProcessInstance hpi : query.list()) {
            HistoricProcessInstanceTest.assertEquals((String)caseInstanceId, (String)hpi.getCaseInstanceId());
        }
    }

    public void testQueryByInvalidCaseInstanceId() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.caseInstanceId("invalid");
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)0, (int)query.list().size());
        query.caseInstanceId(null);
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)0, (int)query.list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testBusinessKey.cmmn", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testBusinessKey.bpmn20.xml"})
    public void testBusinessKey() {
        String businessKey = "aBusinessKey";
        this.caseService.withCaseDefinitionByKey("case").businessKey(businessKey).create().getId();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.processInstanceBusinessKey(businessKey);
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        HistoricProcessInstanceTest.assertEquals((String)businessKey, (String)historicProcessInstance.getBusinessKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testStartActivityId-super.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testStartActivityId-sub.bpmn20.xml"})
    public void testStartActivityId() {
        this.runtimeService.startProcessInstanceByKey("super");
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("sub").singleResult();
        HistoricProcessInstanceTest.assertEquals((String)"theSubStart", (String)hpi.getStartActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testStartActivityId-super.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testAsyncStartActivityId-sub.bpmn20.xml"})
    public void testAsyncStartActivityId() {
        this.runtimeService.startProcessInstanceByKey("super");
        this.executeAvailableJobs();
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("sub").singleResult();
        HistoricProcessInstanceTest.assertEquals((String)"theSubStart", (String)hpi.getStartActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStartByKeyWithCaseInstanceId() {
        String caseInstanceId = "aCaseInstanceId";
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", null, caseInstanceId).getId();
        HistoricProcessInstance firstInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)firstInstance);
        HistoricProcessInstanceTest.assertEquals((String)caseInstanceId, (String)firstInstance.getCaseInstanceId());
        processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", null, caseInstanceId, null).getId();
        HistoricProcessInstance secondInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)secondInstance);
        HistoricProcessInstanceTest.assertEquals((String)caseInstanceId, (String)secondInstance.getCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStartByIdWithCaseInstanceId() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").singleResult()).getId();
        String caseInstanceId = "aCaseInstanceId";
        String processInstanceId = this.runtimeService.startProcessInstanceById(processDefinitionId, null, caseInstanceId).getId();
        HistoricProcessInstance firstInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)firstInstance);
        HistoricProcessInstanceTest.assertEquals((String)caseInstanceId, (String)firstInstance.getCaseInstanceId());
        processInstanceId = this.runtimeService.startProcessInstanceById(processDefinitionId, null, caseInstanceId, null).getId();
        HistoricProcessInstance secondInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)secondInstance);
        HistoricProcessInstanceTest.assertEquals((String)caseInstanceId, (String)secondInstance.getCaseInstanceId());
    }

    @Deployment
    public void testEndTimeAndEndActivity() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask2").singleResult()).getId();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.taskService.complete(taskId);
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getEndActivityId());
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getEndTime());
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getEndActivityId());
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getEndTime());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testRootRemovalTime() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(processInstance.getProcessDefinitionId(), Integer.valueOf(3));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.complete(userTask.getId());
        HistoricProcessInstance rootHistoricProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)rootHistoricProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertNotNull((Object)rootHistoricProcessInstance.getRemovalTime());
        HistoricProcessInstanceTest.assertTrue((boolean)rootHistoricProcessInstance.getRemovalTime().after(rootHistoricProcessInstance.getEndTime()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/nestedSubProcessHierarchy.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/nestedSubProcessAsync.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testRootRemovalTimeWithMultilevelHierarchicalHPIAsync() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedHierarchicalProcess");
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(processInstance.getProcessDefinitionId(), Integer.valueOf(3));
        HistoricProcessInstance middleChildHistoricProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).singleResult();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(middleChildHistoricProcessInstance.getId()).singleResult();
        this.managementService.executeJob(job.getId());
        HistoricProcessInstance lastChildHistoricProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(middleChildHistoricProcessInstance.getId()).singleResult();
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(lastChildHistoricProcessInstance.getId()).singleResult();
        this.taskService.complete(userTask.getId());
        HistoricProcessInstance rootHistoricProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        middleChildHistoricProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(middleChildHistoricProcessInstance.getId()).singleResult();
        lastChildHistoricProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(middleChildHistoricProcessInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)rootHistoricProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertNotNull((Object)rootHistoricProcessInstance.getRemovalTime());
        HistoricProcessInstanceTest.assertTrue((boolean)rootHistoricProcessInstance.getRemovalTime().after(rootHistoricProcessInstance.getEndTime()));
        HistoricProcessInstanceTest.assertNotNull((Object)middleChildHistoricProcessInstance.getRemovalTime());
        HistoricProcessInstanceTest.assertEquals((Object)rootHistoricProcessInstance.getRemovalTime(), (Object)middleChildHistoricProcessInstance.getRemovalTime());
        HistoricProcessInstanceTest.assertNotNull((Object)lastChildHistoricProcessInstance.getRemovalTime());
        HistoricProcessInstanceTest.assertEquals((Object)rootHistoricProcessInstance.getRemovalTime(), (Object)lastChildHistoricProcessInstance.getRemovalTime());
    }

    public void testRootRemovalTimeWithMultilevelHierarchicalHPI() {
        BpmnModelInstance parentProcessInstance = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((CallActivityBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"nestedHierarchicalProcess").camundaHistoryTimeToLive(Integer.valueOf(3))).startEvent().callActivity("callActivity").calledElement("middleChildProcess")).multiInstance().parallel()).cardinality("3")).multiInstanceDone().endEvent().done();
        BpmnModelInstance middleSubprocessInstances = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"middleChildProcess").startEvent().callActivity().calledElement("lastChildProcess")).multiInstance().sequential()).cardinality("3")).multiInstanceDone().endEvent("subMiddleEnd").done();
        BpmnModelInstance lastSubprocessInstances = Bpmn.createExecutableProcess((String)"lastChildProcess").startEvent().endEvent("subLastEnd").done();
        this.deployment(new BpmnModelInstance[]{parentProcessInstance, middleSubprocessInstances, lastSubprocessInstances});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedHierarchicalProcess");
        HistoricProcessInstance rootHistoricProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        List middleChildHistoricProcessInstances = this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).list();
        HistoricProcessInstanceTest.assertNotNull((Object)rootHistoricProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertNotNull((Object)rootHistoricProcessInstance.getRemovalTime());
        HistoricProcessInstanceTest.assertTrue((boolean)rootHistoricProcessInstance.getRemovalTime().after(rootHistoricProcessInstance.getEndTime()));
        for (HistoricProcessInstance middleChildHistoricProcessInstance : middleChildHistoricProcessInstances) {
            HistoricProcessInstanceTest.assertNotNull((Object)middleChildHistoricProcessInstance.getRemovalTime());
            HistoricProcessInstanceTest.assertEquals((Object)rootHistoricProcessInstance.getRemovalTime(), (Object)middleChildHistoricProcessInstance.getRemovalTime());
            List lastChildHistoricProcessInstances = this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(middleChildHistoricProcessInstance.getId()).list();
            for (HistoricProcessInstance lastChildHistoricProcessInstance : lastChildHistoricProcessInstances) {
                HistoricProcessInstanceTest.assertNotNull((Object)lastChildHistoricProcessInstance.getRemovalTime());
                HistoricProcessInstanceTest.assertEquals((Object)rootHistoricProcessInstance.getRemovalTime(), (Object)lastChildHistoricProcessInstance.getRemovalTime());
            }
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryBySuperCaseInstanceId() {
        String superCaseInstanceId = this.caseService.createCaseInstanceByKey("oneProcessTaskCase").getId();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().superCaseInstanceId(superCaseInstanceId);
        HistoricProcessInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricProcessInstance subProcessInstance = (HistoricProcessInstance)query.singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)subProcessInstance);
        HistoricProcessInstanceTest.assertEquals((String)superCaseInstanceId, (String)subProcessInstance.getSuperCaseInstanceId());
        HistoricProcessInstanceTest.assertNull((Object)subProcessInstance.getSuperProcessInstanceId());
    }

    public void testQueryByInvalidSuperCaseInstanceId() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.superCaseInstanceId("invalid");
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)0, (int)query.list().size());
        query.caseInstanceId(null);
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)0, (int)query.list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithCaseCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySubCaseInstanceId() {
        String superProcessInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest").getId();
        String subCaseInstanceId = ((CaseInstance)this.caseService.createCaseInstanceQuery().superProcessInstanceId(superProcessInstanceId).singleResult()).getId();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().subCaseInstanceId(subCaseInstanceId);
        HistoricProcessInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricProcessInstance superProcessInstance = (HistoricProcessInstance)query.singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)superProcessInstance);
        HistoricProcessInstanceTest.assertEquals((String)superProcessInstanceId, (String)superProcessInstance.getId());
        HistoricProcessInstanceTest.assertNull((Object)superProcessInstance.getSuperCaseInstanceId());
        HistoricProcessInstanceTest.assertNull((Object)superProcessInstance.getSuperProcessInstanceId());
    }

    public void testQueryByInvalidSubCaseInstanceId() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.subCaseInstanceId("invalid");
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)0, (int)query.list().size());
        query.caseInstanceId(null);
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)0, (int)query.list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/nestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testRootProcessInstanceIdPropertySingleTransaction() {
        String rootProcessInstanceId = this.runtimeService.startProcessInstanceByKey("nestedSimpleSubProcess").getId();
        HistoricProcessInstance historicParentProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(rootProcessInstanceId).singleResult();
        HistoricProcessInstance historicChildProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(rootProcessInstanceId).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicParentProcessInstance.getRootProcessInstanceId());
        HistoricProcessInstanceTest.assertEquals((String)rootProcessInstanceId, (String)historicParentProcessInstance.getRootProcessInstanceId());
        HistoricProcessInstanceTest.assertNotNull((Object)historicChildProcessInstance.getRootProcessInstanceId());
        HistoricProcessInstanceTest.assertEquals((String)rootProcessInstanceId, (String)historicChildProcessInstance.getRootProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/nestedSubProcessAsync.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testRootProcessInstanceIdPropertyAsyncBefore() {
        String rootProcessInstanceId = this.runtimeService.startProcessInstanceByKey("nestedSimpleSubProcess").getId();
        Job childPIJob = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(childPIJob.getId());
        HistoricProcessInstance historicParentProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(rootProcessInstanceId).singleResult();
        HistoricProcessInstance historicChildProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(rootProcessInstanceId).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicParentProcessInstance.getRootProcessInstanceId());
        HistoricProcessInstanceTest.assertEquals((String)rootProcessInstanceId, (String)historicParentProcessInstance.getRootProcessInstanceId());
        HistoricProcessInstanceTest.assertNotNull((Object)historicChildProcessInstance.getRootProcessInstanceId());
        HistoricProcessInstanceTest.assertEquals((String)rootProcessInstanceId, (String)historicChildProcessInstance.getRootProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/nestedSubProcessHierarchy.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/nestedSubProcessAsync.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testRootProcessInstanceIdPropertyMultilevelHierarchy() {
        String rootProcessInstanceId = this.runtimeService.startProcessInstanceByKey("nestedHierarchicalProcess").getId();
        Job childPIJob = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(childPIJob.getId());
        HistoricProcessInstance historicParentProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(rootProcessInstanceId).singleResult();
        HistoricProcessInstance historicMiddleChildProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(rootProcessInstanceId).singleResult();
        HistoricProcessInstance historicLastChildProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(rootProcessInstanceId).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicParentProcessInstance.getRootProcessInstanceId());
        HistoricProcessInstanceTest.assertEquals((String)rootProcessInstanceId, (String)historicParentProcessInstance.getRootProcessInstanceId());
        HistoricProcessInstanceTest.assertNotNull((Object)historicMiddleChildProcessInstance.getRootProcessInstanceId());
        HistoricProcessInstanceTest.assertEquals((String)rootProcessInstanceId, (String)historicMiddleChildProcessInstance.getRootProcessInstanceId());
        HistoricProcessInstanceTest.assertNotNull((Object)historicLastChildProcessInstance.getRootProcessInstanceId());
        HistoricProcessInstanceTest.assertEquals((String)rootProcessInstanceId, (String)historicLastChildProcessInstance.getRootProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/VariableInstanceQueryTest.testParallelMultiInstanceSubProcess.bpmn20.xml"})
    public void testRootProcessInstanceIdPropertyMultiInstance() {
        String rootProcessInstanceId = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess").getId();
        HistoricProcessInstance historicParentProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(rootProcessInstanceId).singleResult();
        List historicChildProcessInstances = this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(rootProcessInstanceId).list();
        HistoricProcessInstanceTest.assertNotNull((Object)historicParentProcessInstance.getRootProcessInstanceId());
        HistoricProcessInstanceTest.assertEquals((String)rootProcessInstanceId, (String)historicParentProcessInstance.getRootProcessInstanceId());
        for (HistoricProcessInstance historicChildProcessInstance : historicChildProcessInstances) {
            HistoricProcessInstanceTest.assertNotNull((Object)historicChildProcessInstance.getRootProcessInstanceId());
            HistoricProcessInstanceTest.assertEquals((String)rootProcessInstanceId, (String)historicChildProcessInstance.getRootProcessInstanceId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testSuperCaseInstanceIdProperty() {
        String superCaseInstanceId = this.caseService.createCaseInstanceByKey("oneProcessTaskCase").getId();
        ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult()).getId();
        HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)instance);
        HistoricProcessInstanceTest.assertEquals((String)superCaseInstanceId, (String)instance.getSuperCaseInstanceId());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)instance);
        HistoricProcessInstanceTest.assertEquals((String)superCaseInstanceId, (String)instance.getSuperCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessDefinitionKeyProperty() {
        String key = "oneTaskProcess";
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(key).getId();
        HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)instance.getProcessDefinitionKey());
        HistoricProcessInstanceTest.assertEquals((String)key, (String)instance.getProcessDefinitionKey());
    }

    @Deployment
    public void testProcessInstanceShouldBeActive() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getDurationInMillis());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testRetrieveProcessDefinitionName() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HistoricProcessInstanceTest.assertEquals((String)"The One Task Process", (String)historicProcessInstance.getProcessDefinitionName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testRetrieveProcessDefinitionVersion() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HistoricProcessInstanceTest.assertEquals((int)1, (int)historicProcessInstance.getProcessDefinitionVersion());
    }

    @Test
    public void testHistoricProcInstExecutedActivityInInterval() {
        Calendar now = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)now.getTime());
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().userTask().endEvent().done();
        this.deployment(new BpmnModelInstance[]{model});
        Calendar hourFromNow = (Calendar)now.clone();
        hourFromNow.add(11, 1);
        this.runtimeService.startProcessInstanceByKey("proc");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(now.getTime()).executedActivityBefore(hourFromNow.getTime()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        Calendar sixHoursFromNow = (Calendar)now.clone();
        sixHoursFromNow.add(11, 6);
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(hourFromNow.getTime()).executedActivityBefore(sixHoursFromNow.getTime()).singleResult();
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance);
    }

    @Test
    public void testHistoricProcInstExecutedActivityAfter() {
        Calendar now = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)now.getTime());
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().endEvent().done();
        this.deployment(new BpmnModelInstance[]{model});
        Calendar hourFromNow = (Calendar)now.clone();
        hourFromNow.add(11, 1);
        this.runtimeService.startProcessInstanceByKey("proc");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(now.getTime()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(hourFromNow.getTime()).singleResult();
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance);
    }

    @Test
    public void testHistoricProcInstExecutedActivityBefore() {
        Calendar now = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)now.getTime());
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().endEvent().done();
        this.deployment(new BpmnModelInstance[]{model});
        Calendar hourBeforeNow = (Calendar)now.clone();
        hourBeforeNow.add(10, -1);
        this.runtimeService.startProcessInstanceByKey("proc");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedActivityBefore(now.getTime()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedActivityBefore(hourBeforeNow.getTime()).singleResult();
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance);
    }

    @Test
    public void testHistoricProcInstExecutedActivityWithTwoProcInsts() {
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().endEvent().done();
        this.deployment(new BpmnModelInstance[]{model});
        Calendar now = Calendar.getInstance();
        Calendar hourBeforeNow = (Calendar)now.clone();
        hourBeforeNow.add(10, -1);
        ClockUtil.setCurrentTime((Date)hourBeforeNow.getTime());
        this.runtimeService.startProcessInstanceByKey("proc");
        ClockUtil.setCurrentTime((Date)now.getTime());
        this.runtimeService.startProcessInstanceByKey("proc");
        List list = this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(hourBeforeNow.getTime()).executedActivityBefore(now.getTime()).list();
        HistoricProcessInstanceTest.assertEquals((int)2, (int)list.size());
        Calendar halfHour = (Calendar)now.clone();
        halfHour.add(12, -30);
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(halfHour.getTime()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
    }

    @Test
    public void testHistoricProcInstExecutedActivityWithEmptyInterval() {
        Calendar now = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)now.getTime());
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().endEvent().done();
        this.deployment(new BpmnModelInstance[]{model});
        Calendar hourBeforeNow = (Calendar)now.clone();
        hourBeforeNow.add(10, -1);
        this.runtimeService.startProcessInstanceByKey("proc");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedActivityBefore(hourBeforeNow.getTime()).executedActivityAfter(hourBeforeNow.getTime()).singleResult();
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcInstExecutedJobAfter() {
        BpmnModelInstance asyncModel = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"async").startEvent().camundaAsyncBefore()).endEvent().done();
        this.deployment(new BpmnModelInstance[]{asyncModel});
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().endEvent().done();
        this.deployment(new BpmnModelInstance[]{model});
        Calendar now = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)now.getTime());
        Calendar hourFromNow = (Calendar)now.clone();
        hourFromNow.add(11, 1);
        this.runtimeService.startProcessInstanceByKey("async");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        this.runtimeService.startProcessInstanceByKey("proc");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedJobAfter(now.getTime()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedJobAfter(hourFromNow.getTime()).singleResult();
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcInstExecutedJobBefore() {
        BpmnModelInstance asyncModel = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"async").startEvent().camundaAsyncBefore()).endEvent().done();
        this.deployment(new BpmnModelInstance[]{asyncModel});
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().endEvent().done();
        this.deployment(new BpmnModelInstance[]{model});
        Calendar now = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)now.getTime());
        Calendar hourBeforeNow = (Calendar)now.clone();
        hourBeforeNow.add(11, -1);
        this.runtimeService.startProcessInstanceByKey("async");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        this.runtimeService.startProcessInstanceByKey("proc");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedJobBefore(now.getTime()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedJobBefore(hourBeforeNow.getTime()).singleResult();
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcInstExecutedJobWithTwoProcInsts() {
        BpmnModelInstance asyncModel = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"async").startEvent().camundaAsyncBefore()).endEvent().done();
        this.deployment(new BpmnModelInstance[]{asyncModel});
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().endEvent().done();
        this.deployment(new BpmnModelInstance[]{model});
        Calendar now = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)now.getTime());
        Calendar hourBeforeNow = (Calendar)now.clone();
        hourBeforeNow.add(11, -1);
        ClockUtil.setCurrentTime((Date)hourBeforeNow.getTime());
        this.runtimeService.startProcessInstanceByKey("async");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        ClockUtil.setCurrentTime((Date)now.getTime());
        this.runtimeService.startProcessInstanceByKey("async");
        this.runtimeService.startProcessInstanceByKey("proc");
        List list = this.historyService.createHistoricProcessInstanceQuery().executedJobAfter(hourBeforeNow.getTime()).executedJobBefore(now.getTime()).list();
        HistoricProcessInstanceTest.assertEquals((int)2, (int)list.size());
        Calendar halfHour = (Calendar)now.clone();
        halfHour.add(12, -30);
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedJobAfter(halfHour.getTime()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcInstExecutedJobWithEmptyInterval() {
        BpmnModelInstance asyncModel = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"async").startEvent().camundaAsyncBefore()).endEvent().done();
        this.deployment(new BpmnModelInstance[]{asyncModel});
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().endEvent().done();
        this.deployment(new BpmnModelInstance[]{model});
        Calendar now = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)now.getTime());
        Calendar hourBeforeNow = (Calendar)now.clone();
        hourBeforeNow.add(11, -1);
        this.runtimeService.startProcessInstanceByKey("async");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        this.runtimeService.startProcessInstanceByKey("proc");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedJobBefore(hourBeforeNow.getTime()).executedJobAfter(hourBeforeNow.getTime()).singleResult();
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcInstQueryWithExecutedActivityIds() {
        this.deployment(new BpmnModelInstance[]{ProcessModels.TWO_TASKS_PROCESS});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Task task = (Task)this.taskService.createTaskQuery().active().singleResult();
        this.taskService.complete(task.getId());
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).activityId("userTask1").singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicActivityInstance);
        List result = this.historyService.createHistoricProcessInstanceQuery().executedActivityIdIn(new String[]{historicActivityInstance.getActivityId()}).list();
        HistoricProcessInstanceTest.assertNotNull((Object)result);
        HistoricProcessInstanceTest.assertEquals((int)1, (int)result.size());
        HistoricProcessInstanceTest.assertEquals((String)((HistoricProcessInstance)result.get(0)).getId(), (String)processInstance.getId());
    }

    @Test
    public void testHistoricProcInstQueryWithExecutedActivityIdsNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().executedActivityIdIn(null).list();
            HistoricProcessInstanceTest.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"activity ids is null"));
        }
    }

    @Test
    public void testHistoricProcInstQueryWithExecutedActivityIdsContainNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().executedActivityIdIn(new String[]{null, "1"}).list();
            HistoricProcessInstanceTest.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"activity ids contains null"));
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcInstQueryWithActiveActivityIds() {
        this.deployment(new BpmnModelInstance[]{ProcessModels.TWO_TASKS_PROCESS});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("userTask1").singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicActivityInstance);
        List result = this.historyService.createHistoricProcessInstanceQuery().activeActivityIdIn(new String[]{historicActivityInstance.getActivityId()}).list();
        HistoricProcessInstanceTest.assertNotNull((Object)result);
        HistoricProcessInstanceTest.assertEquals((int)1, (int)result.size());
        HistoricProcessInstanceTest.assertEquals((String)((HistoricProcessInstance)result.get(0)).getId(), (String)processInstance.getId());
    }

    @Test
    public void testHistoricProcInstQueryWithActiveActivityIdsNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().activeActivityIdIn(null).list();
            HistoricProcessInstanceTest.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"activity ids is null"));
        }
    }

    @Test
    public void testHistoricProcInstQueryWithActiveActivityIdsContainNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().activeActivityIdIn(new String[]{null, "1"}).list();
            HistoricProcessInstanceTest.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"activity ids contains null"));
        }
    }

    @Test
    public void testQueryByActiveActivityIdInAndProcessDefinitionKey() {
        this.deployment(new BpmnModelInstance[]{ProcessModels.ONE_TASK_PROCESS});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("Process").activeActivityIdIn(new String[]{"userTask"}).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        HistoricProcessInstanceTest.assertEquals((String)processInstance.getId(), (String)historicProcessInstance.getId());
    }

    @Test
    public void testQueryByExecutedActivityIdInAndProcessDefinitionKey() {
        this.deployment(new BpmnModelInstance[]{ProcessModels.ONE_TASK_PROCESS});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("Process").executedActivityIdIn(new String[]{"userTask"}).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        HistoricProcessInstanceTest.assertEquals((String)processInstance.getId(), (String)historicProcessInstance.getId());
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testQueryWithRootIncidents() {
        this.deployment(new String[]{"org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testQueryWithRootIncidents.bpmn20.xml"});
        this.deployment(new BpmnModelInstance[]{CallActivityModels.oneBpmnCallActivityProcess("Process_1")});
        this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance calledProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("Process_1").singleResult();
        this.executeAvailableJobs();
        List historicProcInstances = this.historyService.createHistoricProcessInstanceQuery().withRootIncidents().list();
        HistoricProcessInstanceTest.assertNotNull((Object)calledProcessInstance);
        HistoricProcessInstanceTest.assertEquals((int)1, (int)historicProcInstances.size());
        HistoricProcessInstanceTest.assertEquals((String)calledProcessInstance.getId(), (String)((HistoricProcessInstance)historicProcInstances.get(0)).getId());
    }
}

