/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.camunda.bpm.engine.test.standalone.history;

import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEventType;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;

public class CustomHistoryLevelFullWithoutUserOperationLog implements HistoryLevel {

  public int getId() {
    return 90;
  }

  public String getName() {
    return "aCustomHistoryLevelWUOL";
  }

  public boolean isHistoryEventProduced(HistoryEventType eventType, Object entity) {
    if (eventType.equals(HistoryEventTypes.USER_OPERATION_LOG)){
      return false;
    }
    return true;
  }
}
