/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.engine.test.dmn.businessruletask.TestPojo;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoryCleanupAuthorizationTest
extends AuthorizationTest {
    @Override
    public void tearDown() {
        super.tearDown();
        this.clearDatabase();
        this.clearMetrics();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupWithAuthorization() {
        this.prepareInstances(5, 5, 5);
        ClockUtil.setCurrentTime((Date)new Date());
        this.identityService.setAuthentication("user", Collections.singletonList("camunda-admin"), null);
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.managementService.executeJob(jobId);
        this.assertResult(0L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupWithoutAuthorization() {
        this.prepareInstances(5, 5, 5);
        ClockUtil.setCurrentTime((Date)new Date());
        try {
            this.historyService.cleanUpHistoryAsync(true).getId();
            HistoryCleanupAuthorizationTest.fail((String)"Exception expected: It should not be possible to execute the history cleanup");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 Required admin authenticated group or user.", message);
        }
    }

    protected void prepareInstances(Integer processInstanceTimeToLive, Integer decisionTimeToLive, Integer caseTimeToLive) {
        int i;
        this.disableAuthorization();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("testProcess").list();
        HistoryCleanupAuthorizationTest.assertEquals((int)1, (int)processDefinitions.size());
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(((ProcessDefinition)processDefinitions.get(0)).getId(), processInstanceTimeToLive);
        List decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey("testDecision").list();
        HistoryCleanupAuthorizationTest.assertEquals((int)1, (int)decisionDefinitions.size());
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(((DecisionDefinition)decisionDefinitions.get(0)).getId(), decisionTimeToLive);
        List caseDefinitions = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").list();
        HistoryCleanupAuthorizationTest.assertEquals((int)1, (int)caseDefinitions.size());
        this.repositoryService.updateCaseDefinitionHistoryTimeToLive(((CaseDefinition)caseDefinitions.get(0)).getId(), caseTimeToLive);
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)oldCurrentTime, (int)-6));
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        VariableMap variables = Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37));
        for (i = 0; i < 3; ++i) {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
            processInstanceIds.add(processInstance.getId());
        }
        this.runtimeService.deleteProcessInstances(processInstanceIds, null, true, true);
        for (i = 0; i < 10; ++i) {
            this.decisionService.evaluateDecisionByKey("testDecision").variables((Map)variables).evaluate();
        }
        for (i = 0; i < 4; ++i) {
            CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase", (Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37 + (double)i)));
            this.caseService.terminateCaseExecution(caseInstance.getId());
            this.caseService.closeCaseInstance(caseInstance.getId());
        }
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
        this.enableAuthorization();
    }

    protected void assertResult(long expectedInstanceCount) {
        long count = this.historyService.createHistoricProcessInstanceQuery().count() + this.historyService.createHistoricDecisionInstanceQuery().count() + this.historyService.createHistoricCaseInstanceQuery().count();
        HistoryCleanupAuthorizationTest.assertEquals((long)expectedInstanceCount, (long)count);
    }

    protected void clearDatabase() {
        String defaultStartTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowStartTime();
        String defaultEndTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowEndTime();
        int defaultBatchSize = this.processEngineConfiguration.getHistoryCleanupBatchSize();
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(defaultStartTime);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(defaultEndTime);
        this.processEngineConfiguration.setHistoryCleanupBatchSize(defaultBatchSize);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = HistoryCleanupAuthorizationTest.this.managementService.createJobQuery().list();
                if (jobs.size() > 0) {
                    TestCase.assertEquals((int)1, (int)jobs.size());
                    String jobId = ((Job)jobs.get(0)).getId();
                    commandContext.getJobManager().deleteJob((JobEntity)jobs.get(0));
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                }
                List historicIncidents = HistoryCleanupAuthorizationTest.this.historyService.createHistoricIncidentQuery().list();
                for (HistoricIncident historicIncident : historicIncidents) {
                    commandContext.getDbEntityManager().delete((DbEntity)((HistoricIncidentEntity)historicIncident));
                }
                commandContext.getMeterLogManager().deleteAll();
                return null;
            }
        });
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (Object historicProcessInstance : historicProcessInstances) {
            this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
        }
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        for (HistoricDecisionInstance historicDecisionInstance : historicDecisionInstances) {
            this.historyService.deleteHistoricDecisionInstanceByInstanceId(historicDecisionInstance.getId());
        }
        List historicCaseInstances = this.historyService.createHistoricCaseInstanceQuery().list();
        for (HistoricCaseInstance historicCaseInstance : historicCaseInstances) {
            this.historyService.deleteHistoricCaseInstance(historicCaseInstance.getId());
        }
    }

    protected void clearMetrics() {
        Collection meters = this.processEngineConfiguration.getMetricsRegistry().getMeters().values();
        for (Meter meter : meters) {
            meter.getAndClear();
        }
        this.managementService.deleteMetrics(null);
    }
}

