/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.history.CleanableHistoricProcessInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.history.DefaultHistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.history.HistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.resources.GetByteArrayCommand;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoryCleanupRemovalTimeTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected FormService formService;
    protected HistoryService historyService;
    protected TaskService taskService;
    protected ManagementService managementService;
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected ExternalTaskService externalTaskService;
    protected DecisionService decisionService;
    protected static ProcessEngineConfigurationImpl engineConfiguration;
    protected Set<String> jobIds;
    protected final String PROCESS_KEY = "process";
    protected final BpmnModelInstance PROCESS = ((UserTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().userTask("userTask").name("userTask")).endEvent().done();
    protected final BpmnModelInstance CALLED_PROCESS_INCIDENT = ((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().scriptTask().camundaAsyncBefore()).scriptFormat("groovy")).scriptText("if(execution.getIncidents().size() == 0) throw new RuntimeException(\"I'm supposed to fail!\")")).userTask("userTask").endEvent().done();
    protected final String CALLING_PROCESS_KEY = "callingProcess";
    protected final BpmnModelInstance CALLING_PROCESS = ((CallActivityBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().callActivity().calledElement("process")).endEvent().done();
    protected final String CALLING_PROCESS_CALLS_DMN_KEY = "callingProcessCallsDmn";
    protected final BpmnModelInstance CALLING_PROCESS_CALLS_DMN = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcessCallsDmn").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().businessRuleTask().camundaAsyncAfter()).camundaDecisionRef("dish-decision")).endEvent().done();
    protected final Date END_DATE = new Date(1363608000000L);

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.formService = this.engineRule.getFormService();
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
        this.managementService = this.engineRule.getManagementService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
        this.decisionService = this.engineRule.getDecisionService();
        engineConfiguration = this.engineRule.getProcessEngineConfiguration();
        engineConfiguration.setHistoryRemovalTimeStrategy("process-end").setHistoryRemovalTimeProvider((HistoryRemovalTimeProvider)new DefaultHistoryRemovalTimeProvider()).initHistoryRemovalTime();
        engineConfiguration.setHistoryCleanupByRemovalTime(true);
        engineConfiguration.setHistoryCleanupBatchSize(500);
        engineConfiguration.setHistoryCleanupBatchWindowStartTime(null);
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(1);
        engineConfiguration.initHistoryCleanup();
        this.jobIds = new HashSet<String>();
    }

    @After
    public void tearDown() {
        this.clearMeterLog();
        for (String jobId : this.jobIds) {
            this.clearJobLog(jobId);
            this.clearJob(jobId);
        }
    }

    @AfterClass
    public static void tearDownAfterAll() {
        if (engineConfiguration != null) {
            engineConfiguration.setHistoryRemovalTimeProvider(null).setHistoryRemovalTimeStrategy(null).initHistoryRemovalTime();
            engineConfiguration.setHistoryCleanupByRemovalTime(false);
            engineConfiguration.setHistoryCleanupBatchSize(500);
            engineConfiguration.setHistoryCleanupBatchWindowStartTime(null);
            engineConfiguration.setHistoryCleanupDegreeOfParallelism(1);
            engineConfiguration.initHistoryCleanup();
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldCleanupDecisionInstance() {
        this.testRule.deploy(this.CALLING_PROCESS_CALLS_DMN);
        this.runtimeService.startProcessInstanceByKey("callingProcessCallsDmn", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicDecisionInstances.size(), (Matcher)Is.is((Object)3));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicDecisionInstances.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldReportMetricsForDecisionInstanceCleanup() {
        this.testRule.deploy(this.CALLING_PROCESS_CALLS_DMN);
        this.runtimeService.startProcessInstanceByKey("callingProcessCallsDmn", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        long removedDecisionInstancesSum = this.managementService.createMetricsQuery().name("history-cleanup-removed-decision-instances").sum();
        MatcherAssert.assertThat((Object)removedDecisionInstancesSum, (Matcher)Is.is((Object)3L));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldCleanupDecisionInputInstance() {
        this.testRule.deploy(this.CALLING_PROCESS_CALLS_DMN);
        this.runtimeService.startProcessInstanceByKey("callingProcessCallsDmn", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().includeInputs().list();
        MatcherAssert.assertThat((Object)historicDecisionInstances.size(), (Matcher)Is.is((Object)3));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().includeInputs().list();
        MatcherAssert.assertThat((Object)historicDecisionInstances.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldCleanupDecisionOutputInstance() {
        this.testRule.deploy(this.CALLING_PROCESS_CALLS_DMN);
        this.runtimeService.startProcessInstanceByKey("callingProcessCallsDmn", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().list();
        MatcherAssert.assertThat((Object)historicDecisionInstances.size(), (Matcher)Is.is((Object)3));
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().list();
        MatcherAssert.assertThat((Object)historicDecisionInstances.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupProcessInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("process").list();
        MatcherAssert.assertThat((Object)historicProcessInstances.size(), (Matcher)Is.is((Object)1));
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("process").list();
        MatcherAssert.assertThat((Object)historicProcessInstances.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReportMetricsForProcessInstanceCleanup() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        long removedProcessInstancesSum = this.managementService.createMetricsQuery().name("history-cleanup-removed-process-instances").sum();
        MatcherAssert.assertThat((Object)removedProcessInstancesSum, (Matcher)Is.is((Object)2L));
    }

    @Test
    public void shouldCleanupActivityInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicActivityInstances.size(), (Matcher)Is.is((Object)6));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicActivityInstances.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupTaskInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        List historicTaskInstances = this.historyService.createHistoricTaskInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicTaskInstances.size(), (Matcher)Is.is((Object)1));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        historicTaskInstances = this.historyService.createHistoricTaskInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicTaskInstances.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupVariableInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.runtimeService.setVariable(processInstance.getId(), "aVariableName", (Object)Variables.stringValue((String)"anotherVariableValue"));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        List historicVariableInstances = this.historyService.createHistoricVariableInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicVariableInstances.size(), (Matcher)Is.is((Object)1));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        historicVariableInstances = this.historyService.createHistoricVariableInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicVariableInstances.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupDetail() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("aVariableName", (Object)Variables.stringValue((String)"aVariableValue")));
        this.runtimeService.setVariable(processInstance.getId(), "aVariableName", (Object)Variables.stringValue((String)"anotherVariableValue"));
        List historicDetails = this.historyService.createHistoricDetailQuery().variableUpdates().list();
        MatcherAssert.assertThat((Object)historicDetails.size(), (Matcher)Is.is((Object)2));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        historicDetails = this.historyService.createHistoricDetailQuery().variableUpdates().list();
        MatcherAssert.assertThat((Object)historicDetails.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupIncident() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS_INCIDENT);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List historicIncidents = this.historyService.createHistoricIncidentQuery().list();
        MatcherAssert.assertThat((Object)historicIncidents.size(), (Matcher)Is.is((Object)2));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        historicIncidents = this.historyService.createHistoricIncidentQuery().list();
        MatcherAssert.assertThat((Object)historicIncidents.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupExternalTaskLog() {
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().serviceTask().camundaExternalTask("anExternalTaskTopic")).endEvent().done());
        this.testRule.deploy(((CallActivityBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().callActivity().calledElement("calledProcess")).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        LockedExternalTask externalTask = (LockedExternalTask)this.externalTaskService.fetchAndLock(1, "aWorkerId").topic("anExternalTaskTopic", 3000L).execute().get(0);
        List externalTaskLogs = this.historyService.createHistoricExternalTaskLogQuery().list();
        MatcherAssert.assertThat((Object)externalTaskLogs.size(), (Matcher)Is.is((Object)1));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.externalTaskService.complete(externalTask.getId(), "aWorkerId");
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        externalTaskLogs = this.historyService.createHistoricExternalTaskLogQuery().list();
        MatcherAssert.assertThat((Object)externalTaskLogs.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupJobLog() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(((UserTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaAsyncBefore()).userTask("userTask").name("userTask")).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        List jobLogs = this.historyService.createHistoricJobLogQuery().processDefinitionKey("process").list();
        MatcherAssert.assertThat((Object)jobLogs.size(), (Matcher)Is.is((Object)2));
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        jobLogs = this.historyService.createHistoricJobLogQuery().processDefinitionKey("process").list();
        MatcherAssert.assertThat((Object)jobLogs.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupUserOperationLog() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(((UserTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaAsyncBefore()).userTask("userTask").name("userTask")).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aUserId");
        this.managementService.setJobRetries(jobId, 65);
        this.identityService.clearAuthentication();
        List userOperationLogs = this.historyService.createUserOperationLogQuery().list();
        MatcherAssert.assertThat((Object)userOperationLogs.size(), (Matcher)Is.is((Object)1));
        this.managementService.executeJob(jobId);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        userOperationLogs = this.historyService.createUserOperationLogQuery().list();
        MatcherAssert.assertThat((Object)userOperationLogs.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupIdentityLink() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.addCandidateUser(taskId, "aUserId");
        List historicIdentityLinkLogs = this.historyService.createHistoricIdentityLinkLogQuery().list();
        MatcherAssert.assertThat((Object)historicIdentityLinkLogs.size(), (Matcher)Is.is((Object)1));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        historicIdentityLinkLogs = this.historyService.createHistoricIdentityLinkLogQuery().list();
        MatcherAssert.assertThat((Object)historicIdentityLinkLogs.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupComment() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        this.taskService.createComment(null, processInstanceId, "aMessage");
        List comments = this.taskService.getProcessInstanceComments(processInstanceId);
        MatcherAssert.assertThat((Object)comments.size(), (Matcher)Is.is((Object)1));
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        comments = this.taskService.getProcessInstanceComments(processInstanceId);
        MatcherAssert.assertThat((Object)comments.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupAttachment() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        this.taskService.createAttachment(null, null, processInstanceId, null, null, "http://camunda.com").getId();
        List attachments = this.taskService.getProcessInstanceAttachments(processInstanceId);
        MatcherAssert.assertThat((Object)attachments.size(), (Matcher)Is.is((Object)1));
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        attachments = this.taskService.getProcessInstanceAttachments(processInstanceId);
        MatcherAssert.assertThat((Object)attachments.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupByteArray() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS_INCIDENT);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricJobLogEventEntity jobLog = (HistoricJobLogEventEntity)this.historyService.createHistoricJobLogQuery().failureLog().singleResult();
        ByteArrayEntity byteArray = this.findByteArrayById(jobLog.getExceptionByteArrayId());
        MatcherAssert.assertThat((Object)byteArray, (Matcher)IsNull.notNullValue());
        this.managementService.setJobRetries(jobId, 0);
        this.managementService.executeJob(jobId);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        byteArray = this.findByteArrayById(jobLog.getExceptionByteArrayId());
        MatcherAssert.assertThat((Object)byteArray, (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldRescheduleCleanupToNow() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        engineConfiguration.setHistoryCleanupBatchSize(6);
        engineConfiguration.setHistoryCleanupBatchWindowStartTime("13:00");
        engineConfiguration.initHistoryCleanup();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        MatcherAssert.assertThat((Object)job.getDuedate(), (Matcher)Is.is((Object)ClockUtil.getCurrentTime()));
    }

    @Test
    public void shouldRescheduleCleanupToLater() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        engineConfiguration.setHistoryCleanupBatchSize(7);
        engineConfiguration.setHistoryCleanupBatchWindowStartTime("13:00");
        engineConfiguration.initHistoryCleanup();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        MatcherAssert.assertThat((Object)job.getDuedate(), (Matcher)Is.is((Object)DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)10)));
    }

    @Test
    public void shouldDistributeWork() {
        this.testRule.deploy(this.PROCESS);
        for (int i = 0; i < 60; ++i) {
            this.runtimeService.startProcessInstanceByKey("process");
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.complete(taskId);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)7));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        CleanableHistoricProcessInstanceReportResult reportResults = (CleanableHistoricProcessInstanceReportResult)this.historyService.createCleanableHistoricProcessInstanceReport().list().get(0);
        MatcherAssert.assertThat((Object)jobs.size(), (Matcher)Is.is((Object)3));
        MatcherAssert.assertThat((Object)reportResults.getCleanableProcessInstanceCount(), (Matcher)Is.is((Object)60L));
        Job jobOne = (Job)jobs.get(0);
        this.jobIds.add(jobOne.getId());
        this.managementService.executeJob(jobOne.getId());
        reportResults = (CleanableHistoricProcessInstanceReportResult)this.historyService.createCleanableHistoricProcessInstanceReport().list().get(0);
        MatcherAssert.assertThat((Object)reportResults.getCleanableProcessInstanceCount(), (Matcher)Is.is((Object)40L));
        Job jobTwo = (Job)jobs.get(1);
        this.jobIds.add(jobTwo.getId());
        this.managementService.executeJob(jobTwo.getId());
        reportResults = (CleanableHistoricProcessInstanceReportResult)this.historyService.createCleanableHistoricProcessInstanceReport().list().get(0);
        MatcherAssert.assertThat((Object)reportResults.getCleanableProcessInstanceCount(), (Matcher)Is.is((Object)20L));
        Job jobThree = (Job)jobs.get(2);
        this.jobIds.add(jobThree.getId());
        this.managementService.executeJob(jobThree.getId());
        reportResults = (CleanableHistoricProcessInstanceReportResult)this.historyService.createCleanableHistoricProcessInstanceReport().list().get(0);
        MatcherAssert.assertThat((Object)reportResults.getCleanableProcessInstanceCount(), (Matcher)Is.is((Object)0L));
    }

    protected List<Job> runHistoryCleanup() {
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        for (Job job : jobs) {
            this.jobIds.add(job.getId());
            this.managementService.executeJob(job.getId());
        }
        return jobs;
    }

    protected ByteArrayEntity findByteArrayById(String byteArrayId) {
        return (ByteArrayEntity)engineConfiguration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(byteArrayId));
    }

    protected void clearJobLog(final String jobId) {
        CommandExecutor commandExecutor = this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                return null;
            }
        });
    }

    protected void clearJob(final String jobId) {
        engineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                JobEntity job = commandContext.getJobManager().findJobById(jobId);
                if (job != null) {
                    commandContext.getJobManager().delete((DbEntity)job);
                }
                return null;
            }
        });
    }

    protected void clearMeterLog() {
        engineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getMeterLogManager().deleteAll();
                return null;
            }
        });
    }
}

