/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.partitioning;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryRemovalTimeProvider;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

public class PartitioningProcessEngineConfigurationTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected static ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        processEngineConfiguration.setHistoryRemovalTimeStrategy(null).setHistoryRemovalTimeProvider(null).initHistoryRemovalTime();
    }

    @AfterClass
    public static void tearDown() {
        processEngineConfiguration.setHistoryRemovalTimeStrategy(null).setHistoryRemovalTimeProvider(null).initHistoryRemovalTime();
    }

    @Test
    public void shouldAutomaticallyConfigure() {
        processEngineConfiguration.setHistoryRemovalTimeProvider(null).setHistoryRemovalTimeStrategy(null);
        processEngineConfiguration.initHistoryRemovalTime();
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeStrategy(), (Matcher)Is.is((Object)"process-end"));
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeProvider(), (Matcher)Is.isA(HistoryRemovalTimeProvider.class));
    }

    @Test
    public void shouldConfigureProviderOnProcessStart() {
        processEngineConfiguration.setHistoryRemovalTimeProvider((HistoryRemovalTimeProvider)Mockito.mock(HistoryRemovalTimeProvider.class)).setHistoryRemovalTimeStrategy("process-start");
        processEngineConfiguration.initHistoryRemovalTime();
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeStrategy(), (Matcher)Is.is((Object)"process-start"));
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeProvider(), (Matcher)Is.isA(HistoryRemovalTimeProvider.class));
    }

    @Test
    public void shouldConfigureProviderOnProcessEnd() {
        processEngineConfiguration.setHistoryRemovalTimeProvider((HistoryRemovalTimeProvider)Mockito.mock(HistoryRemovalTimeProvider.class)).setHistoryRemovalTimeStrategy("process-end");
        processEngineConfiguration.initHistoryRemovalTime();
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeStrategy(), (Matcher)Is.is((Object)"process-end"));
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeProvider(), (Matcher)Is.isA(HistoryRemovalTimeProvider.class));
    }

    @Test
    public void shouldConfigureWithoutProvider() {
        processEngineConfiguration.setHistoryRemovalTimeProvider(null).setHistoryRemovalTimeStrategy("process-end");
        processEngineConfiguration.initHistoryRemovalTime();
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeStrategy(), (Matcher)Is.is((Object)"process-end"));
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeProvider(), (Matcher)Is.isA(HistoryRemovalTimeProvider.class));
    }

    @Test
    public void shouldConfigureWithNotExistentStrategy() {
        processEngineConfiguration.setHistoryRemovalTimeStrategy("notExistentStrategy");
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("history removal time strategy must be either 'process-start' or 'process-end'.");
        processEngineConfiguration.initHistoryRemovalTime();
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeProvider(), (Matcher)Is.isA(HistoryRemovalTimeProvider.class));
    }
}

