/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.CleanableHistoricProcessInstanceReport;
import org.camunda.bpm.engine.history.CleanableHistoricProcessInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@RequiredHistoryLevel(value="full")
public class CleanableHistoricProcessInstanceReportTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testRule).around((TestRule)this.engineRule);
    protected HistoryService historyService;
    protected TaskService taskService;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    @Parameterized.Parameter
    public boolean isHierarchicalCleanup;
    protected boolean isHierarchicalCleanupInitValue;
    protected static final String PROCESS_DEFINITION_KEY = "HISTORIC_INST";
    protected static final String SECOND_PROCESS_DEFINITION_KEY = "SECOND_HISTORIC_INST";
    protected static final String THIRD_PROCESS_DEFINITION_KEY = "THIRD_HISTORIC_INST";
    protected static final String FOURTH_PROCESS_DEFINITION_KEY = "FOURTH_HISTORIC_INST";
    protected static final String HIERARCHICAL_ROOT_PROCESS_DEFINITION_KEY = "ROOT_HIERARCHIC_INST";
    protected static final String HIERARCHICAL_CHILD_PROCESS_DEFINITION_KEY = "CHILD_HIERARCHIC_INST";
    protected static final String DMN_DEFINITION_KEY = "dish-decision";
    protected static final String DRG_DMN = "org/camunda/bpm/engine/test/dmn/deployment/drdMultiLevelDish.dmn11.xml";

    @Parameterized.Parameters(name="Hierachical History Cleanup: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    @Before
    public void setUp() {
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.testRule.deploy(this.createProcessWithUserTask(PROCESS_DEFINITION_KEY));
        this.isHierarchicalCleanupInitValue = this.engineRule.getProcessEngineConfiguration().isHierarchicalHistoryCleanup();
        this.engineRule.getProcessEngineConfiguration().setHierarchicalHistoryCleanup(this.isHierarchicalCleanup);
    }

    @After
    public void cleanUp() {
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        for (Object processInstance : processInstances) {
            this.runtimeService.deleteProcessInstance(processInstance.getId(), null, true, true);
        }
        List tasks = this.taskService.createTaskQuery().list();
        for (Object task : tasks) {
            this.taskService.deleteTask(task.getId(), true);
        }
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
        }
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        for (HistoricDecisionInstance historicProcessInstance : historicDecisionInstances) {
            this.historyService.deleteHistoricDecisionInstanceByInstanceId(historicProcessInstance.getId());
        }
        this.engineRule.getProcessEngineConfiguration().setHierarchicalHistoryCleanup(this.isHierarchicalCleanupInitValue);
    }

    protected BpmnModelInstance createProcessWithUserTask(String key) {
        return ((UserTaskBuilder)Bpmn.createExecutableProcess((String)key).startEvent().userTask(key + "_task1").name(key + " Task 1")).endEvent().done();
    }

    protected BpmnModelInstance[] createHierarchicalProcessWithDmn(String rootKey, String childKey) {
        BpmnModelInstance[] modelInstances = new BpmnModelInstance[]{((CallActivityBuilder)((CallActivityBuilder)((CallActivityBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)rootKey).camundaHistoryTimeToLive(Integer.valueOf(2))).startEvent().callActivity("callActivity").calledElement(childKey)).camundaIn("temperature", "temperature")).camundaIn("dayType", "dayType")).userTask("parentUserTask").endEvent().done(), ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)childKey).camundaHistoryTimeToLive(Integer.valueOf(1))).startEvent().businessRuleTask(DMN_DEFINITION_KEY).camundaDecisionRef(DMN_DEFINITION_KEY)).camundaResultVariable("result")).endEvent("subLastEnd").done()};
        return modelInstances;
    }

    protected void prepareProcessInstances(String key, int daysInThePast, Integer historyTimeToLive, int instanceCount) {
        this.prepareProcessInstances(key, daysInThePast, historyTimeToLive, instanceCount, null);
    }

    protected void prepareProcessInstances(String key, int daysInThePast, Integer historyTimeToLive, int instanceCount, VariableMap variableMap) {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key).list();
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(((ProcessDefinition)processDefinitions.get(0)).getId(), historyTimeToLive);
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)oldCurrentTime, (int)daysInThePast));
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < instanceCount; ++i) {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(key, (Map)variableMap);
            processInstanceIds.add(processInstance.getId());
        }
        this.runtimeService.deleteProcessInstances(processInstanceIds, null, true, true);
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    @Test
    public void testReportComplex() {
        this.testRule.deploy(this.createProcessWithUserTask(SECOND_PROCESS_DEFINITION_KEY));
        this.testRule.deploy(this.createProcessWithUserTask(THIRD_PROCESS_DEFINITION_KEY));
        this.testRule.deploy(this.createProcessWithUserTask(FOURTH_PROCESS_DEFINITION_KEY));
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, 0, 5, 10);
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, -6, 5, 10);
        this.prepareProcessInstances(SECOND_PROCESS_DEFINITION_KEY, -6, 5, 10);
        this.prepareProcessInstances(THIRD_PROCESS_DEFINITION_KEY, -6, null, 10);
        this.prepareProcessInstances(FOURTH_PROCESS_DEFINITION_KEY, -6, 0, 10);
        this.repositoryService.deleteProcessDefinition(((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(SECOND_PROCESS_DEFINITION_KEY).singleResult()).getId(), false);
        List reportResults = this.historyService.createCleanableHistoricProcessInstanceReport().list();
        CleanableHistoricProcessInstanceReportResult secondReportResult = (CleanableHistoricProcessInstanceReportResult)this.historyService.createCleanableHistoricProcessInstanceReport().processDefinitionIdIn(new String[]{((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(THIRD_PROCESS_DEFINITION_KEY).singleResult()).getId()}).singleResult();
        CleanableHistoricProcessInstanceReportResult thirdReportResult = (CleanableHistoricProcessInstanceReportResult)this.historyService.createCleanableHistoricProcessInstanceReport().processDefinitionKeyIn(new String[]{FOURTH_PROCESS_DEFINITION_KEY}).singleResult();
        Assert.assertEquals((long)3L, (long)reportResults.size());
        for (CleanableHistoricProcessInstanceReportResult result : reportResults) {
            if (result.getProcessDefinitionKey().equals(PROCESS_DEFINITION_KEY)) {
                this.checkResultNumbers(result, 10, 20);
                continue;
            }
            if (result.getProcessDefinitionKey().equals(THIRD_PROCESS_DEFINITION_KEY)) {
                this.checkResultNumbers(result, 0, 10);
                continue;
            }
            if (!result.getProcessDefinitionKey().equals(FOURTH_PROCESS_DEFINITION_KEY)) continue;
            this.checkResultNumbers(result, 10, 10);
        }
        this.checkResultNumbers(secondReportResult, 0, 10);
        this.checkResultNumbers(thirdReportResult, 10, 10);
    }

    private void checkResultNumbers(CleanableHistoricProcessInstanceReportResult result, int expectedCleanable, int expectedFinished) {
        Assert.assertEquals((long)expectedCleanable, (long)result.getCleanableProcessInstanceCount());
        Assert.assertEquals((long)expectedFinished, (long)result.getFinishedProcessInstanceCount());
    }

    @Test
    public void testReportWithAllCleanableInstances() {
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, -6, 5, 10);
        List reportResults = this.historyService.createCleanableHistoricProcessInstanceReport().list();
        long count = this.historyService.createCleanableHistoricProcessInstanceReport().count();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        Assert.assertEquals((long)1L, (long)count);
        this.checkResultNumbers((CleanableHistoricProcessInstanceReportResult)reportResults.get(0), 10, 10);
    }

    @Test
    public void testReportWithPartiallyCleanableInstances() {
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, -6, 5, 5);
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, 0, 5, 5);
        List reportResults = this.historyService.createCleanableHistoricProcessInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        this.checkResultNumbers((CleanableHistoricProcessInstanceReportResult)reportResults.get(0), 5, 10);
    }

    @Test
    public void testReportWithZeroHistoryTTL() {
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, -6, 0, 5);
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, 0, 0, 5);
        CleanableHistoricProcessInstanceReportResult result = (CleanableHistoricProcessInstanceReportResult)this.historyService.createCleanableHistoricProcessInstanceReport().singleResult();
        this.checkResultNumbers(result, 10, 10);
    }

    @Test
    public void testReportWithNullHistoryTTL() {
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, -6, null, 5);
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, 0, null, 5);
        List reportResults = this.historyService.createCleanableHistoricProcessInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        this.checkResultNumbers((CleanableHistoricProcessInstanceReportResult)reportResults.get(0), 0, 10);
    }

    @Test
    public void testReportByInvalidProcessDefinitionId() {
        CleanableHistoricProcessInstanceReport report = this.historyService.createCleanableHistoricProcessInstanceReport();
        try {
            report.processDefinitionIdIn(null);
            TestCase.fail((String)"Expected NotValidException");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            report.processDefinitionIdIn(new String[]{"abc", null, "def"});
            TestCase.fail((String)"Expected NotValidException");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testReportByInvalidProcessDefinitionKey() {
        CleanableHistoricProcessInstanceReport report = this.historyService.createCleanableHistoricProcessInstanceReport();
        try {
            report.processDefinitionKeyIn(null);
            TestCase.fail((String)"Expected NotValidException");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            report.processDefinitionKeyIn(new String[]{"abc", null, "def"});
            TestCase.fail((String)"Expected NotValidException");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testReportCompact() {
        List pdList = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).list();
        Assert.assertEquals((long)1L, (long)pdList.size());
        this.runtimeService.startProcessInstanceById(((ProcessDefinition)pdList.get(0)).getId());
        List resultWithZeros = this.historyService.createCleanableHistoricProcessInstanceReport().list();
        Assert.assertEquals((long)1L, (long)resultWithZeros.size());
        Assert.assertEquals((long)0L, (long)((CleanableHistoricProcessInstanceReportResult)resultWithZeros.get(0)).getFinishedProcessInstanceCount());
        long resultCountWithoutZeros = this.historyService.createCleanableHistoricProcessInstanceReport().compact().count();
        Assert.assertEquals((long)0L, (long)resultCountWithoutZeros);
    }

    @Test
    public void testReportOrderByFinishedAsc() {
        this.testRule.deploy(this.createProcessWithUserTask(SECOND_PROCESS_DEFINITION_KEY));
        this.testRule.deploy(this.createProcessWithUserTask(THIRD_PROCESS_DEFINITION_KEY));
        this.prepareProcessInstances(SECOND_PROCESS_DEFINITION_KEY, -6, 5, 6);
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, -6, 5, 4);
        this.prepareProcessInstances(THIRD_PROCESS_DEFINITION_KEY, -6, 5, 8);
        List reportResult = ((CleanableHistoricProcessInstanceReport)this.historyService.createCleanableHistoricProcessInstanceReport().orderByFinished().asc()).list();
        Assert.assertEquals((long)3L, (long)reportResult.size());
        Assert.assertEquals((Object)PROCESS_DEFINITION_KEY, (Object)((CleanableHistoricProcessInstanceReportResult)reportResult.get(0)).getProcessDefinitionKey());
        Assert.assertEquals((Object)SECOND_PROCESS_DEFINITION_KEY, (Object)((CleanableHistoricProcessInstanceReportResult)reportResult.get(1)).getProcessDefinitionKey());
        Assert.assertEquals((Object)THIRD_PROCESS_DEFINITION_KEY, (Object)((CleanableHistoricProcessInstanceReportResult)reportResult.get(2)).getProcessDefinitionKey());
    }

    @Test
    public void testReportOrderByFinishedDesc() {
        this.testRule.deploy(this.createProcessWithUserTask(SECOND_PROCESS_DEFINITION_KEY));
        this.testRule.deploy(this.createProcessWithUserTask(THIRD_PROCESS_DEFINITION_KEY));
        this.prepareProcessInstances(SECOND_PROCESS_DEFINITION_KEY, -6, 5, 6);
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, -6, 5, 4);
        this.prepareProcessInstances(THIRD_PROCESS_DEFINITION_KEY, -6, 5, 8);
        List reportResult = ((CleanableHistoricProcessInstanceReport)this.historyService.createCleanableHistoricProcessInstanceReport().orderByFinished().desc()).list();
        Assert.assertEquals((long)3L, (long)reportResult.size());
        Assert.assertEquals((Object)THIRD_PROCESS_DEFINITION_KEY, (Object)((CleanableHistoricProcessInstanceReportResult)reportResult.get(0)).getProcessDefinitionKey());
        Assert.assertEquals((Object)SECOND_PROCESS_DEFINITION_KEY, (Object)((CleanableHistoricProcessInstanceReportResult)reportResult.get(1)).getProcessDefinitionKey());
        Assert.assertEquals((Object)PROCESS_DEFINITION_KEY, (Object)((CleanableHistoricProcessInstanceReportResult)reportResult.get(2)).getProcessDefinitionKey());
    }

    @Test
    public void testReportOnHierarchicalData() {
        this.testRule.deploy(DRG_DMN);
        this.testRule.deploy(this.createHierarchicalProcessWithDmn(HIERARCHICAL_ROOT_PROCESS_DEFINITION_KEY, HIERARCHICAL_CHILD_PROCESS_DEFINITION_KEY));
        this.updateDecisionDefinitionHistoryTTL(DMN_DEFINITION_KEY, 5);
        this.updateDecisionDefinitionHistoryTTL("feels", 5);
        this.updateDecisionDefinitionHistoryTTL("guestCount", 5);
        this.prepareProcessInstances(HIERARCHICAL_ROOT_PROCESS_DEFINITION_KEY, -3, 2, 1, Variables.createVariables().putValue("temperature", (Object)21).putValue("dayType", (Object)"WeekDay"));
        List reportResult = this.historyService.createCleanableHistoricProcessInstanceReport().processDefinitionKeyIn(new String[]{HIERARCHICAL_CHILD_PROCESS_DEFINITION_KEY, HIERARCHICAL_ROOT_PROCESS_DEFINITION_KEY}).list();
        List decisionReportResult = this.historyService.createCleanableHistoricDecisionInstanceReport().decisionDefinitionKeyIn(new String[]{"guestCount", "feels", DMN_DEFINITION_KEY}).list();
        Assert.assertEquals((long)2L, (long)reportResult.size());
        Assert.assertEquals((long)3L, (long)decisionReportResult.size());
    }

    private void updateDecisionDefinitionHistoryTTL(String decisionDefinitionKey, int newHistoryTimeToLive) {
        String definitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(decisionDefinitionKey).singleResult()).getId();
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(definitionId, Integer.valueOf(newHistoryTimeToLive));
    }
}

