/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupContext;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobDeclaration;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyManager;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.runtime.Job;

public class HistoryCleanupCmd
implements Command<Job> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    public static final JobDeclaration HISTORY_CLEANUP_JOB_DECLARATION = new HistoryCleanupJobDeclaration();
    public static final int MAX_THREADS_NUMBER = 8;
    private boolean immediatelyDue;

    public HistoryCleanupCmd(boolean immediatelyDue) {
        this.immediatelyDue = immediatelyDue;
    }

    @Override
    public Job execute(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        authorizationManager.checkCamundaAdmin();
        if (!this.willBeScheduled()) {
            LOG.debugHistoryCleanupWrongConfiguration();
        }
        List<Job> historyCleanupJobs = this.getHistoryCleanupJobs();
        boolean isHierarchicalHistoryCleanup = processEngineConfiguration.isHierarchicalHistoryCleanup();
        int degreeOfParallelism = processEngineConfiguration.getHistoryCleanupDegreeOfParallelism();
        int[][] minuteChunks = HistoryCleanupHelper.listMinuteChunks(degreeOfParallelism);
        if (this.shouldCreateJobs(historyCleanupJobs)) {
            historyCleanupJobs = this.createJobs(degreeOfParallelism, minuteChunks, isHierarchicalHistoryCleanup);
        } else if (this.shouldReconfigureJobs(historyCleanupJobs)) {
            historyCleanupJobs = this.reconfigureJobs(historyCleanupJobs, degreeOfParallelism, minuteChunks, isHierarchicalHistoryCleanup);
        } else if (this.shouldSuspendJobs(historyCleanupJobs)) {
            this.suspendJobs(historyCleanupJobs);
        }
        return historyCleanupJobs.size() > 0 ? historyCleanupJobs.get(0) : null;
    }

    protected List<Job> getHistoryCleanupJobs() {
        CommandContext commandContext = Context.getCommandContext();
        return commandContext.getJobManager().findJobsByHandlerType("history-cleanup");
    }

    protected boolean shouldCreateJobs(List<Job> jobs) {
        return jobs.isEmpty() && this.willBeScheduled();
    }

    protected boolean shouldReconfigureJobs(List<Job> jobs) {
        return !jobs.isEmpty() && this.willBeScheduled();
    }

    protected boolean shouldSuspendJobs(List<Job> jobs) {
        return !jobs.isEmpty() && !this.willBeScheduled();
    }

    protected boolean willBeScheduled() {
        CommandContext commandContext = Context.getCommandContext();
        return this.immediatelyDue || HistoryCleanupHelper.isBatchWindowConfigured(commandContext);
    }

    protected List<Job> createJobs(int degreeOfParallelism, int[][] minuteChunks, boolean isHierachicalHistoryCleanup) {
        CommandContext commandContext = Context.getCommandContext();
        PropertyManager propertyManager = commandContext.getPropertyManager();
        JobManager jobManager = commandContext.getJobManager();
        propertyManager.acquireExclusiveLockForHistoryCleanupJob();
        List<Job> historyCleanupJobs = this.getHistoryCleanupJobs();
        if (historyCleanupJobs.isEmpty()) {
            for (int[] minuteChunk : minuteChunks) {
                JobEntity job = this.createJob(minuteChunk, isHierachicalHistoryCleanup);
                jobManager.insertAndHintJobExecutor(job);
                historyCleanupJobs.add(job);
            }
        }
        return historyCleanupJobs;
    }

    protected List<Job> reconfigureJobs(List<Job> historyCleanupJobs, int degreeOfParallelism, int[][] minuteChunks, boolean isHierarchicalHistoryCleanup) {
        block4: {
            JobEntity job;
            int delta;
            int size;
            JobManager jobManager;
            block3: {
                CommandContext commandContext = Context.getCommandContext();
                jobManager = commandContext.getJobManager();
                size = Math.min(degreeOfParallelism, historyCleanupJobs.size());
                for (int i = 0; i < size; ++i) {
                    JobEntity historyCleanupJob = (JobEntity)historyCleanupJobs.get(i);
                    HistoryCleanupContext historyCleanupContext = this.createCleanupContext(minuteChunks[i], isHierarchicalHistoryCleanup);
                    HISTORY_CLEANUP_JOB_DECLARATION.reconfigure(historyCleanupContext, historyCleanupJob);
                    Date newDueDate = HISTORY_CLEANUP_JOB_DECLARATION.resolveDueDate(historyCleanupContext);
                    jobManager.reschedule(historyCleanupJob, newDueDate);
                }
                delta = degreeOfParallelism - historyCleanupJobs.size();
                if (delta <= 0) break block3;
                for (int i = size; i < degreeOfParallelism; ++i) {
                    job = this.createJob(minuteChunks[i], isHierarchicalHistoryCleanup);
                    jobManager.insertAndHintJobExecutor(job);
                    historyCleanupJobs.add(job);
                }
                break block4;
            }
            if (delta >= 0) break block4;
            ListIterator<Job> iterator = historyCleanupJobs.listIterator(size);
            while (iterator.hasNext()) {
                job = (JobEntity)iterator.next();
                jobManager.deleteJob(job);
                iterator.remove();
            }
        }
        return historyCleanupJobs;
    }

    protected void suspendJobs(List<Job> jobs) {
        for (Job job : jobs) {
            JobEntity jobInstance = (JobEntity)job;
            jobInstance.setSuspensionState(SuspensionState.SUSPENDED.getStateCode());
            jobInstance.setDuedate(null);
        }
    }

    protected JobEntity createJob(int[] minuteChunk, boolean isHierarchicalHistoryCleanup) {
        HistoryCleanupContext historyCleanupContext = this.createCleanupContext(minuteChunk, isHierarchicalHistoryCleanup);
        return HISTORY_CLEANUP_JOB_DECLARATION.createJobInstance(historyCleanupContext);
    }

    protected HistoryCleanupContext createCleanupContext(int[] minuteChunk, boolean isHierarchicalHistoryCleanup) {
        int minuteFrom = minuteChunk[0];
        int minuteTo = minuteChunk[1];
        return new HistoryCleanupContext(this.immediatelyDue, minuteFrom, minuteTo, isHierarchicalHistoryCleanup);
    }
}

